/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SrmUtil;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.enumerate.PurchaseSampleCheckProjectSyncEnum;
import com.els.modules.sample.mapper.PurchaseSampleCheckItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseSampleCheckAuditOptCallBackAdapter")
public class PurchaseSampleCheckAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseSampleCheckHeadService purchaseSampleCheckHeadService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSampleItemService purchaseSampleItemService;
    @Resource
    private PurchaseSampleHeadService purchaseSampleHeadService;
    @Resource
    private PurchaseSampleCheckItemMapper purchaseSampleCheckItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseSampleCheckHead purchaseStandardHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseStandardHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        PurchaseSampleCheckHeadVO purchaseSampleCheckHeadVO = new PurchaseSampleCheckHeadVO();
        purchaseStandardHead.setQualified(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getQualified());
        purchaseStandardHead.setCheckResult(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getCheckResult());
        purchaseStandardHead.setSampleQuantity(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getSampleQuantity());
        purchaseStandardHead.setQualifiedQuantity(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getQualifiedQuantity());
        purchaseStandardHead.setDefectiveQuantity(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getDefectiveQuantity());
        purchaseStandardHead.setQualifiedRate(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getQualifiedRate());
        purchaseStandardHead.setResultAudit(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getResultAudit());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseStandardHead);
        PurchaseSampleItem sampleItem = (PurchaseSampleItem)((Object)this.purchaseSampleItemService.getById((Serializable)((Object)purchaseStandardHead.getSampleItemId())));
        BigDecimal newCheckedQuantity = sampleItem.getCheckedQuantity().add(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getSampleQuantity());
        UpdateWrapper sampleItemQueryWrapper = new UpdateWrapper();
        sampleItemQueryWrapper.lambda().eq(ParentEntity::getId, (Object)purchaseStandardHead.getSampleItemId());
        sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getCheckedQuantity, (Object)newCheckedQuantity);
        sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getAvailableQuantity, (Object)sampleItem.getRepertoryQuantity().subtract(newCheckedQuantity));
        this.purchaseSampleItemService.update((Wrapper)sampleItemQueryWrapper);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseSampleCheckHead.setId(flowCallbackDTO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        purchaseSampleCheckHead.setResultSync(PurchaseSampleCheckProjectSyncEnum.SYNC.getValue());
        purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        Date now = new Date();
        purchaseSampleCheckHead.setCheckEndDate(now);
        if ("1".equals(purchaseSampleCheckHead.getResultSync())) {
            List<PurchaseSampleCheckItem> purchaseSampleCheckItems = this.purchaseSampleCheckItemMapper.selectByMainId(purchaseSampleCheckHead.getId());
            List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseSampleCheckHead.getId());
            this.purchaseSampleCheckHeadService.syncSimpleCheckToSale(purchaseSampleCheckHead, purchaseSampleCheckItems, attachmentList);
        }
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
        trackingItem.setSampleId(purchaseSampleCheckHead.getId());
        trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
        trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
        Date date = new Date();
        trackingItem.setActualEndTime(new Date());
        trackingItem.setActualEndTime(date);
        if (purchaseSampleCheckHead.getCheckStartDate() != null) {
            trackingItem.setEstimatedTimePeriod("" + (date.getTime() - purchaseSampleCheckHead.getCheckStartDate().getTime()) / 86400000L);
        }
        this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        purchaseSampleCheckHead.setId(flowCallbackDTO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        PurchaseSampleCheckHead selectSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        this.deductCheckedQuantity(flowCallbackDTO.getBusinessId());
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        purchaseSampleCheckHead.setId(flowCallbackDTO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        PurchaseSampleCheckHead selectSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        if (!selectSampleCheckHead.getAuditStatus().equals(purchaseSampleCheckHead.getAuditStatus())) {
            this.deductCheckedQuantity(flowCallbackDTO.getBusinessId());
        }
    }

    public Map<String, Object> getById(String id) {
        PurchaseSampleCheckHead head = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void deductCheckedQuantity(String sampleCheckId) {
        PurchaseSampleCheckHead sampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)sampleCheckId)));
        PurchaseSampleItem sampleItem = (PurchaseSampleItem)((Object)this.purchaseSampleItemService.getById((Serializable)((Object)sampleCheckHead.getSampleItemId())));
        BigDecimal checkedQuantity = sampleItem.getCheckedQuantity().subtract(sampleCheckHead.getSampleQuantity());
        UpdateWrapper sampleItemUpdateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)sampleItemUpdateWrapper.lambda().set(PurchaseSampleItem::getCheckedQuantity, (Object)checkedQuantity)).set(PurchaseSampleItem::getAvailableQuantity, (Object)sampleItem.getRepertoryQuantity().subtract(checkedQuantity))).eq(ParentEntity::getId, (Object)sampleItem.getId());
        this.purchaseSampleItemService.update((Wrapper)sampleItemUpdateWrapper);
    }
}

