/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.caigouwang.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.caigouwang.entity.CaigouInquires;
import com.els.modules.caigouwang.mapper.CaigouInquiresMapper;
import com.els.modules.caigouwang.service.CaigouInquiresService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CaigouInquiresServiceImpl
extends BaseServiceImpl<CaigouInquiresMapper, CaigouInquires>
implements CaigouInquiresService {
    @Value(value="${b2b.business-opportunity}")
    private String address;
    private static String INQUIRES_URL = "business/web/inquiry/inquires";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private CaigouInquiresMapper caigouInquiresMapper;

    @Override
    public void saveCaigouInquires(CaigouInquires caigouInquires) {
        ((CaigouInquiresMapper)this.baseMapper).insert((Object)caigouInquires);
    }

    @Override
    public void updateCaigouInquires(CaigouInquires caigouInquires) {
        ((CaigouInquiresMapper)this.baseMapper).updateById((Object)caigouInquires);
    }

    @Override
    public void delCaigouInquires(String id) {
        ((CaigouInquiresMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchCaigouInquires(List<String> idList) {
        ((CaigouInquiresMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void handleData(CaigouInquires caigouInquires, Integer pageNo, Integer pageSize) {
        this.syncGetData();
    }

    @Async
    public void syncGetData() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select((Object[])new String[]{"create_time"});
        wrapper.orderByDesc((Object)"create_time");
        List list = this.list((Wrapper)wrapper);
        String startTimeStr = null;
        String endTimeStr = null;
        if (!list.isEmpty()) {
            startTimeStr = sdf.format(((CaigouInquires)((Object)list.get(0))).getCreateTime());
            endTimeStr = sdf.format(new Date());
        }
        String url = null;
        url = startTimeStr == null ? this.address + INQUIRES_URL + "?size=100&current=1" : this.address + INQUIRES_URL + "?startTimeStr=" + startTimeStr + "&endTimeStr=" + endTimeStr + "&size=100&current=1";
        String response = HttpRequest.get((String)url).execute().body();
        JSONObject result = JSONObject.parseObject((String)response);
        if (result.getBoolean("success").booleanValue()) {
            ArrayList replenishList = new ArrayList();
            JSONObject data = result.getJSONObject("data");
            Integer total = data.getInteger("total");
            Integer size = data.getInteger("size");
            Integer current = data.getInteger("current");
            Integer pages = data.getInteger("pages");
            if (total != null && total > 0) {
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouInquires.class);
                replenishList.addAll(lists);
            }
            for (int i = current.intValue(); i < pages; ++i) {
                Integer n = current;
                current = current + 1;
                url = startTimeStr == null ? this.address + INQUIRES_URL + "?size=100&current=" + current : this.address + INQUIRES_URL + "?startTimeStr=" + startTimeStr + "&endTimeStr=" + endTimeStr + "&size=100&current=" + current;
                response = HttpRequest.get((String)url).execute().body();
                result = JSONObject.parseObject((String)response);
                if (!result.getBoolean("success").booleanValue()) continue;
                data = result.getJSONObject("data");
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouInquires.class);
                replenishList.addAll(lists);
            }
            if (replenishList.size() > 0 && !list.isEmpty()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                cal.add(5, 1);
                Date date2 = cal.getTime();
                this.caigouInquiresMapper.deleteByTime(startTimeStr, sdf.format(date2));
            }
            this.saveBatch(replenishList);
        }
    }
}

