/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcd.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.modules.mcd.entity.PurchaseMcdCollect;
import com.els.modules.mcd.entity.PurchaseMcdDetail;
import com.els.modules.mcd.service.PurchaseMcdCollectService;
import com.els.modules.mcd.service.PurchaseMcdDetailService;
import com.els.modules.mcd.service.SaleMcdDetailService;
import com.els.modules.mcd.vo.PurchaseMcdCollectVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mcdcollect/purchaseMcdCollect"})
@Tag(name="MCD\u8d44\u6599\u6536\u96c6\u5355")
public class PurchaseMcdCollectController
extends BaseController<PurchaseMcdCollect, PurchaseMcdCollectService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseMcdCollectController.class);
    @Autowired
    private PurchaseMcdCollectService purchaseMcdCollectService;
    @Autowired
    private PurchaseMcdDetailService purchaseMcdDetailService;
    @Autowired
    private PurchaseAttachmentRpcService purchaseAttachmentRpcService;
    @Resource
    private SaleMcdDetailService saleMcdDetailService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"gpmManagement#PurchaseMcdCollect:list"})
    public Result<?> queryPageList(PurchaseMcdCollect purchaseMcdCollect, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMcdCollect), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMcdCollectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"gpmManagement#PurchaseMcdCollect:add"})
    public Result<?> add(@RequestBody PurchaseMcdCollectVO purchaseMcdCollectPage) {
        PurchaseMcdCollect purchaseMcdCollect = new PurchaseMcdCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseMcdCollectPage), (Object)((Object)purchaseMcdCollect));
        Boolean isSuccess = this.purchaseMcdCollectService.saveMain(purchaseMcdCollect);
        if (isSuccess.booleanValue()) {
            return Result.ok((Object)((Object)purchaseMcdCollect));
        }
        return Result.error((int)10086, (String)I18nUtil.translate((String)"i18n_alert_LYuRdXWVKHnRIcLDRQXjRdXNAJju_ae2c2ef5", (String)"\u672a\u627e\u5230\u4f9b\u5e94\u5546\uff0c\u8bf7\u8054\u7cfbCEG\u7ef4\u62a4\u5236\u9020\u5546\u7684\u4f9b\u5e94\u5546\u54c1\u7c7b\u8d44\u6e90\u6c60"));
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"gpmManagement#PurchaseMcdCollect:edit"})
    public Result<?> edit(@RequestBody PurchaseMcdCollect purchaseMcdCollect) {
        this.purchaseMcdCollectService.updateById((Object)purchaseMcdCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:submit"})
    public Result<?> publish(@RequestBody List<PurchaseMcdCollect> purchaseMcdCollectList) {
        for (PurchaseMcdCollect purchaseMcdCollect : purchaseMcdCollectList) {
            this.purchaseMcdCollectService.publish(purchaseMcdCollect);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publishOne"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:submit"})
    public Result<?> publishOne(@RequestBody PurchaseMcdCollect purchaseMcdCollect) {
        this.purchaseMcdCollectService.publish(purchaseMcdCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseMcdCollectService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseMcdCollectService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u786e\u8ba4")
    @Operation(summary="\u786e\u8ba4", description="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:edit"})
    public Result<?> confirm(@RequestBody PurchaseMcdCollect purchaseMcdCollect) {
        this.purchaseMcdCollectService.confirm(purchaseMcdCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u9a73\u56de")
    @Operation(summary="\u9a73\u56de", description="\u9a73\u56de")
    @PostMapping(value={"/refused"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:reject"})
    public Result<?> refused(@RequestBody PurchaseMcdCollect purchaseMcdCollect) {
        this.purchaseMcdCollectService.refused(purchaseMcdCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u4f5c\u5e9f")
    @Operation(summary="\u4f5c\u5e9f", description="\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:invalid"})
    public Result<?> invalid(@RequestParam(name="id") String id) {
        PurchaseMcdCollect purchaseMcdCollect = (PurchaseMcdCollect)((Object)this.purchaseMcdCollectService.getById((Serializable)((Object)id)));
        this.purchaseMcdCollectService.invalid(purchaseMcdCollect);
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMcdCollect purchaseMcdCollect = (PurchaseMcdCollect)((Object)this.purchaseMcdCollectService.getById((Serializable)((Object)id)));
        PurchaseMcdCollectVO purchaseMcdCollectVO = new PurchaseMcdCollectVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMcdCollect), (Object)((Object)purchaseMcdCollectVO));
        List<PurchaseMcdDetail> list = this.purchaseMcdDetailService.selectByMainId(id);
        List<PurchaseMcdDetail> purchaseMcdReachList = list.stream().filter(e -> new BigDecimal("1000").compareTo(StrUtil.isNotBlank((CharSequence)e.getPpmWeight()) ? NumberUtils.createBigDecimal((String)e.getPpmWeight()) : NumberUtils.createBigDecimal((String)"0")) < 0).collect(Collectors.toList());
        List<String> casnoList = purchaseMcdReachList.stream().map(PurchaseMcdDetail::getCasno).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(casnoList)) {
            List<String> reachList = this.saleMcdDetailService.selectSystemReachByCasnoList(casnoList);
            purchaseMcdReachList = purchaseMcdReachList.stream().filter(e -> reachList.contains(e.getCasno())).collect(Collectors.toList());
        }
        purchaseMcdCollectVO.setPurchaseMcdDetailList(list);
        purchaseMcdCollectVO.setPurchaseMcdReachList(purchaseMcdReachList);
        List purchaseAttachmentDTOS = this.purchaseAttachmentRpcService.selectByMainId(id);
        purchaseMcdCollectVO.setPurchaseAttachmentDTOList(purchaseAttachmentDTOS);
        return Result.ok((Object)((Object)purchaseMcdCollectVO));
    }

    @Operation(summary="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"gpmManagement#purchaseMcdCollect:list"})
    public Result<?> queryTabsCount(PurchaseMcdCollect purchaseMcdCollect, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        Map stringMap = req.getParameterMap();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMcdCollect), (Map)stringMap);
        queryWrapper.select((Object[])new String[]{"collect_status"});
        List list = ((PurchaseMcdCollectService)this.service).list((Wrapper)queryWrapper);
        Integer all = list.size();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "collectStatus", null, (long)all.intValue()));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("mcdCollectStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = list.stream().filter(pct -> String.valueOf(pct.getCollectStatus()).equals(status.getValue())).collect(Collectors.toList()).size();
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "collectStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }
}

