/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.SaleMouldData;
import com.els.modules.mould.entity.SaleMouldTransferHead;
import com.els.modules.mould.entity.SaleMouldTransferItem;
import com.els.modules.mould.enumerate.MouldStatusEnum;
import com.els.modules.mould.mapper.PurchaseMouldDataMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.SaleMouldDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseMouldDataServiceImpl
extends BaseServiceImpl<PurchaseMouldDataMapper, PurchaseMouldData>
implements PurchaseMouldDataService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleMouldDataService saleMouldDataService;

    @Override
    public void savePurchaseMouldData(PurchaseMouldData purchaseMouldData) {
        purchaseMouldData.setBusAccount(TenantContext.getTenant());
        purchaseMouldData.setMouldStatus(MouldStatusEnum.NEW.getValue());
        ((PurchaseMouldDataMapper)this.baseMapper).insert((Object)purchaseMouldData);
    }

    @Override
    public void updatePurchaseMouldData(PurchaseMouldData purchaseMouldData) {
        purchaseMouldData.setBusAccount(TenantContext.getTenant());
        purchaseMouldData.setMouldStatus(MouldStatusEnum.NEW.getValue());
        ((PurchaseMouldDataMapper)this.baseMapper).updateById((Object)purchaseMouldData);
    }

    @Override
    public void publish(PurchaseMouldData purchaseMouldData) {
        if (StrUtil.isBlank((CharSequence)purchaseMouldData.getMouldGroupNumber())) {
            String mouldGroupNumber = this.invokeBaseRpcService.getNextCode("mouldGroupNumber", (Object)purchaseMouldData);
            purchaseMouldData.setMouldGroupNumber(mouldGroupNumber);
        }
        String mouldNumber = this.invokeBaseRpcService.getNextCode("mouldNumber", (Object)purchaseMouldData);
        purchaseMouldData.setMouldNumber(mouldNumber);
        purchaseMouldData.setRelationId(IdWorker.getIdStr());
        purchaseMouldData.setMouldStatus(MouldStatusEnum.AVAILABLE.getValue());
        purchaseMouldData.setPurchaseName(SysUtil.getLoginUser().getCompanyName());
        ((PurchaseMouldDataMapper)this.baseMapper).updateById((Object)purchaseMouldData);
        this.saleMouldDataService.add(purchaseMouldData);
    }

    @Override
    public void transfer(SaleMouldTransferHead dbHead, List<SaleMouldTransferItem> itemList) {
        String mouldStatus = dbHead.getId().equals(dbHead.getReceiveId()) ? MouldStatusEnum.AVAILABLE.getValue() : MouldStatusEnum.MIGRATING.getValue();
        ArrayList<PurchaseMouldData> updatePurchaseList = new ArrayList<PurchaseMouldData>();
        if (MouldStatusEnum.AVAILABLE.getValue().equals(mouldStatus)) {
            for (SaleMouldTransferItem item : itemList) {
                PurchaseMouldData updatePurchase = new PurchaseMouldData();
                updatePurchase.setId(item.getMouldDataId());
                updatePurchase.setMouldStatus(mouldStatus);
                updatePurchase.setToElsAccount(dbHead.getReceiveElsAccount());
                updatePurchase.setSupplierCode(dbHead.getReceiveSupplierCode());
                updatePurchase.setSupplierName(dbHead.getReceiveSupplierName());
                updatePurchaseList.add(updatePurchase);
                SaleMouldData updateSale = new SaleMouldData();
                updateSale.setMouldStatus(mouldStatus);
                updateSale.setSupplierCode(dbHead.getReceiveSupplierCode());
                updateSale.setSupplierName(dbHead.getReceiveSupplierName());
                updateSale.setElsAccount(dbHead.getReceiveElsAccount());
                this.saleMouldDataService.update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().eq(SaleMouldData::getRelationId, (Object)item.getMouldDataId()));
            }
        } else {
            for (SaleMouldTransferItem item : itemList) {
                PurchaseMouldData updatePurchase = new PurchaseMouldData();
                updatePurchase.setId(item.getMouldDataId());
                updatePurchase.setMouldStatus(mouldStatus);
                updatePurchaseList.add(updatePurchase);
                SaleMouldData updateSale = new SaleMouldData();
                updateSale.setMouldStatus(mouldStatus);
                this.saleMouldDataService.update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().eq(SaleMouldData::getRelationId, (Object)item.getMouldDataId()));
            }
        }
        this.updateBatchById(updatePurchaseList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void copyById(String id) {
        PurchaseMouldData purchaseMouldData = (PurchaseMouldData)((Object)this.getById((Serializable)((Object)id)));
        PurchaseMouldData purchaseMouldData1 = new PurchaseMouldData();
        BeanUtils.copyProperties((Object)((Object)purchaseMouldData), (Object)((Object)purchaseMouldData1));
        purchaseMouldData1.setId(String.valueOf(IdWorker.getId()));
        purchaseMouldData1.setMouldNumber(null);
        purchaseMouldData1.setElsAccount(TenantContext.getTenant());
        purchaseMouldData1.setCreateBy(null);
        purchaseMouldData1.setCreateById(null);
        purchaseMouldData1.setUpdateById(null);
        purchaseMouldData1.setCreateTime(null);
        purchaseMouldData1.setUpdateBy(null);
        purchaseMouldData1.setUpdateTime(null);
        purchaseMouldData1.setMouldStatus("0");
        purchaseMouldData1.setRelationId(null);
        ((PurchaseMouldDataMapper)this.baseMapper).insert((Object)purchaseMouldData1);
    }
}

