/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.modules.report.entity.ElsTimeWindowSetting;
import com.els.modules.report.mapper.ElsTimeWindowSettingMapper;
import com.els.modules.report.service.ElsTimeWindowSettingService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsTimeWindowSettingServiceImpl
extends ServiceImpl<ElsTimeWindowSettingMapper, ElsTimeWindowSetting>
implements ElsTimeWindowSettingService {
    @Autowired
    private ElsTimeWindowSettingMapper elsTimeWindowSettingMapper;

    @Override
    public void saveElsTimeWindowSetting(ElsTimeWindowSetting elsTimeWindowSetting) {
        this.checkTimeWindowToleranceSetting(elsTimeWindowSetting);
        ((ElsTimeWindowSettingMapper)this.baseMapper).insert((Object)elsTimeWindowSetting);
    }

    @Override
    public void updateElsTimeWindowSetting(ElsTimeWindowSetting elsTimeWindowSetting) {
        this.checkTimeWindowToleranceSetting(elsTimeWindowSetting);
        int count = ((ElsTimeWindowSettingMapper)this.baseMapper).updateById((Object)elsTimeWindowSetting);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delElsTimeWindowSetting(String id) {
        ((ElsTimeWindowSettingMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTimeWindowSetting(List<String> idList) {
        ((ElsTimeWindowSettingMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private void checkTimeWindowToleranceSetting(ElsTimeWindowSetting elsTimeWindowSetting) {
        String toElsAccount = elsTimeWindowSetting.getToElsAccount();
        LambdaQueryWrapper elsTimeWindowSettingLambdaQueryWrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)toElsAccount)) {
            elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getToElsAccount, (Object)toElsAccount);
            elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getWindowType, (Object)elsTimeWindowSetting.getWindowType());
            if (StrUtil.isNotBlank((CharSequence)elsTimeWindowSetting.getId())) {
                elsTimeWindowSettingLambdaQueryWrapper.ne(ParentEntity::getId, (Object)elsTimeWindowSetting.getId());
            } else {
                elsTimeWindowSettingLambdaQueryWrapper.last("and( id is not null )");
            }
            List elsTimeWindowSettings = this.elsTimeWindowSettingMapper.selectList((Wrapper)elsTimeWindowSettingLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)elsTimeWindowSettings)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXWWWWWIOGRrKIcVWxOVBGRW_6c7404e7", (String)"\u4f9b\u5e94\u5546:${0}\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u65f6\u95f4\u7a97\u53e3\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e!", (String[])new String[]{toElsAccount}));
            }
        } else if (StrUtil.isBlank((CharSequence)toElsAccount) && StrUtil.isNotBlank((CharSequence)elsTimeWindowSetting.getAccountGroup())) {
            elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getAccountGroup, (Object)elsTimeWindowSetting.getAccountGroup());
            elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getWindowType, (Object)elsTimeWindowSetting.getWindowType());
            if (StrUtil.isNotBlank((CharSequence)elsTimeWindowSetting.getId())) {
                elsTimeWindowSettingLambdaQueryWrapper.ne(ParentEntity::getId, (Object)elsTimeWindowSetting.getId());
            } else {
                elsTimeWindowSettingLambdaQueryWrapper.last("and( id is not null )");
            }
            elsTimeWindowSettingLambdaQueryWrapper.last("and (to_els_account is null or to_els_account='' )");
            List elsTimeWindowToleranceSettings = this.elsTimeWindowSettingMapper.selectList((Wrapper)elsTimeWindowSettingLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)elsTimeWindowToleranceSettings)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eDVWWWWWIOGRrKIcVWxOVBGRW_a4a67d6d", (String)"\u8d26\u6237\u7ec4:${0}\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u65f6\u95f4\u7a97\u53e3\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e!", (String[])new String[]{elsTimeWindowSetting.getAccountGroup()}));
            }
        }
    }
}

