/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.report.entity.PurchasePerformanceDetailReport;
import com.els.modules.report.entity.SalePerformanceDetailReport;
import com.els.modules.report.enumerate.AppealReplayResult;
import com.els.modules.report.enumerate.AppealStatusEnum;
import com.els.modules.report.enumerate.PerformanceDeduceResultEnum;
import com.els.modules.report.mapper.PurchasePerformanceDetailReportMapper;
import com.els.modules.report.service.PurchasePerformanceDetailReportService;
import com.els.modules.report.service.SalePerformanceDetailReportService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchasePerformanceDetailReportServiceImpl
extends ServiceImpl<PurchasePerformanceDetailReportMapper, PurchasePerformanceDetailReport>
implements PurchasePerformanceDetailReportService {
    @Resource
    private PurchasePerformanceDetailReportMapper purchasePerformanceDetailReportMapper;

    @Override
    public void savePurchasePerformanceDetailReport(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        ((PurchasePerformanceDetailReportMapper)this.baseMapper).insert((Object)purchasePerformanceDetailReport);
    }

    @Override
    public void updatePurchasePerformanceDetailReport(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        int count = ((PurchasePerformanceDetailReportMapper)this.baseMapper).updateById((Object)purchasePerformanceDetailReport);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchasePerformanceDetailReport(String id) {
        ((PurchasePerformanceDetailReportMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchasePerformanceDetailReport(List<String> idList) {
        ((PurchasePerformanceDetailReportMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void agreeAppeal(List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList) {
        Assert.notEmpty(purchasePerformanceDetailReportList, (String)I18nUtil.translate((String)"i18n_alert_zBeIjtXRHxOLV_8f2973f4", (String)"\u6279\u590d\u540c\u610f\u7684\u7ee9\u6548\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        ArrayList<SalePerformanceDetailReport> salePerformanceDetailReportList = new ArrayList<SalePerformanceDetailReport>();
        List ids = purchasePerformanceDetailReportList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List dbpurchasePerformanceDetailReportList = this.purchasePerformanceDetailReportMapper.selectBatchIds(ids);
        Map<Object, Object> purchasePerformanceDetailReportMap = new HashMap();
        if (!CollectionUtil.isNotEmpty((Collection)dbpurchasePerformanceDetailReportList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_iFzBjtXRHcKHemSWFW_7f410321", (String)"\u9009\u62e9\u6279\u590d\u7684\u7ee9\u6548\u660e\u7ec6\u884c\u5728\u7cfb\u7edf\u67e5\u65e0\u6570\u636e!"));
        }
        purchasePerformanceDetailReportMap = dbpurchasePerformanceDetailReportList.stream().collect(Collectors.toMap(ParentEntity::getId, Function.identity()));
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        for (PurchasePerformanceDetailReport purchasePerformanceDetailReport : purchasePerformanceDetailReportList) {
            PurchasePerformanceDetailReport dbPurchasePerformanceDetailReport = (PurchasePerformanceDetailReport)((Object)purchasePerformanceDetailReportMap.get(purchasePerformanceDetailReport.getId()));
            Assert.notNull((Object)((Object)dbPurchasePerformanceDetailReport), (String)I18nUtil.translate((String)"i18n_alert_eRtyWWWWWWKHemSWFW_4bd28747", (String)"\u901a\u77e5\u5355\u53f7[${0}]\u5728\u7cfb\u7edf\u67e5\u65e0\u6570\u636e!", (String[])new String[]{purchasePerformanceDetailReport.getNoticeNumber()}));
            Assert.isTrue((boolean)AppealStatusEnum.APPEALING.getValue().equals(purchasePerformanceDetailReport.getAppealStatus()), (String)I18nUtil.translate((String)"i18n_alert_RHcjUWzEIOhbrAWVWXVWFW_6e9aed2f", (String)"\u660e\u7ec6\u884c\u7684\u7533\u8bc9\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e!"));
            PurchasePerformanceDetailReport purchasePerformanceDetailReportTemp = new PurchasePerformanceDetailReport();
            SalePerformanceDetailReport salePerformanceDetailReportTemp = new SalePerformanceDetailReport();
            Date replyDeadTime = purchasePerformanceDetailReport.getReplyDeadTime();
            Assert.notNull((Object)replyDeadTime, (String)I18nUtil.translate((String)"i18n_alert_dSeRtyWWWWWjzByRKIxOLVW_c0c9628e", (String)"\u9001\u8d27\u901a\u77e5\u5355\u53f7:${0}\u7684\u6279\u590d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{purchasePerformanceDetailReport.getNoticeNumber()}));
            if (new Date().compareTo(replyDeadTime) > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APKIItBRzByRKIWPKxOtkW_9f1eb9cb", (String)"\u5f53\u524d\u65f6\u95f4\u4ee5\u53ca\u8d85\u8fc7\u6279\u590d\u622a\u6b62\u65f6\u95f4,\u6682\u65f6\u4e0d\u80fd\u64cd\u4f5c!"));
            }
            purchasePerformanceDetailReportTemp.setId(purchasePerformanceDetailReport.getId());
            purchasePerformanceDetailReportTemp.setReplyResult(AppealReplayResult.APPROVAL.getValue());
            purchasePerformanceDetailReportTemp.setReplayFinishTime(new Date());
            purchasePerformanceDetailReportTemp.setReplyOption(purchasePerformanceDetailReport.getReplyOption());
            purchasePerformanceDetailReportTemp.setAppealStatus(AppealStatusEnum.APPEAL_SUCCESS.getValue());
            purchasePerformanceDetailReportTemp.setReplyUser(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            purchasePerformanceDetailReportTemp.setPerformanceDeduce(PerformanceDeduceResultEnum.ACCEPTABLE.getValue());
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceDetailReportTemp), (Object)((Object)salePerformanceDetailReportTemp));
            salePerformanceDetailReportTemp.setId(purchasePerformanceDetailReport.getRelationId());
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReportTemp);
            salePerformanceDetailReportList.add(salePerformanceDetailReportTemp);
        }
        this.updateBatchById(purchasePerformanceDetailReports);
        ((SalePerformanceDetailReportService)SpringContextUtils.getBean(SalePerformanceDetailReportService.class)).updateBatchById(salePerformanceDetailReportList);
    }

    @Override
    public void rejectAppeal(List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList) {
        Assert.notEmpty(purchasePerformanceDetailReportList, (String)I18nUtil.translate((String)"i18n_alert_eIjtXRHUWxOLV_6e56c5", (String)"\u540c\u610f\u7684\u7ee9\u6548\u660e\u7ec6\u7533\u8bc9\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        ArrayList<SalePerformanceDetailReport> salePerformanceDetailReportList = new ArrayList<SalePerformanceDetailReport>();
        List ids = purchasePerformanceDetailReportList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List dbpurchasePerformanceDetailReportList = this.purchasePerformanceDetailReportMapper.selectBatchIds(ids);
        Map<Object, Object> purchasePerformanceDetailReportMap = new HashMap();
        if (!CollectionUtil.isNotEmpty((Collection)dbpurchasePerformanceDetailReportList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_iFzBjtXRHcKHemSWFW_7f410321", (String)"\u9009\u62e9\u6279\u590d\u7684\u7ee9\u6548\u660e\u7ec6\u884c\u5728\u7cfb\u7edf\u67e5\u65e0\u6570\u636e!"));
        }
        purchasePerformanceDetailReportMap = dbpurchasePerformanceDetailReportList.stream().collect(Collectors.toMap(ParentEntity::getId, Function.identity()));
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        for (PurchasePerformanceDetailReport purchasePerformanceDetailReport : purchasePerformanceDetailReportList) {
            PurchasePerformanceDetailReport dbPurchasePerformanceDetailReport = (PurchasePerformanceDetailReport)((Object)purchasePerformanceDetailReportMap.get(purchasePerformanceDetailReport.getId()));
            Assert.notNull((Object)((Object)dbPurchasePerformanceDetailReport), (String)I18nUtil.translate((String)"i18n_alert_eRtyWWWWWWKHemSWFW_4bd28747", (String)"\u901a\u77e5\u5355\u53f7[${0}]\u5728\u7cfb\u7edf\u67e5\u65e0\u6570\u636e!", (String[])new String[]{purchasePerformanceDetailReport.getNoticeNumber()}));
            Assert.isTrue((boolean)AppealStatusEnum.APPEALING.getValue().equals(purchasePerformanceDetailReport.getAppealStatus()), (String)I18nUtil.translate((String)"i18n_alert_RHcjUWzEIOhbrAWVWXVWFW_6e9aed2f", (String)"\u660e\u7ec6\u884c\u7684\u7533\u8bc9\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e!"));
            PurchasePerformanceDetailReport purchasePerformanceDetailReportTemp = new PurchasePerformanceDetailReport();
            SalePerformanceDetailReport salePerformanceDetailReportTemp = new SalePerformanceDetailReport();
            Date replyDeadTime = purchasePerformanceDetailReport.getReplyDeadTime();
            Assert.notNull((Object)replyDeadTime, (String)I18nUtil.translate((String)"i18n_alert_dSeRtyWWWWWjzByRKIxOLVW_c0c9628e", (String)"\u9001\u8d27\u901a\u77e5\u5355\u53f7:${0}\u7684\u6279\u590d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{purchasePerformanceDetailReport.getNoticeNumber()}));
            if (new Date().compareTo(replyDeadTime) > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APKIItBRzByRKIWPKxOtkW_9f1eb9cb", (String)"\u5f53\u524d\u65f6\u95f4\u4ee5\u53ca\u8d85\u8fc7\u6279\u590d\u622a\u6b62\u65f6\u95f4,\u6682\u65f6\u4e0d\u80fd\u64cd\u4f5c!"));
            }
            purchasePerformanceDetailReportTemp.setId(purchasePerformanceDetailReport.getId());
            purchasePerformanceDetailReportTemp.setReplyResult(AppealReplayResult.REJECT.getValue());
            purchasePerformanceDetailReportTemp.setReplayFinishTime(new Date());
            purchasePerformanceDetailReportTemp.setReplyOption(purchasePerformanceDetailReport.getReplyOption());
            purchasePerformanceDetailReportTemp.setAppealStatus(AppealStatusEnum.APPEAL_REJECT.getValue());
            purchasePerformanceDetailReportTemp.setReplyUser(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceDetailReportTemp), (Object)((Object)salePerformanceDetailReportTemp));
            salePerformanceDetailReportTemp.setId(purchasePerformanceDetailReport.getRelationId());
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReportTemp);
            salePerformanceDetailReportList.add(salePerformanceDetailReportTemp);
        }
        this.updateBatchById(purchasePerformanceDetailReports);
        ((SalePerformanceDetailReportService)SpringContextUtils.getBean(SalePerformanceDetailReportService.class)).updateBatchById(salePerformanceDetailReportList);
    }
}

