/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rohs.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.rohs.entity.PurchaseRohsCollect;
import com.els.modules.rohs.entity.PurchaseRohsCollectAttachment;
import com.els.modules.rohs.service.PurchaseRohsCollectAttachmentService;
import com.els.modules.rohs.service.PurchaseRohsCollectService;
import com.els.modules.rohs.vo.PurchaseRohsCollectVO;
import com.els.modules.rohsreport.entity.SaleRohsReportHead;
import com.els.modules.rohsreport.service.SaleRohsReportHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rohscollect/purchaseRohsCollect"})
@Tag(name="RoHS\u8d44\u6599\u6536\u96c6\u5355")
public class PurchaseRohsCollectController
extends BaseController<PurchaseRohsCollect, PurchaseRohsCollectService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseRohsCollectController.class);
    @Autowired
    private PurchaseRohsCollectService purchaseRohsCollectService;
    @Autowired
    private PurchaseRohsCollectAttachmentService purchaseRohsCollectAttachmentService;
    @Autowired
    private SaleRohsReportHeadService saleRohsReportHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"gpmManagement#PurchaseRohsCollect:list"})
    public Result<?> queryPageList(PurchaseRohsCollect purchaseRohsCollect, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRohsCollect), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRohsCollectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:add"})
    public Result<?> add(@RequestBody PurchaseRohsCollectVO purchaseRohsCollectPage) {
        PurchaseRohsCollect purchaseRohsCollect = new PurchaseRohsCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseRohsCollectPage), (Object)((Object)purchaseRohsCollect));
        Boolean isSuccess = this.purchaseRohsCollectService.saveMain(purchaseRohsCollect);
        if (isSuccess.booleanValue()) {
            return Result.ok((Object)((Object)purchaseRohsCollect));
        }
        return Result.error((int)10086, (String)I18nUtil.translate((String)"i18n_alert_LYuRdXWVKHnRIcLDRQXjRdXNAJju_ae2c2ef5", (String)"\u672a\u627e\u5230\u4f9b\u5e94\u5546\uff0c\u8bf7\u8054\u7cfbCEG\u7ef4\u62a4\u5236\u9020\u5546\u7684\u4f9b\u5e94\u5546\u54c1\u7c7b\u8d44\u6e90\u6c60"));
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:add"})
    public Result<?> edit(@RequestBody PurchaseRohsCollect purchaseRohsCollect) {
        this.purchaseRohsCollectService.updateById((Object)purchaseRohsCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:submit"})
    public Result<?> publish(@RequestBody PurchaseRohsCollect purchaseRohsCollect) {
        this.purchaseRohsCollectService.publish(purchaseRohsCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u6279\u91cf\u53d1\u5e03")
    @Operation(summary="\u6279\u91cf\u53d1\u5e03", description="\u6279\u91cf\u53d1\u5e03")
    @PostMapping(value={"/batchPublish"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:submit"})
    public Result<?> batchPublish(@RequestBody List<PurchaseRohsCollect> purchaseRohsCollectList) {
        for (PurchaseRohsCollect purchaseRohsCollect : purchaseRohsCollectList) {
            this.purchaseRohsCollectService.publish(purchaseRohsCollect);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u786e\u8ba4")
    @Operation(summary="\u786e\u8ba4", description="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:edit"})
    public Result<?> confirm(@RequestBody PurchaseRohsCollect purchaseRohsCollect) {
        this.purchaseRohsCollectService.confirm(purchaseRohsCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u9a73\u56de")
    @Operation(summary="\u9a73\u56de", description="\u9a73\u56de")
    @PostMapping(value={"/refused"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:reject"})
    public Result<?> refused(@RequestBody PurchaseRohsCollect purchaseRohsCollect) {
        this.purchaseRohsCollectService.refused(purchaseRohsCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u4f5c\u5e9f")
    @Operation(summary="\u4f5c\u5e9f", description="\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:invalid"})
    public Result<?> ivalid(@RequestParam(name="id") String id) {
        PurchaseRohsCollect purchaseRohsCollect = (PurchaseRohsCollect)((Object)this.purchaseRohsCollectService.getById((Serializable)((Object)id)));
        this.purchaseRohsCollectService.ivalid(purchaseRohsCollect);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseRohsCollectService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="RoHS\u8d44\u6599\u6536\u96c6\u5355", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseRohsCollectService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseRohsCollect purchaseRohsCollect = (PurchaseRohsCollect)((Object)this.purchaseRohsCollectService.getById((Serializable)((Object)id)));
        PurchaseRohsCollectVO purchaseRohsCollectVO = new PurchaseRohsCollectVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRohsCollect), (Object)((Object)purchaseRohsCollectVO));
        List<PurchaseRohsCollectAttachment> purchaseRohsCollectAttachmentList = this.purchaseRohsCollectAttachmentService.selectByMainId(id);
        purchaseRohsCollectVO.setPurchaseRohsCollectAttachmentList(purchaseRohsCollectAttachmentList);
        Set jcNumbers = purchaseRohsCollectAttachmentList.stream().map(PurchaseRohsCollectAttachment::getJcNumber).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(jcNumbers)) {
            purchaseRohsCollectVO.setSaleAttachmentList(Lists.newArrayList());
            TenantContext.setTenant((String)purchaseRohsCollect.getToElsAccount());
            List saleRohsReportHeads = this.saleRohsReportHeadService.list((Wrapper)Wrappers.lambdaQuery().in(SaleRohsReportHead::getJcNumber, jcNumbers));
            if (CollUtil.isNotEmpty((Collection)saleRohsReportHeads)) {
                List<String> headIds = saleRohsReportHeads.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
                headIds.forEach(mainIds -> {
                    List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(mainIds);
                    saleAttachmentDTOS.forEach(saleAttachmentDTO -> {
                        if (StrUtil.isNotBlank((CharSequence)saleAttachmentDTO.getFbk1())) {
                            if (StrUtil.equals((CharSequence)"1", (CharSequence)saleAttachmentDTO.getFbk1())) {
                                saleAttachmentDTO.setFbk1(I18nUtil.translate((String)"i18n_title_yes", (String)"\u662f"));
                            }
                            if (StrUtil.equals((CharSequence)"0", (CharSequence)saleAttachmentDTO.getFbk1())) {
                                saleAttachmentDTO.setFbk1(I18nUtil.translate((String)"i18n_title_no", (String)"\u5426"));
                            }
                        }
                    });
                    purchaseRohsCollectVO.getSaleAttachmentList().addAll(saleAttachmentDTOS);
                });
            }
        }
        return Result.ok((Object)((Object)purchaseRohsCollectVO));
    }

    @Operation(summary="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"gpmManagement#PurchaseRohsCollect:list"})
    public Result<?> queryTabsCount(PurchaseRohsCollect purchaseRohsCollect, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        Map stringMap = req.getParameterMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"collect_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"collect_status");
        List list = ((PurchaseRohsCollectService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRohsCollect::getCollectStatus, PurchaseRohsCollect::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "collectStatus", null, (long)all.intValue()));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("rohsCollectStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "collectStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @AutoLog(value="RoHS\u8d44\u6599\u6536\u96c6\u5355-\u68c0\u6d4b\u62a5\u544a\u5ba1\u6279", operateType=3)
    @Operation(summary="\u68c0\u6d4b\u62a5\u544a\u5ba1\u6279", description="\u68c0\u6d4b\u62a5\u544a\u5ba1\u6279")
    @GetMapping(value={"/auditAttachment"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:view"})
    public Result<?> auditAttachment(@RequestParam(name="ids") String ids, @RequestParam(name="status") String status, @RequestParam(name="reason") String reason) {
        List<String> idsList = Arrays.asList(ids.split(","));
        for (String id : idsList) {
            PurchaseRohsCollectAttachment purchaseRohsCollectAttachment = (PurchaseRohsCollectAttachment)((Object)this.purchaseRohsCollectAttachmentService.getById((Serializable)((Object)id)));
            if (purchaseRohsCollectAttachment == null) continue;
            purchaseRohsCollectAttachment.setFbk2(status);
            purchaseRohsCollectAttachment.setFbk3(reason);
            this.purchaseRohsCollectAttachmentService.updateById((Object)purchaseRohsCollectAttachment);
        }
        return this.commonSuccessResult(4);
    }
}

