/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.SampleSupplierList;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.SampleSupplierListService;
import com.els.modules.sample.vo.PurchaseSampleHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="publishSampleAuditoptCallBackAdapter")
public class PublishSampleAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseSampleHeadService purchaseSampleHeadService;
    @Autowired
    private PurchaseSampleItemService purchaseSampleItemService;
    @Autowired
    private SampleSupplierListService enquirySupplierListService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseSampleHead head = (PurchaseSampleHead)((Object)this.purchaseSampleHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallBackDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            PurchaseSampleHeadVO headVO = new PurchaseSampleHeadVO();
            String id = flowCallBackDTO.getBusinessId();
            PurchaseSampleHead dbHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadService.getById((Serializable)((Object)id)));
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            List<PurchaseSampleItem> itemList = this.purchaseSampleItemService.selectByMainId(id);
            headVO.setPurchaseSampleItemList(itemList);
            List<SampleSupplierList> supplierList = this.enquirySupplierListService.selectByMainId(id);
            headVO.setSampleSupplierList(supplierList);
            List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
            headVO.setPurchaseAttachmentList(demandList);
            this.purchaseSampleHeadService.publish(headVO);
        }
        PurchaseSampleHead updateHead = new PurchaseSampleHead();
        updateHead.setId(flowCallBackDTO.getBusinessId());
        updateHead.setFlowId(flowCallBackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseSampleHeadService.updateById((Object)updateHead);
    }
}

