/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.BaseDTO;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeEnterpriseRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SaleSpcn;
import com.els.modules.spcn.entity.SaleSpcnOrderDetail;
import com.els.modules.spcn.entity.SpcnOrderDetail;
import com.els.modules.spcn.enumerate.PurchaseConfirmStatusEnum;
import com.els.modules.spcn.enumerate.SpcnStatusEnum;
import com.els.modules.spcn.mapper.SaleSpcnMapper;
import com.els.modules.spcn.service.PurchaseSpcnService;
import com.els.modules.spcn.service.SaleSpcnOrderDetailService;
import com.els.modules.spcn.service.SaleSpcnService;
import com.els.modules.spcn.service.SpcnOrderDetailService;
import com.els.modules.spcn.vo.SaleSpcnVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleSpcnServiceImpl
extends BaseServiceImpl<SaleSpcnMapper, SaleSpcn>
implements SaleSpcnService {
    @Resource
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Resource
    private SaleSpcnOrderDetailService saleSpcnOrderDetailService;
    @Resource
    private EcnInvokeEnterpriseRpcService ecnInvokeEnterpriseRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseSpcnService purchaseSpcnService;
    @Autowired
    private SpcnOrderDetailService purchaseSpcnOrderDetailService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleSpcn saveSaleSpcn(SaleSpcnVO saleSpcnVO) {
        SaleSpcn saleSpcn = new SaleSpcn();
        BeanUtils.copyProperties((Object)((Object)saleSpcnVO), (Object)((Object)saleSpcn));
        TemplateHeadDTO templateHead = this.ecnInvokeBaseRpcService.getById(saleSpcn.getTemplateNumber());
        if (templateHead != null) {
            saleSpcn.setTemplateName(templateHead.getTemplateName());
            saleSpcn.setTemplateNumber(templateHead.getTemplateNumber());
            saleSpcn.setTemplateVersion(templateHead.getTemplateVersion());
            saleSpcn.setTemplateAccount(templateHead.getElsAccount());
        }
        saleSpcn.setSpcnNumber(this.ecnInvokeBaseRpcService.getNextCode("srmSPCNNuber", (Object)saleSpcn, saleSpcn.getToElsAccount()));
        saleSpcn.setSpcnStatus(SpcnStatusEnum.NEW.getValue());
        saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.UNCONFIRMED.getValue());
        saleSpcn.setSendStatus("0");
        saleSpcn.setChangeApplyTime(new Date());
        if (StrUtil.isBlank((CharSequence)saleSpcn.getAuditStatus())) {
            saleSpcn.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        saleSpcn.setBusAccount(saleSpcn.getToElsAccount());
        ElsEnterpriseInfoDTO enterpriseInfo = this.ecnInvokeEnterpriseRpcService.getByElsAccount(saleSpcn.getToElsAccount());
        if (enterpriseInfo != null) {
            saleSpcn.setPurchaseName(enterpriseInfo.getName());
        }
        saleSpcn.setSupplierName(SysUtil.getLoginUser().getCompanyName());
        ((SaleSpcnMapper)this.baseMapper).insert((Object)saleSpcn);
        this.insertData(saleSpcn, saleSpcnVO.getOrderDetailList(), saleSpcnVO.getAttachments());
        return saleSpcn;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateSaleSpcn(SaleSpcnVO saleSpcnVO) {
        SaleSpcn saleSpcn = new SaleSpcn();
        BeanUtils.copyProperties((Object)((Object)saleSpcnVO), (Object)((Object)saleSpcn));
        ((SaleSpcnMapper)this.baseMapper).updateById((Object)saleSpcn);
        this.saleSpcnOrderDetailService.deleteByMainId(saleSpcnVO.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleSpcnVO.getId());
        this.insertData(saleSpcn, saleSpcnVO.getOrderDetailList(), saleSpcnVO.getAttachments());
    }

    private void insertData(SaleSpcn saleSpcn, List<SaleSpcnOrderDetail> orderDetailList, List<SaleAttachmentDTO> saleAttachmentList) {
        if (CollectionUtil.isNotEmpty(orderDetailList)) {
            for (SaleSpcnOrderDetail saleSpcnOrderDetail : orderDetailList) {
                saleSpcnOrderDetail.setId(null);
                saleSpcnOrderDetail.setHeadId(saleSpcn.getId());
                SysUtil.setSysParam((BaseEntity)saleSpcnOrderDetail, (BaseEntity)saleSpcn);
                saleSpcnOrderDetail.setBusAccount(saleSpcn.getToElsAccount());
            }
            this.saleSpcnOrderDetailService.saveBatch(orderDetailList);
        }
        if (saleAttachmentList != null) {
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentList) {
                saleAttachmentDTO.setId(null);
                saleAttachmentDTO.setSendStatus("0");
                saleAttachmentDTO.setHeadId(saleSpcn.getId());
                SysUtil.setSysParam((BaseDTO)saleAttachmentDTO, (BaseEntity)saleSpcn);
            }
            if (!saleAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
            }
        }
    }

    @Override
    public void delSaleSpcn(String id) {
        ((SaleSpcnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleSpcnOrderDetailService.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
    }

    @Override
    public void delBatchSaleSpcn(List<String> idList) {
        ((SaleSpcnMapper)this.baseMapper).deleteBatchIds(idList);
        for (String id : idList) {
            this.saleSpcnOrderDetailService.deleteByMainId(id);
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void send(SaleSpcn spcn, List<SaleAttachmentDTO> attachments, List<SaleSpcnOrderDetail> orderDetailList) {
        spcn.setSendStatus("1");
        PurchaseSpcn purchaseSpcn = new PurchaseSpcn();
        BeanUtils.copyProperties((Object)((Object)spcn), (Object)((Object)purchaseSpcn));
        purchaseSpcn.setId(null);
        purchaseSpcn.setElsAccount(spcn.getToElsAccount());
        purchaseSpcn.setToElsAccount(spcn.getElsAccount());
        purchaseSpcn.setRelationId(spcn.getId());
        purchaseSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.UNCONFIRMED.getValue());
        this.purchaseSpcnService.save((Object)purchaseSpcn);
        spcn.setRelationId(purchaseSpcn.getId());
        this.updateById((Object)spcn);
        orderDetailList = this.saleSpcnOrderDetailService.queryByMainId(spcn.getId());
        if (CollectionUtil.isNotEmpty(orderDetailList)) {
            ArrayList<SpcnOrderDetail> purchaseSpcnOrderDetailList = new ArrayList<SpcnOrderDetail>();
            for (SaleSpcnOrderDetail saleSpcnOrderDetail : orderDetailList) {
                SpcnOrderDetail spcnOrderDetail = new SpcnOrderDetail();
                BeanUtils.copyProperties((Object)((Object)saleSpcnOrderDetail), (Object)((Object)spcnOrderDetail));
                spcnOrderDetail.setId(null);
                spcnOrderDetail.setElsAccount(saleSpcnOrderDetail.getToElsAccount());
                spcnOrderDetail.setToElsAccount(saleSpcnOrderDetail.getElsAccount());
                spcnOrderDetail.setRelationId(saleSpcnOrderDetail.getId());
                spcnOrderDetail.setHeadId(purchaseSpcn.getId());
                spcnOrderDetail.setSpcnNumber(purchaseSpcn.getSpcnNumber());
                purchaseSpcnOrderDetailList.add(spcnOrderDetail);
            }
            this.purchaseSpcnOrderDetailService.saveBatch(purchaseSpcnOrderDetailList);
        }
        attachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(spcn.getId());
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentDTOList = new ArrayList<PurchaseAttachmentDTO>();
        if (CollectionUtil.isNotEmpty((Collection)attachments)) {
            for (SaleAttachmentDTO saleAttachment : attachments) {
                PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
                purchaseAttachment.setId(purchaseAttachment.getRelationId());
                purchaseAttachment.setRelationId(purchaseAttachment.getId());
                purchaseAttachment.setElsAccount(spcn.getToElsAccount());
                purchaseAttachment.setHeadId(purchaseSpcn.getId());
                purchaseAttachmentDTOList.add(purchaseAttachment);
            }
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentDTOList)) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentDTOList);
        }
        super.sendMessage(spcn.getBusAccount(), "spcn", "publish", spcn.getId(), "saleSpcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{spcn.getToElsAccount()}));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> backout(String id) {
        SaleSpcn spcn = (SaleSpcn)((Object)this.getById((Serializable)((Object)id)));
        if (!PurchaseConfirmStatusEnum.UNCONFIRMED.getValue().equals(spcn.getPurchaseConfirmStatus())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_field_rtFIqRLWSFKWWxOqqMW_e25a3c95", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u786e\u8ba4(\u6216\u62d2\u7edd)\uff0c\u4e0d\u80fd\u88ab\u64a4\u56de\uff01"));
        }
        if ("1".equals(spcn.getAuditStatus())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_field_UzsntFxOqqXW_58e2d92", (String)"\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u4e0d\u80fd\u88ab\u64a4\u9500\uff01"));
        }
        spcn.setSendStatus("0");
        this.purchaseSpcnService.delPurchaseSpcn(spcn.getRelationId());
        this.updateById((Object)spcn);
        super.sendMessage(spcn.getBusAccount(), "spcn", "back", spcn.getId(), "saleSpcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{spcn.getToElsAccount()}));
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_qXLR_2ffb306b", (String)"\u64a4\u9500\u6210\u529f"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> cancellation(String id) {
        SaleSpcn spcn = (SaleSpcn)((Object)this.getById((Serializable)((Object)id)));
        spcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
        PurchaseSpcn purchaseSpcn = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)spcn.getRelationId())));
        purchaseSpcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
        this.updateById((Object)spcn);
        this.purchaseSpcnService.updateById((Object)purchaseSpcn);
        ArrayList receiveAccount = new ArrayList();
        super.sendMessage(spcn.getBusAccount(), "spcn", "invalid", spcn.getId(), "saleSpcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{spcn.getToElsAccount()}));
        return Result.ok((String)I18nUtil.translate((String)"i18n_title_voidedSuccessfully", (String)"\u4f5c\u5e9f\u6210\u529f"));
    }

    @Override
    public JSONObject getSaleSpcnDataById(String id) {
        SaleSpcn saleSpcn = (SaleSpcn)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)saleSpcn));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)saleSpcn, new DictTranslateAspectParam());
        return jsonObject;
    }
}

