/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.caigouwang.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.caigouwang.entity.CaigouBiddings;
import com.els.modules.caigouwang.mapper.CaigouBiddingsMapper;
import com.els.modules.caigouwang.service.CaigouBiddingsService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CaigouBiddingsServiceImpl
extends BaseServiceImpl<CaigouBiddingsMapper, CaigouBiddings>
implements CaigouBiddingsService {
    @Value(value="${b2b.business-opportunity}")
    private String address;
    private static String BUSINESS_LIST_URL = "business/web/bidding/biddings";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private CaigouBiddingsMapper caigouBiddingsMapper;

    @Override
    public void saveCaigouBiddings(CaigouBiddings caigouBiddings) {
        ((CaigouBiddingsMapper)this.baseMapper).insert((Object)caigouBiddings);
    }

    @Override
    public void updateCaigouBiddings(CaigouBiddings caigouBiddings) {
        ((CaigouBiddingsMapper)this.baseMapper).updateById((Object)caigouBiddings);
    }

    @Override
    public void delCaigouBiddings(String id) {
        ((CaigouBiddingsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchCaigouBiddings(List<String> idList) {
        ((CaigouBiddingsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void handleData(CaigouBiddings caigouBusinessList, Integer pageNo, Integer pageSize) {
        this.syncGetData();
    }

    @Async
    public void syncGetData() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select((Object[])new String[]{"create_time"});
        wrapper.orderByDesc((Object)"create_time");
        List list = this.list((Wrapper)wrapper);
        String startTimeStr = null;
        String endTimeStr = null;
        if (!list.isEmpty()) {
            startTimeStr = sdf.format(((CaigouBiddings)((Object)list.get(0))).getCreateTime());
            endTimeStr = sdf.format(new Date());
        }
        String url = null;
        url = startTimeStr == null ? this.address + BUSINESS_LIST_URL + "?size=100&current=1" : this.address + BUSINESS_LIST_URL + "?startTimeStr=" + startTimeStr + "&endTimeStr=" + endTimeStr + "&size=100&current=1";
        String response = HttpRequest.get((String)url).execute().body();
        JSONObject result = JSONObject.parseObject((String)response);
        if (result.getBoolean("success").booleanValue()) {
            ArrayList replenishList = new ArrayList();
            JSONObject data = result.getJSONObject("data");
            Integer total = data.getInteger("total");
            Integer size = data.getInteger("size");
            Integer current = data.getInteger("current");
            Integer pages = data.getInteger("pages");
            if (total != null && total > 0) {
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouBiddings.class);
                replenishList.addAll(lists);
            }
            for (int i = current.intValue(); i < pages; ++i) {
                Integer n = current;
                current = current + 1;
                url = startTimeStr == null ? this.address + BUSINESS_LIST_URL + "?size=100&current=" + current : this.address + BUSINESS_LIST_URL + "?startTimeStr=" + startTimeStr + "&endTimeStr=" + endTimeStr + "&size=100&current=" + current;
                response = HttpRequest.get((String)url).execute().body();
                result = JSONObject.parseObject((String)response);
                if (!result.getBoolean("success").booleanValue()) continue;
                data = result.getJSONObject("data");
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouBiddings.class);
                replenishList.addAll(lists);
            }
            if (replenishList.size() > 0 && !list.isEmpty()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                cal.add(5, 1);
                Date date2 = cal.getTime();
                this.caigouBiddingsMapper.deleteByTime(startTimeStr, sdf.format(date2));
            }
            this.saveBatch(replenishList);
        }
    }
}

