/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rohs.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.rohs.entity.PurchaseRohsCollect;
import com.els.modules.rohs.entity.SaleRohsCollect;
import com.els.modules.rohs.mapper.PurchaseRohsCollectAttachmentMapper;
import com.els.modules.rohs.mapper.PurchaseRohsCollectMapper;
import com.els.modules.rohs.service.PurchaseRohsCollectService;
import com.els.modules.rohs.service.SaleRohsCollectService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseRohsCollectServiceImpl
extends BaseServiceImpl<PurchaseRohsCollectMapper, PurchaseRohsCollect>
implements PurchaseRohsCollectService {
    @Resource
    private PurchaseRohsCollectMapper purchaseRohsCollectMapper;
    @Resource
    private PurchaseRohsCollectAttachmentMapper purchaseRohsCollectAttachmentMapper;
    @Autowired
    private SaleRohsCollectService saleRohsCollectService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private RedisUtil redisUtil;
    private final String LOCK_PREFIX = "purchase_rohs_collect";
    private final long EXPIRE_TIME = 30000L;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Boolean saveMain(PurchaseRohsCollect purchaseRohsCollect) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        try {
            if (this.redisUtil.tryGetDistributedLock("purchase_rohs_collect", TenantContext.getTenant() + loginUser.getSubAccount(), 30000L)) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"material_number", (Object)purchaseRohsCollect.getMaterialNumber());
                queryWrapper.eq((Object)"revision", (Object)purchaseRohsCollect.getRevision());
                queryWrapper.eq((Object)"factory", (Object)purchaseRohsCollect.getFactory());
                queryWrapper.eq((Object)"manufacturer", (Object)purchaseRohsCollect.getManufacturer());
                queryWrapper.ge((Object)"create_time", (Object)LocalDateTime.now().minus(2L, ChronoUnit.MINUTES));
                List purchaseRohsCollectList = this.purchaseRohsCollectMapper.selectList((Wrapper)queryWrapper);
                if (purchaseRohsCollectList.size() > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RzsCHRDJeISLjWWWWltt_fcf0675a", (String)" \u4e24\u5206\u949f\u5185\u7981\u6b62\u63d0\u4ea4\u540c\u4e00\u7269\u6599\u7684RoHS\u6536\u96c6\u5355"));
                }
                super.setHeadDefaultValue((BaseEntity)purchaseRohsCollect);
                String collectNumber = this.baseRpcService.getNextCode("rohscollectNumber", (Object)purchaseRohsCollect);
                purchaseRohsCollect.setSupplierCode(purchaseRohsCollect.getSupplierCode());
                purchaseRohsCollect.setToElsAccount(purchaseRohsCollect.getToElsAccount());
                purchaseRohsCollect.setSupplierName(purchaseRohsCollect.getSupplierName());
                purchaseRohsCollect.setId(IdWorker.getIdStr());
                purchaseRohsCollect.setRelationid(IdWorker.getIdStr());
                purchaseRohsCollect.setCollectNumber(collectNumber);
                purchaseRohsCollect.setCollectStatus("0");
                purchaseRohsCollect.setBusAccount(TenantContext.getTenant());
                this.purchaseRohsCollectMapper.insert((Object)purchaseRohsCollect);
                Boolean bl = true;
                return bl;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFiKexsWVxPVBRc_8511acd5", (String)" \u6570\u636e\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        finally {
            this.redisUtil.releaseDistributedLock("purchase_rohs_collect", TenantContext.getTenant() + loginUser.getSubAccount());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseRohsCollect purchaseRohsCollect = (PurchaseRohsCollect)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)purchaseRohsCollect.getRelationid())) {
            this.saleRohsCollectService.removeById((Serializable)((Object)purchaseRohsCollect.getRelationid()));
        }
        this.purchaseRohsCollectAttachmentMapper.deleteByMainId(id);
        this.purchaseRohsCollectMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseRohsCollectAttachmentMapper.deleteByMainId(serializable.toString());
            this.purchaseRohsCollectMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void refused(PurchaseRohsCollect purchaseRohsCollect) {
        this.updateStatus(purchaseRohsCollect, "3");
        super.sendMessage(purchaseRohsCollect.getElsAccount(), "rohscollect", "purchaseReject", purchaseRohsCollect.getId(), "rohsCollectBusDataServiceImpl", Arrays.asList(purchaseRohsCollect.getToElsAccount()));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void ivalid(PurchaseRohsCollect purchaseRohsCollect) {
        this.updateStatus(purchaseRohsCollect, "9");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirm(PurchaseRohsCollect purchaseRohsCollect) {
        this.updateStatus(purchaseRohsCollect, "4");
        super.sendMessage(purchaseRohsCollect.getElsAccount(), "rohscollect", "confirmPurchase", purchaseRohsCollect.getId(), "rohsCollectBusDataServiceImpl", Arrays.asList(purchaseRohsCollect.getToElsAccount()));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseRohsCollect purchaseRohsCollect) {
        SaleRohsCollect saleRohsCollect = new SaleRohsCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseRohsCollect), (Object)((Object)saleRohsCollect));
        saleRohsCollect.setId(purchaseRohsCollect.getRelationid());
        saleRohsCollect.setRelationid(purchaseRohsCollect.getId());
        saleRohsCollect.setElsAccount(purchaseRohsCollect.getToElsAccount());
        saleRohsCollect.setToElsAccount(purchaseRohsCollect.getElsAccount());
        saleRohsCollect.setPublishTime(new Date());
        this.saleRohsCollectService.save((Object)saleRohsCollect);
        this.updateStatus(purchaseRohsCollect, "1");
        super.sendMessage(purchaseRohsCollect.getElsAccount(), "rohscollect", "publish", purchaseRohsCollect.getId(), "rohsCollectBusDataServiceImpl", Arrays.asList(purchaseRohsCollect.getToElsAccount()));
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseRohsCollect purchaseRohsCollect = (PurchaseRohsCollect)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)purchaseRohsCollect));
        if (ObjectUtil.isEmpty((Object)((Object)purchaseRohsCollect))) {
            SaleRohsCollect saleRohsCollect = (SaleRohsCollect)((Object)this.saleRohsCollectService.getById((Serializable)((Object)id)));
            result = Result.ok((Object)((Object)saleRohsCollect));
        }
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseRohsCollect, new DictTranslateAspectParam());
        return jsonObject;
    }

    private void updateStatus(PurchaseRohsCollect purchaseRohsCollect, String collectStateRefuesd) {
        purchaseRohsCollect.setCollectStatus(collectStateRefuesd);
        if ("1".equals(collectStateRefuesd)) {
            purchaseRohsCollect.setPublishTime(new Date());
        }
        if ("4".equals(collectStateRefuesd)) {
            purchaseRohsCollect.setPublishconfirmTime(new Date());
        }
        if ("3".equals(collectStateRefuesd)) {
            purchaseRohsCollect.setRefuesdTime(new Date());
        }
        this.purchaseRohsCollectMapper.updateById((Object)purchaseRohsCollect);
        SaleRohsCollect saleRohsCollect = new SaleRohsCollect();
        saleRohsCollect.setId(purchaseRohsCollect.getRelationid());
        saleRohsCollect.setCollectStatus(collectStateRefuesd);
        saleRohsCollect.setRemark(purchaseRohsCollect.getRemark());
        if ("1".equals(collectStateRefuesd)) {
            saleRohsCollect.setPublishTime(new Date());
        }
        if ("4".equals(collectStateRefuesd)) {
            saleRohsCollect.setPublishconfirmTime(new Date());
        }
        if ("3".equals(collectStateRefuesd)) {
            saleRohsCollect.setRefuesdTime(new Date());
        }
        this.saleRohsCollectService.updateById((Object)saleRohsCollect);
    }
}

