/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeSupplierRpcService;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SaleSpcn;
import com.els.modules.spcn.enumerate.PurchaseConfirmStatusEnum;
import com.els.modules.spcn.enumerate.SpcnStatusEnum;
import com.els.modules.spcn.service.PurchaseSpcnService;
import com.els.modules.spcn.service.SaleSpcnService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="spcnRpcAdapter")
public class SpcnAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseSpcnService purchaseSpcnService;
    @Autowired
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Autowired
    private SaleSpcnService saleSpcnService;
    @Resource
    private EcnInvokeSupplierRpcService ecnInvokeSupplierRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        Object operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseSpcn head = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SaleSpcn saleSpcn;
        PurchaseSpcn purchaseEcn = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseEcn.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseEcn.setFlowId(outputParamVO.getProcessRootId());
        purchaseEcn.setWorkFlowType(outputParamVO.getBpmnType());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseEcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            purchaseEcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.CONFIRMED.getValue());
            saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
            saleSpcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.CONFIRMED.getValue());
            this.saleSpcnService.updateById((Object)saleSpcn);
            this.sendMsg(purchaseEcn, "confirm");
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseEcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            purchaseEcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.REFUSED.getValue());
            saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
            saleSpcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.REFUSED.getValue());
            this.saleSpcnService.updateById((Object)saleSpcn);
            this.sendMsg(purchaseEcn, "refund");
        }
        this.purchaseSpcnService.updateById((Object)purchaseEcn);
        saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
        saleSpcn.setAuditStatus(outputParamVO.getAuditStatus());
        this.saleSpcnService.updateById((Object)saleSpcn);
    }

    private void sendMsg(PurchaseSpcn spcn, String operation) {
        MqUtil.sendMessage((String)spcn.getElsAccount(), (String)"spcn", (String)operation, (String)spcn.getId(), (String)"purchaseSpcnBusDataServiceImpl", Collections.singletonList(spcn.getToElsAccount()));
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"ecn", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"ecn", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.ecnInvokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        String[] arrays = account.split("_");
        if (arrays.length > 2) {
            paramObj.put("taskId", (Object)arrays[2]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

