/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.workorder.entity.WorkOrderHead;
import com.els.modules.workorder.entity.WorkOrderRecord;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.enumerate.WorkOrderStatusEnum;
import com.els.modules.workorder.mapper.WorkOrderHeadMapper;
import com.els.modules.workorder.service.WorkOrderHeadService;
import com.els.modules.workorder.service.WorkOrderRecordService;
import com.els.modules.workorder.util.PanshiUtil;
import com.els.modules.workorder.vo.CheckResultVO;
import com.els.modules.workorder.vo.ReplyVO;
import com.els.modules.workorder.vo.ScoreResultVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class WorkOrderHeadServiceImpl
extends BaseServiceImpl<WorkOrderHeadMapper, WorkOrderHead>
implements WorkOrderHeadService {
    @Autowired
    private WorkOrderRecordService workOrderRecordService;
    @Autowired
    private PanshiUtil panshiUtil;
    private String version = this.getClass().getPackage().getImplementationVersion();

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(WorkOrderHead workOrderHead, List<WorkOrderRecord> workOrderRecordList) {
        workOrderHead.setSubmitAccount(TenantContext.getTenant());
        workOrderHead.setOrderStatus(WorkOrderStatusEnum.NEW.getValue());
        ((WorkOrderHeadMapper)this.baseMapper).insert((Object)workOrderHead);
        this.insertData(workOrderHead, workOrderRecordList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(WorkOrderHead workOrderHead, List<WorkOrderRecord> workOrderRecordList) {
        int count = ((WorkOrderHeadMapper)this.baseMapper).updateById((Object)workOrderHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.workOrderRecordService.deleteByMainId(workOrderHead.getId());
        this.insertData(workOrderHead, workOrderRecordList);
    }

    private void insertData(WorkOrderHead workOrderHead, List<WorkOrderRecord> workOrderRecordList) {
        if (!CollectionUtils.isEmpty(workOrderRecordList)) {
            for (WorkOrderRecord entity : workOrderRecordList) {
                entity.setHeadId(workOrderHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)workOrderHead);
            }
            this.workOrderRecordService.saveBatch(workOrderRecordList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.workOrderRecordService.deleteByMainId(id);
        ((WorkOrderHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(WorkOrderHead workOrderHead) {
        workOrderHead.setElsAccount(TenantContext.getTenant());
        workOrderHead.setCompanyName(SysUtil.getLoginUser().getEnterpriseName());
        workOrderHead.setSubmitAccount(TenantContext.getTenant());
        workOrderHead.setSubmitTime(new Date());
        workOrderHead.setSend("1");
        workOrderHead.setAppVersion(this.version);
        workOrderHead.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        workOrderHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        if (StrUtil.isBlank((CharSequence)workOrderHead.getId())) {
            workOrderHead.setId(IdWorker.getIdStr());
            ((WorkOrderHeadMapper)this.baseMapper).insert((Object)workOrderHead);
        }
        JSONObject body = SysUtil.objectToJSON((Object)((Object)workOrderHead));
        body.put("optBy", (Object)this.getLoginSubAndName());
        JSONObject resultObj = this.panshiUtil.callPanshi("createWorkOrder", body);
        if (!resultObj.getBooleanValue("success")) {
            throw new ELSBootException("\u63d0\u4ea4\u5de5\u5355\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        ((WorkOrderHeadMapper)this.baseMapper).updateById((Object)((WorkOrderHead)((Object)JSON.parseObject((String)resultObj.getJSONObject("result").toString(), WorkOrderHead.class))));
    }

    private JSONObject getRecordBody(String currentStatus, WorkOrderRecord record) {
        JSONObject body = new JSONObject();
        body.put("id", (Object)record.getHeadId());
        body.put("currentStatus", (Object)currentStatus);
        JSONObject recordObj = SysUtil.objectToJSON((Object)((Object)record));
        body.put("record", (Object)recordObj);
        return body;
    }

    private WorkOrderRecord buidRecord(String headId, String content) {
        WorkOrderRecord record = new WorkOrderRecord();
        record.setId(IdWorker.getIdStr());
        record.setHeadId(headId);
        record.setContentType(ContentTypeEnum.OUR.getValue());
        record.setContent(content);
        record.setElsAccount(TenantContext.getTenant());
        record.setCreateBy(this.getLoginSubAndName());
        record.setCreateTime(new Date());
        return record;
    }

    private void callInterface(String interfaceCode, String orderStatus, String projectId, WorkOrderRecord record) {
        JSONObject body = this.getRecordBody(orderStatus, record);
        JSONObject resultObj = this.panshiUtil.callPanshi(interfaceCode, body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("callInterface_failed:" + resultObj.getString("message"));
            record.setSendStatus(RecordSendStatusEnum.SEND_FAILED.getValue());
            record.setErrorMsg(resultObj.getString("message"));
        } else {
            record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public WorkOrderRecord reply(ReplyVO replyVO) {
        WorkOrderHead workOrderHead = (WorkOrderHead)((Object)((WorkOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)replyVO.getId())));
        WorkOrderRecord record = this.buidRecord(workOrderHead.getId(), replyVO.getContent());
        record.setHeadId(replyVO.getId());
        record.setContentType(ContentTypeEnum.OUR.getValue());
        record.setContent(replyVO.getContent());
        this.callInterface("sendRecord", workOrderHead.getOrderStatus(), workOrderHead.getProjectId(), record);
        this.workOrderRecordService.save((Object)record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void close(ReplyVO replyVO) {
        WorkOrderHead workOrderHead = (WorkOrderHead)((Object)((WorkOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)replyVO.getId())));
        if (workOrderHead == null) {
            throw new ELSBootException("\u5de5\u5355ID\u4e0d\u5b58\u5728\uff01");
        }
        if (WorkOrderStatusEnum.FINISHED.getValue().equals(workOrderHead.getOrderStatus())) {
            throw new ELSBootException("\u5df2\u7ecf\u5173\u95ed\u7684\u5de5\u5355\u4e0d\u80fd\u518d\u64cd\u4f5c\uff01");
        }
        if (!TenantContext.getTenant().equals(workOrderHead.getSubmitAccount()) || !SysUtil.getLoginUser().getSubAccount().equals(workOrderHead.getCreateBy())) {
            throw new ELSBootException("\u53ea\u6709\u63d0\u5355\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01");
        }
        WorkOrderHead update = new WorkOrderHead();
        update.setId(replyVO.getId());
        update.setOrderStatus(WorkOrderStatusEnum.FINISHED.getValue());
        update.setCompleteTime(new Date());
        ((WorkOrderHeadMapper)this.baseMapper).updateById((Object)update);
        WorkOrderRecord record = this.buidRecord(replyVO.getId(), this.getLoginSubAndName() + " \u5df2\u5c06\u5de5\u5355\u5173\u95ed\uff01\u5982\u6709\u7591\u95ee\u8bf7\u518d\u6b21\u63d0\u4ea4\u5de5\u5355\u3002<br>\u5907\u6ce8\uff1a" + replyVO.getContent());
        JSONObject body = this.getRecordBody(update.getOrderStatus(), record);
        body.put("optBy", (Object)this.getLoginSubAndName());
        JSONObject resultObj = this.panshiUtil.callPanshi("closeWorkOrder", body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("callInterface_failed:" + resultObj.getString("message"));
            throw new ELSBootException("\u5173\u95ed\u5de5\u5355\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)record);
    }

    @Override
    public void retryRecord(WorkOrderRecord record) {
        WorkOrderHead head = (WorkOrderHead)((Object)((WorkOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)record.getHeadId())));
        this.callInterface("sendRecord", head.getOrderStatus(), head.getProjectId(), record);
        this.workOrderRecordService.updateById((Object)record);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void check(CheckResultVO resultVO) {
        WorkOrderHead workOrderHead = (WorkOrderHead)((Object)((WorkOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)resultVO.getId())));
        if (workOrderHead == null) {
            throw new ELSBootException("\u5de5\u5355ID\u4e0d\u5b58\u5728\uff01");
        }
        if (WorkOrderStatusEnum.FINISHED.getValue().equals(workOrderHead.getOrderStatus())) {
            throw new ELSBootException("\u5df2\u7ecf\u5173\u95ed\u7684\u5de5\u5355\u4e0d\u80fd\u518d\u64cd\u4f5c\uff01");
        }
        if (!TenantContext.getTenant().equals(workOrderHead.getSubmitAccount()) || !SysUtil.getLoginUser().getSubAccount().equals(workOrderHead.getCreateBy())) {
            throw new ELSBootException("\u53ea\u6709\u63d0\u5355\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01");
        }
        WorkOrderHead update = new WorkOrderHead();
        String checkResult = "\u5de5\u5355\u9a8c\u8bc1\u901a\u8fc7\uff01";
        String orderStatus = WorkOrderStatusEnum.FINISHED.getValue();
        update.setCompleteTime(new Date());
        if ("0".equals(resultVO.getCheckResult())) {
            orderStatus = WorkOrderStatusEnum.IN_PROGRESS.getValue();
            checkResult = "\u5de5\u5355\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01";
            update.setCompleteTime(null);
        }
        update.setId(resultVO.getId());
        update.setOrderStatus(orderStatus);
        ((WorkOrderHeadMapper)this.baseMapper).updateById((Object)update);
        WorkOrderRecord record = this.buidRecord(resultVO.getId(), checkResult + "<br>\u5907\u6ce8\uff1a" + resultVO.getContent());
        JSONObject body = this.getRecordBody(update.getOrderStatus(), record);
        body.put("optBy", (Object)this.getLoginSubAndName());
        JSONObject resultObj = this.panshiUtil.callPanshi("checkWorkOrder", body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("callInterface_failed:" + resultObj.getString("message"));
            throw new ELSBootException("\u5de5\u5355\u9a8c\u8bc1\u63d0\u4ea4\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)record);
    }

    @Override
    public void urgent(ReplyVO replyVO) {
        WorkOrderRecord record = this.buidRecord(replyVO.getId(), this.getLoginSubAndName() + "\u53d1\u8d77\u5de5\u5355\u50ac\u529e\u3002<br>\u5907\u6ce8\uff1a" + replyVO.getContent());
        JSONObject body = this.getRecordBody("", record);
        body.put("optBy", (Object)this.getLoginSubAndName());
        JSONObject resultObj = this.panshiUtil.callPanshi("urgentRequest", body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("callInterface_failed:" + resultObj.getString("message"));
            throw new ELSBootException("\u5de5\u5355\u50ac\u529e\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)record);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void score(ScoreResultVO resultVO) {
        WorkOrderHead workOrderHead = (WorkOrderHead)((Object)((WorkOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)resultVO.getId())));
        if (workOrderHead == null) {
            throw new ELSBootException("\u5de5\u5355ID\u4e0d\u5b58\u5728\uff01");
        }
        if ("1".equals(workOrderHead.getScore())) {
            throw new ELSBootException("\u5df2\u7ecf\u8bc4\u5206\u7684\u5de5\u5355\u4e0d\u80fd\u518d\u6b21\u8bc4\u5206\uff01");
        }
        if (!TenantContext.getTenant().equals(workOrderHead.getSubmitAccount()) || !SysUtil.getLoginUser().getSubAccount().equals(workOrderHead.getCreateBy())) {
            throw new ELSBootException("\u53ea\u6709\u63d0\u5355\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01");
        }
        WorkOrderHead update = new WorkOrderHead();
        BeanUtils.copyProperties((Object)resultVO, (Object)((Object)update));
        update.setContent(null);
        update.setScore("1");
        ((WorkOrderHeadMapper)this.baseMapper).updateById((Object)update);
        StringBuilder builder = new StringBuilder();
        builder.append("\u5904\u7406\u901f\u5ea6\uff1a").append(resultVO.getProcessSpeed()).append(" \u5206<br>");
        builder.append("\u670d\u52a1\u8d28\u91cf\uff1a").append(resultVO.getServiceQuality()).append(" \u5206<br>");
        builder.append("\u670d\u52a1\u6001\u5ea6\uff1a").append(resultVO.getServiceAttitude()).append(" \u5206<br>");
        builder.append("\u5907\u6ce8\uff1a").append(resultVO.getContent());
        WorkOrderRecord record = this.buidRecord(workOrderHead.getId(), builder.toString());
        JSONObject body = this.getRecordBody(update.getOrderStatus(), record);
        body.put("processSpeed", (Object)resultVO.getProcessSpeed());
        body.put("serviceQuality", (Object)resultVO.getServiceQuality());
        body.put("serviceAttitude", (Object)resultVO.getServiceAttitude());
        body.put("optBy", (Object)this.getLoginSubAndName());
        JSONObject resultObj = this.panshiUtil.callPanshi("scoreWorkOrder", body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("callInterface_failed:" + resultObj.getString("message"));
            throw new ELSBootException("\u5de5\u5355\u8bc4\u5206\u63d0\u4ea4\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)record);
    }
}

