/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcd.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mcd.entity.PurchaseMcdCollect;
import com.els.modules.mcd.entity.SaleMcdCollect;
import com.els.modules.mcd.mapper.PurchaseMcdCollectMapper;
import com.els.modules.mcd.mapper.PurchaseMcdDetailMapper;
import com.els.modules.mcd.mapper.SaleMcdCollectMapper;
import com.els.modules.mcd.service.PurchaseMcdCollectService;
import com.els.modules.mcd.service.SaleMcdCollectService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseMcdCollectServiceImpl
extends BaseServiceImpl<PurchaseMcdCollectMapper, PurchaseMcdCollect>
implements PurchaseMcdCollectService {
    @Resource
    private PurchaseMcdDetailMapper purchaseMcdDetailMapper;
    @Resource
    private SaleMcdCollectMapper saleMcdCollectMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private SaleMcdCollectService saleMcdCollectService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Boolean saveMain(PurchaseMcdCollect purchaseMcdCollect) {
        super.setHeadDefaultValue((BaseEntity)purchaseMcdCollect);
        String collectNumber = this.baseRpcService.getNextCode("mcdcollectNumber", (Object)purchaseMcdCollect);
        purchaseMcdCollect.setSupplierCode(purchaseMcdCollect.getSupplierCode());
        purchaseMcdCollect.setToElsAccount(purchaseMcdCollect.getToElsAccount());
        purchaseMcdCollect.setSupplierName(purchaseMcdCollect.getSupplierName());
        purchaseMcdCollect.setId(IdWorker.getIdStr());
        purchaseMcdCollect.setRelationid(IdWorker.getIdStr());
        purchaseMcdCollect.setCollectNumber(collectNumber);
        purchaseMcdCollect.setCollectStatus("0");
        purchaseMcdCollect.setBusAccount(TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)purchaseMcdCollect.getAplStatus())) {
            // empty if block
        }
        ((PurchaseMcdCollectMapper)this.baseMapper).insert((Object)purchaseMcdCollect);
        return true;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseMcdCollect purchaseMcdCollect = (PurchaseMcdCollect)((Object)this.getById((Serializable)((Object)id)));
        this.saleMcdCollectService.removeById((Serializable)((Object)purchaseMcdCollect.getRelationid()));
        this.purchaseMcdDetailMapper.deleteByMainId(id);
        ((PurchaseMcdCollectMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseMcdDetailMapper.deleteByMainId(serializable.toString());
            ((PurchaseMcdCollectMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseMcdCollect purchaseMcdCollect) {
        SaleMcdCollect saleRohsCollect = new SaleMcdCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseMcdCollect), (Object)((Object)saleRohsCollect));
        saleRohsCollect.setId(purchaseMcdCollect.getRelationid());
        saleRohsCollect.setRelationid(purchaseMcdCollect.getId());
        saleRohsCollect.setElsAccount(purchaseMcdCollect.getToElsAccount());
        saleRohsCollect.setToElsAccount(purchaseMcdCollect.getElsAccount());
        saleRohsCollect.setPublishTime(new Date());
        this.saleMcdCollectMapper.insert((Object)saleRohsCollect);
        this.updateStatus(purchaseMcdCollect, "1");
        super.sendMsg(purchaseMcdCollect.getElsAccount(), purchaseMcdCollect.getToElsAccount(), (Object)purchaseMcdCollect, "", "mcdcollect", "publish");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirm(PurchaseMcdCollect purchaseMcdCollect) {
        this.updateStatus(purchaseMcdCollect, "3");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void refused(PurchaseMcdCollect purchaseMcdCollect) {
        this.updateStatus(purchaseMcdCollect, "4");
        super.sendMsg(purchaseMcdCollect.getElsAccount(), purchaseMcdCollect.getToElsAccount(), (Object)purchaseMcdCollect, "", "mcdcollect", "publish");
    }

    @Override
    public void invalid(PurchaseMcdCollect purchaseMcdCollect) {
        this.updateStatus(purchaseMcdCollect, "9");
    }

    private void updateStatus(PurchaseMcdCollect purchaseMcdCollect, String collectState) {
        purchaseMcdCollect.setCollectStatus(collectState);
        if ("1".equals(collectState)) {
            purchaseMcdCollect.setPublishTime(new Date());
        }
        if ("3".equals(collectState)) {
            purchaseMcdCollect.setPublishconfirmTime(new Date());
        }
        ((PurchaseMcdCollectMapper)this.baseMapper).updateById((Object)purchaseMcdCollect);
        SaleMcdCollect saleMcdCollect = new SaleMcdCollect();
        saleMcdCollect.setId(purchaseMcdCollect.getRelationid());
        saleMcdCollect.setCollectStatus(collectState);
        saleMcdCollect.setRemark(purchaseMcdCollect.getRemark());
        if (collectState.equals("1")) {
            saleMcdCollect.setPublishTime(new Date());
        }
        if (collectState.equals("3")) {
            saleMcdCollect.setPublishconfirmTime(new Date());
        }
        this.saleMcdCollectMapper.updateById((Object)saleMcdCollect);
    }
}

