/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.massProduction.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.massProduction.entity.PurchaseMassProdHead;
import com.els.modules.massProduction.entity.PurchaseMassProdPpapItem;
import com.els.modules.massProduction.entity.SaleMassProdHead;
import com.els.modules.massProduction.entity.SaleMassProdPpapItem;
import com.els.modules.massProduction.enums.I18nMassProdMsgEnum;
import com.els.modules.massProduction.enums.MassProdEnum;
import com.els.modules.massProduction.mapper.PurchaseMassProdHeadMapper;
import com.els.modules.massProduction.mapper.PurchaseMassProdPpapItemMapper;
import com.els.modules.massProduction.mapper.SaleMassProdHeadMapper;
import com.els.modules.massProduction.mapper.SaleMassProdPpapItemMapper;
import com.els.modules.massProduction.rpc.service.MassProductBaseRpcService;
import com.els.modules.massProduction.service.SaleMassProdHeadService;
import com.els.modules.massProduction.vo.SaleMassProdHeadUploadPpapVo;
import com.els.modules.massProduction.vo.SaleMassProdHeadVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleMassProdHeadServiceImpl
extends BaseServiceImpl<SaleMassProdHeadMapper, SaleMassProdHead>
implements SaleMassProdHeadService {
    @Resource
    private SaleMassProdPpapItemMapper saleMassProdPpapItemMapper;
    @Resource
    private PurchaseMassProdPpapItemMapper purchaseMassProdPpapItemMapper;
    @Resource
    private PurchaseMassProdHeadMapper purchaseMassProdHeadMapper;
    @Resource
    private MassProductBaseRpcService baseRpcService;

    private void saveData(List<SaleMassProdPpapItem> saleMassProdPpapItemList) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        for (SaleMassProdPpapItem entity : saleMassProdPpapItemList) {
            SaleMassProdPpapItem saleMassMassProdPpapItem = new SaleMassProdPpapItem();
            saleMassMassProdPpapItem.setFileId(entity.getFileId()).setUpdateBy(sysUser.getSubAccount()).setUpdateTime(new Date()).setId(entity.getId());
            this.saleMassProdPpapItemMapper.updateById((Object)saleMassMassProdPpapItem);
        }
    }

    private void confirmData(List<SaleMassProdPpapItem> saleMassProdPpapItemList) {
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(saleMassProdPpapItemList), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_PPAP);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        for (int i = 0; i < saleMassProdPpapItemList.size(); ++i) {
            SaleMassProdPpapItem entity = saleMassProdPpapItemList.get(i);
            boolean bool = "1".equals(entity.getWhetherMust()) && (StringUtils.isBlank((CharSequence)entity.getId()) || StringUtils.isBlank((CharSequence)entity.getFileId()));
            AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_PPAP_FILE, (String[])new String[]{String.valueOf(i + 1), "\u3010" + entity.getPpapDocName() + "\u3011"});
            SaleMassProdPpapItem saleMassMassProdPpapItem = new SaleMassProdPpapItem();
            saleMassMassProdPpapItem.setFileId(entity.getFileId()).setUpdateBy(sysUser.getSubAccount()).setUpdateTime(new Date()).setId(entity.getId());
            this.saleMassProdPpapItemMapper.updateById((Object)saleMassMassProdPpapItem);
        }
    }

    public void sendFile(String headId, String purchaseHeadId, String elsAccount, String toElsAccount) {
        AttachmentSendDTO attachmentSendDTO = new AttachmentSendDTO();
        attachmentSendDTO.setHeadId(headId);
        attachmentSendDTO.setElsAccount(elsAccount);
        HashMap toSend = Maps.newHashMap();
        toSend.put(purchaseHeadId, toElsAccount);
        attachmentSendDTO.setToSend((Map)toSend);
        this.baseRpcService.sendSaleFile(attachmentSendDTO);
    }

    private void updatePurchasePpapItem(List<SaleMassProdPpapItem> saleMassProdPpapItemList) {
        for (SaleMassProdPpapItem saleMassProdPpapItem : saleMassProdPpapItemList) {
            if (StringUtils.isBlank((CharSequence)saleMassProdPpapItem.getFileId())) continue;
            JSONArray jsonArray = JSONObject.parseArray((String)saleMassProdPpapItem.getFileId());
            ArrayList purchaseAttachmentDTOS = Lists.newArrayList();
            for (int i = 0; i < jsonArray.size(); ++i) {
                PurchaseAttachmentDTO purchaseAttachment;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                SaleAttachmentDTO saleAttachment = this.baseRpcService.getSaleFileById(jsonObject.getString("id"));
                if (saleAttachment == null || (purchaseAttachment = this.baseRpcService.getPurchaseFileById(saleAttachment.getRelationId())) == null) continue;
                purchaseAttachmentDTOS.add(purchaseAttachment);
            }
            if (!CollUtil.isNotEmpty((Collection)purchaseAttachmentDTOS)) continue;
            PurchaseMassProdPpapItem purchaseMassProdPpapItem = new PurchaseMassProdPpapItem();
            purchaseMassProdPpapItem.setFileId(JSON.toJSONString((Object)purchaseAttachmentDTOS)).setId(saleMassProdPpapItem.getSourceId());
            this.purchaseMassProdPpapItemMapper.updateById((Object)purchaseMassProdPpapItem);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleMassProdHeadUploadPpapVo uploadPpapVo) {
        SaleMassProdHead saleMassProdHead = (SaleMassProdHead)((Object)((SaleMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)uploadPpapVo.getId())));
        AssertI18nUtil.isTrue((saleMassProdHead == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.SALE_MASS_PROD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)"1".equals(saleMassProdHead.getUploadPpap()), (Enum)I18nMassProdMsgEnum.MASS_PROD_HAS_UPLOAD_PPAP);
        this.saveData(uploadPpapVo.getMassProdPpapItemList());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirm(SaleMassProdHeadUploadPpapVo uploadPpapVo) {
        SaleMassProdHead saleMassProdHead = (SaleMassProdHead)((Object)((SaleMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)uploadPpapVo.getId())));
        AssertI18nUtil.isTrue((saleMassProdHead == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.SALE_MASS_PROD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)"1".equals(saleMassProdHead.getUploadPpap()), (Enum)I18nMassProdMsgEnum.MASS_PROD_HAS_UPLOAD_PPAP);
        saleMassProdHead.setUploadPpap("1");
        saleMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value());
        ((SaleMassProdHeadMapper)this.baseMapper).updateById((Object)saleMassProdHead);
        PurchaseMassProdHead purchaseMassProdHead = (PurchaseMassProdHead)((Object)this.purchaseMassProdHeadMapper.selectById((Serializable)((Object)saleMassProdHead.getRelationId())));
        purchaseMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value()).setId(saleMassProdHead.getRelationId());
        this.purchaseMassProdHeadMapper.updateById((Object)purchaseMassProdHead);
        this.confirmData(uploadPpapVo.getMassProdPpapItemList());
        this.sendFile(saleMassProdHead.getId(), purchaseMassProdHead.getId(), saleMassProdHead.getElsAccount(), purchaseMassProdHead.getElsAccount());
        this.updatePurchasePpapItem(uploadPpapVo.getMassProdPpapItemList());
        super.sendMessage(saleMassProdHead.getBusAccount(), "massProdHead", "recordUploadSupplier", saleMassProdHead.getId(), "massProdBusDataServiceImpl", Arrays.asList(saleMassProdHead.getBusAccount()));
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleMassProdHead saleMassProdHead = (SaleMassProdHead)((Object)this.getById((Serializable)((Object)id)));
        SaleMassProdHeadVO saleMassProdHeadVO = new SaleMassProdHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleMassProdHead), (Object)((Object)saleMassProdHeadVO));
        List<SaleMassProdPpapItem> purchaseMassProdPpapItemList = this.saleMassProdPpapItemMapper.selectByMainId(id);
        saleMassProdHeadVO.setMassProdPpapItemList(purchaseMassProdPpapItemList);
        Result result = Result.ok((Object)((Object)saleMassProdHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

