/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcd.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.mcd.entity.PurchaseHighRisk;
import com.els.modules.mcd.service.PurchaseHighRiskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseHighRiskExcelServiceImpl")
public class PurchaseHighRiskExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private final String TEMPLATENUMBER = "TC2023120101";
    private final String TEMPLATENAME = "\u9ad8\u98ce\u9669\u8f85\u8017\u6750\u6e05\u5355";
    private final Integer TEMPLATEVERSION = 1;
    private final String TEMPLATEACCOUNT = "2104583";
    @Autowired
    private PurchaseHighRiskService purchaseHighRiskService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchaseHighRisk> entityList = new ArrayList<PurchaseHighRisk>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (Map data : dataList) {
            PurchaseHighRisk entity = (PurchaseHighRisk)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseHighRisk.class));
            if (null != entity) {
                if (stringList.contains(entity.getMaterialNumber() + "_" + entity.getSupplierCode())) {
                    String msg = I18nUtil.translate((String)"i18n_alert_uNWFsjVBjTo_852dffe1", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u6761\u7801");
                    this.errorAdd(excelImportDTO, msg, data);
                    continue;
                }
                stringList.add(entity.getMaterialNumber() + "_" + entity.getSupplierCode());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(PurchaseHighRisk::getMaterialNumber, (Object)entity.getMaterialNumber());
            queryWrapper.lambda().eq(PurchaseHighRisk::getSupplierCode, (Object)entity.getSupplierCode());
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            List head = this.purchaseHighRiskService.list((Wrapper)queryWrapper);
            if (null != head && head.size() > 0) {
                String msg = I18nUtil.translate((String)"i18n_alert_uNWFsjIOMKjTo_bb06f3b4", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u5df2\u7ecf\u5b58\u5728\u7684\u6761\u7801");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            entity.setTemplateAccount("2104583");
            entity.setTemplateName("\u9ad8\u98ce\u9669\u8f85\u8017\u6750\u6e05\u5355");
            entity.setTemplateNumber("TC2023120101");
            entity.setTemplateVersion(this.TEMPLATEVERSION);
            entity.setElsAccount(TenantContext.getTenant());
            entityList.add(entity);
        }
        if (!entityList.isEmpty()) {
            this.purchaseHighRiskService.saveBatch(entityList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

