/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcd.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import com.els.modules.mcd.entity.GpSystemControl;
import com.els.modules.mcd.entity.PurchaseMcdCollect;
import com.els.modules.mcd.entity.PurchaseMcdDetail;
import com.els.modules.mcd.entity.SaleMcdCollect;
import com.els.modules.mcd.entity.SaleMcdDetail;
import com.els.modules.mcd.mapper.GpSystemControlMapper;
import com.els.modules.mcd.mapper.PurchaseMcdCollectMapper;
import com.els.modules.mcd.mapper.PurchaseMcdDetailMapper;
import com.els.modules.mcd.mapper.SaleMcdCollectMapper;
import com.els.modules.mcd.mapper.SaleMcdDetailMapper;
import com.els.modules.mcd.service.SaleMcdCollectService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleMcdCollectServiceImpl
extends BaseServiceImpl<SaleMcdCollectMapper, SaleMcdCollect>
implements SaleMcdCollectService {
    @Autowired
    private SaleMcdCollectMapper saleMcdCollectMapper;
    @Autowired
    private SaleMcdDetailMapper saleMcdDetailMapper;
    @Autowired
    private GpSystemControlMapper gpSystemControlMapper;
    @Autowired
    private PurchaseMcdCollectMapper purchaseMcdCollectMapper;
    @Autowired
    private PurchaseMcdDetailMapper purchaseMcdDetailMapper;
    @Autowired
    private SaleAttachmentRpcService saleAttachmentRpcService;
    @Autowired
    private PurchaseAttachmentRpcService purchaseAttachmentRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleMcdCollect saleMcdCollect, List<SaleMcdDetail> saleMcdDetailList, List<SaleMcdDetail> saleMcdReachList) {
        this.update(saleMcdCollect, saleMcdDetailList, saleMcdReachList);
    }

    private void update(SaleMcdCollect saleMcdCollect, List<SaleMcdDetail> saleMcdDetailList, List<SaleMcdDetail> saleMcdReachList) {
        this.saleMcdCollectMapper.updateById((Object)saleMcdCollect);
        if (!saleMcdReachList.isEmpty()) {
            for (SaleMcdDetail saleMcdReach : saleMcdReachList) {
                for (SaleMcdDetail saleMcdDetail : saleMcdDetailList) {
                    if (!saleMcdReach.getId().equals(saleMcdDetail.getId())) continue;
                    saleMcdDetail.setPpmManualWeight(saleMcdReach.getPpmManualWeight());
                }
            }
        }
        this.saleMcdDetailMapper.deleteByMainId(saleMcdCollect.getId());
        this.insertData(saleMcdCollect, saleMcdDetailList);
    }

    private void insertData(SaleMcdCollect saleMcdCollect, List<SaleMcdDetail> saleMcdDetailList) {
        if (!CollectionUtils.isEmpty(saleMcdDetailList)) {
            QueryWrapper gpQuery = new QueryWrapper();
            gpQuery.select(new String[]{"groupid", "material_type", "material_item_number", "material_en", "casno", "threshoid", "remark"});
            List gpSystemControlList = this.gpSystemControlMapper.selectList((Wrapper)gpQuery);
            Map<String, List<GpSystemControl>> gpMaps = gpSystemControlList.stream().collect(Collectors.groupingBy(GpSystemControl::getCasno));
            String material = "";
            String HomogeneousMaterialmaterial = "";
            HashMap map = new HashMap();
            for (int i2 = 0; i2 < saleMcdDetailList.size(); ++i2) {
                ArrayList<SaleMcdDetail> list;
                SaleMcdDetail saleMcdDetail = saleMcdDetailList.get(i2);
                saleMcdDetail.setFbk8("1000");
                saleMcdDetail.setStandard("Y");
                String casno = saleMcdDetail.getCasno();
                if (StringUtils.isNotBlank((String)casno) && (list = gpMaps.get(casno)) != null && list.size() > 0) {
                    GpSystemControl gpSystemControl = (GpSystemControl)((Object)list.get(0));
                    saleMcdDetail.setGpGroupid(gpSystemControl.getGroupid());
                    if (ObjectUtil.isNotEmpty((Object)gpSystemControl.getThreshoid())) {
                        saleMcdDetail.setPpmStandardWeight(gpSystemControl.getThreshoid().toPlainString());
                    }
                }
                if (i2 == 0) {
                    material = saleMcdDetail.getMaterial();
                    HomogeneousMaterialmaterial = saleMcdDetail.getHomogeneousMaterial();
                    list = new ArrayList<SaleMcdDetail>();
                    saleMcdDetail.setMaterialGroup(material);
                    saleMcdDetail.setFbk3(saleMcdDetail.getHomogeneousMaterial());
                    list.add(saleMcdDetail);
                    map.put(material, list);
                    continue;
                }
                if (StringUtils.isBlank((String)saleMcdDetail.getMaterial()) || saleMcdDetail.getMaterial().equals(material)) {
                    saleMcdDetail.setMaterialGroup(material);
                    ((List)map.get(material)).add(saleMcdDetail);
                    if (StringUtils.isBlank((String)saleMcdDetail.getHomogeneousMaterial()) || saleMcdDetail.getHomogeneousMaterial().equals(HomogeneousMaterialmaterial)) {
                        saleMcdDetail.setFbk3(HomogeneousMaterialmaterial);
                        continue;
                    }
                    HomogeneousMaterialmaterial = saleMcdDetail.getHomogeneousMaterial();
                    saleMcdDetail.setFbk3(HomogeneousMaterialmaterial);
                    continue;
                }
                material = saleMcdDetail.getMaterial();
                list = new ArrayList();
                saleMcdDetail.setMaterialGroup(material);
                list.add(saleMcdDetail);
                map.put(material, list);
                if (StringUtils.isBlank((String)saleMcdDetail.getHomogeneousMaterial()) || saleMcdDetail.getHomogeneousMaterial().equals(HomogeneousMaterialmaterial)) {
                    saleMcdDetail.setFbk3(HomogeneousMaterialmaterial);
                    continue;
                }
                HomogeneousMaterialmaterial = saleMcdDetail.getHomogeneousMaterial();
                saleMcdDetail.setFbk3(HomogeneousMaterialmaterial);
            }
            BigDecimal totalWeight = BigDecimal.ZERO;
            ArrayList finalSaleMcdDetailList = new ArrayList();
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                BigDecimal materiWeight = BigDecimal.ZERO;
                List value = (List)entry.getValue();
                for (SaleMcdDetail saleMcdDetail : value) {
                    String materialWeightMg = saleMcdDetail.getMaterialWeightMg();
                    if (!StrUtil.isNotBlank((CharSequence)materialWeightMg)) continue;
                    materiWeight = materiWeight.add(NumberUtils.createBigDecimal((String)materialWeightMg));
                    totalWeight = totalWeight.add(materiWeight.divide(new BigDecimal("1000"), 8, 4));
                }
                finalSaleMcdDetailList.addAll(value);
            }
            saleMcdCollect.setWeightTotal(totalWeight.stripTrailingZeros().toPlainString());
            this.saleMcdCollectMapper.updateById((Object)saleMcdCollect);
            Map<String, List<SaleMcdDetail>> groupMap = finalSaleMcdDetailList.stream().collect(Collectors.groupingBy(x -> x.getMaterialGroup() + "_" + x.getFbk3()));
            groupMap.forEach((i, subList) -> {
                BigDecimal materialWeightMgReduce = subList.stream().map(item -> NumberUtils.createBigDecimal((String)item.getMaterialWeightMg())).reduce(BigDecimal.ZERO, BigDecimal::add);
                subList.forEach(item -> {
                    item.setMaterialWeight(materialWeightMgReduce.divide(new BigDecimal("1000"), 8, 4).stripTrailingZeros().toPlainString());
                    BigDecimal rate = NumberUtils.createBigDecimal((String)item.getMaterialWeightMg()).divide(materialWeightMgReduce, 5, 4).multiply(new BigDecimal(100)).setScale(3, 4);
                    item.setContentRate(rate.toPlainString());
                    item.setPpmWeight(rate.multiply(new BigDecimal("10000")).stripTrailingZeros().toPlainString());
                });
            });
            Map<String, List<SaleMcdDetail>> listMap = finalSaleMcdDetailList.stream().filter(x -> StringUtils.isNotBlank((String)x.getGpGroupid())).collect(Collectors.groupingBy(x -> x.getMaterialGroup() + "_" + x.getFbk3() + "_" + x.getGpGroupid()));
            listMap.forEach((i, subList) -> {
                BigDecimal ppmWeightCount = subList.stream().map(x -> null == x.getPpmWeight() ? BigDecimal.ZERO : new BigDecimal(x.getPpmWeight())).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (ppmWeightCount.compareTo(NumberUtils.createBigDecimal((String)((SaleMcdDetail)((Object)((Object)subList.get(0)))).getPpmStandardWeight())) > 0) {
                    subList.forEach(v -> {
                        if (StringUtils.isBlank((String)v.getFbk5())) {
                            v.setStandard("N");
                        }
                    });
                } else {
                    subList.forEach(v -> v.setStandard("Y"));
                }
            });
            for (SaleMcdDetail entity : finalSaleMcdDetailList) {
                entity.setId(IdWorker.getIdStr());
                entity.setHeadId(saleMcdCollect.getId());
                entity.setRelationid(IdWorker.getIdStr());
                entity.setToElsAccount(saleMcdCollect.getToElsAccount());
                entity.setBusAccount(saleMcdCollect.getBusAccount());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleMcdCollect);
            }
            if (!saleMcdDetailList.isEmpty()) {
                for (SaleMcdDetail entity : saleMcdDetailList) {
                    entity.setId(IdWorker.getIdStr());
                    entity.setHeadId(saleMcdCollect.getId());
                    entity.setRelationid(IdWorker.getIdStr());
                    entity.setToElsAccount(saleMcdCollect.getToElsAccount());
                    entity.setBusAccount(saleMcdCollect.getBusAccount());
                }
                this.saleMcdDetailMapper.insertBatchSomeColumn(saleMcdDetailList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(SaleMcdCollect saleMcdCollect, List<SaleMcdDetail> saleMcdDetailList, List<SaleMcdDetail> saleMcdReachList) {
        this.update(saleMcdCollect, saleMcdDetailList, saleMcdReachList);
        this.updateStatus(saleMcdCollect, "2");
        this.copyMcdDetail(saleMcdCollect, saleMcdDetailList);
        this.copyAttachment(saleMcdCollect);
        super.sendMessage(saleMcdCollect.getElsAccount(), "mcdcollect", "publishSupplier", saleMcdCollect.getId(), "mcdCollectBusDataServiceImpl", Arrays.asList(saleMcdCollect.getBusAccount()));
    }

    private void copyAttachment(SaleMcdCollect saleMcdCollect) {
        List saleAttachments = this.saleAttachmentRpcService.selectByMainId(saleMcdCollect.getId());
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        if (StrUtil.isNotBlank((CharSequence)saleMcdCollect.getRelationid())) {
            this.purchaseAttachmentRpcService.deleteByMainId(saleMcdCollect.getRelationid());
        }
        for (SaleAttachmentDTO saleAttachmentDTO : saleAttachments) {
            PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachmentDTO, (Object)purchaseAttachmentDTO);
            purchaseAttachmentDTO.setId(null);
            purchaseAttachmentDTO.setElsAccount(saleMcdCollect.getToElsAccount());
            purchaseAttachmentDTO.setHeadId(saleMcdCollect.getRelationid());
            purchaseAttachmentDTO.setRelationId(saleAttachmentDTO.getId());
            purchaseAttachmentDTO.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachmentDTO);
        }
        if (purchaseAttachments.size() > 0) {
            this.purchaseAttachmentRpcService.insertBatchSomeColumn(purchaseAttachments);
        }
    }

    private void copyMcdDetail(SaleMcdCollect saleMcdCollect, List<SaleMcdDetail> saleMcdDetailList) {
        ArrayList<PurchaseMcdDetail> purchaseMcdDetailList = new ArrayList<PurchaseMcdDetail>();
        for (SaleMcdDetail saleMcdDetail : saleMcdDetailList) {
            PurchaseMcdDetail purchaseMcdDetail = new PurchaseMcdDetail();
            BeanUtils.copyProperties((Object)((Object)saleMcdDetail), (Object)((Object)purchaseMcdDetail));
            purchaseMcdDetail.setHeadId(saleMcdCollect.getRelationid());
            purchaseMcdDetail.setId(saleMcdDetail.getRelationid());
            purchaseMcdDetail.setElsAccount(saleMcdCollect.getToElsAccount());
            purchaseMcdDetail.setToElsAccount(saleMcdCollect.getToElsAccount());
            purchaseMcdDetail.setRelationid(saleMcdDetail.getId());
            purchaseMcdDetailList.add(purchaseMcdDetail);
        }
        this.purchaseMcdDetailMapper.deleteByMainId(saleMcdCollect.getRelationid());
        this.purchaseMcdDetailMapper.insertBatchSomeColumn(purchaseMcdDetailList);
    }

    private void updateStatus(SaleMcdCollect saleMcdCollect, String collectState) {
        saleMcdCollect.setCollectStatus(collectState);
        if ("2".equals(collectState)) {
            saleMcdCollect.setConfirmTime(new Date());
        }
        ((SaleMcdCollectMapper)this.baseMapper).updateById((Object)saleMcdCollect);
        PurchaseMcdCollect purchaseMcdCollect = new PurchaseMcdCollect();
        purchaseMcdCollect.setId(saleMcdCollect.getRelationid());
        purchaseMcdCollect.setCollectStatus(collectState);
        purchaseMcdCollect.setRemark(purchaseMcdCollect.getRemark());
        purchaseMcdCollect.setWeightTotal(saleMcdCollect.getWeightTotal());
        if ("2".equals(collectState)) {
            purchaseMcdCollect.setConfirmTime(new Date());
        }
        this.purchaseMcdCollectMapper.updateById((Object)purchaseMcdCollect);
    }
}

