/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.common.utils.NumberConverterUtil;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.goods.dto.GoodsCollectDTO;
import com.els.modules.goods.dto.GoodsDTO;
import com.els.modules.goods.entity.Goods;
import com.els.modules.goods.entity.GoodsCollect;
import com.els.modules.goods.entity.GoodsItems;
import com.els.modules.goods.enumerate.GoodsOptionsType;
import com.els.modules.goods.enumerate.GoodsOptionsTypeGroup;
import com.els.modules.goods.mapper.GoodsCollectMapper;
import com.els.modules.goods.mapper.GoodsMapper;
import com.els.modules.goods.service.GoodsCollectService;
import com.els.modules.goods.vo.GoodsVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsCollectServiceImpl
extends BaseServiceImpl<GoodsCollectMapper, GoodsCollect>
implements GoodsCollectService {
    @Autowired
    private GoodsMapper goodsMapper;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<GoodsOptionsTypeGroup, GoodsOptionsType> init = OptionFactory.init(GoodsOptionsTypeGroup.class, GoodsOptionsType.class);
        init.setCollection("tb_goods_category");
        switch (type) {
            case "list": {
                init.when(GoodsOptionsType.category, (doc, param) -> this.optionsConverter(doc));
                init.when(GoodsOptionsType.goodsInfo, (doc, param) -> this.optionsConverter(doc));
                init.when(GoodsOptionsType.promotional, (doc, param) -> this.optionsConverter(doc));
                break;
            }
            case "collect": {
                init.when(GoodsOptionsType.goodsInfo2, (doc, param) -> this.optionsConverter(doc));
                init.when(GoodsOptionsType.promotional, (doc, param) -> this.optionsConverter(doc));
                break;
            }
            default: {
                throw new ELSBootException("\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b");
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> optionsConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setText(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getChildren((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getChildren(Document document) {
        List children = document.getList((Object)"children", Map.class);
        ArrayList<Object> tagCopyList = new ArrayList<Object>(children.size());
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setText(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                this.getChildrenSub((Map)a, tagCopy);
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    private void getChildrenSub(Map a, TopManOptionsEntity.TagCopy tagCopy) {
        List children1 = (List)a.get("children");
        if (CollectionUtil.isEmpty((Collection)children1)) {
            tagCopy.setChildren(null);
        } else {
            ArrayList sonTagCopyList = new ArrayList(children1.size());
            children1.forEach(b -> {
                TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                sonTagCopy.setLabel(b.get("label").toString());
                sonTagCopy.setText(b.get("label").toString());
                sonTagCopy.setValue(b.get("value").toString());
                this.getChildrenSub((Map)b, sonTagCopy);
                sonTagCopyList.add(sonTagCopy);
            });
            tagCopy.setChildren(sonTagCopyList);
        }
    }

    @Override
    public IPage<GoodsVO> queryCollectListNew(SimplePostRequestParam<GoodsDTO> param) {
        IPage<GoodsVO> page = new IPage<GoodsVO>((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        QueryWrapper<Goods> queryWrapper = this.getQueryWrapper(param);
        page = this.goodsMapper.queryPageListNew(page, queryWrapper, SysUtil.getLoginUser());
        page.setRecords(this.handleDataNew(page.getRecords()));
        return page;
    }

    private QueryWrapper<Goods> getQueryWrapper(SimplePostRequestParam<GoodsDTO> param) {
        String string;
        List<GoodsDTO.ScreenItemField> promotionals;
        GoodsDTO dto = (GoodsDTO)param.getFilterInfo();
        GoodsDTO.ScreenItem screenItem = dto.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        List<GoodsDTO.ScreenItemField> goodsInfos = screenItem.getGoodsInfo();
        if (CollectionUtil.isNotEmpty(goodsInfos)) {
            for (GoodsDTO.ScreenItemField screenItemField : goodsInfos) {
                Object value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u5546\u54c1\u4ef7\u683c": {
                        this.handleMinMax((String)value, (QueryWrapper<Goods>)query, Goods::getPriceRange);
                        break;
                    }
                    case "\u4f63\u91d1\u6bd4\u4f8b": {
                        this.handleMinMax((String)value, (QueryWrapper<Goods>)query, Goods::getCosRatio);
                        break;
                    }
                    case "\u5546\u54c1\u9500\u91cf": {
                        this.handleMinMax((String)value, (QueryWrapper<Goods>)query, Goods::getTotalSales);
                        break;
                    }
                }
            }
        }
        if (CollectionUtil.isNotEmpty(promotionals = screenItem.getPromotional())) {
            for (GoodsDTO.ScreenItemField screenItemField : promotionals) {
                switch (screenItemField.getTitle()) {
                    case "\u6709\u76f4\u64ad\u5e26\u8d27": {
                        query.lambda().gt(Goods::getLivesNum, (Object)0);
                        break;
                    }
                    case "\u6709\u89c6\u9891\u5e26\u8d27": {
                        query.lambda().gt(Goods::getVideosNum, (Object)0);
                        break;
                    }
                }
            }
        }
        if ((string = param.getKeyWord()) != null && string.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)q.lambda().like(Goods::getTitle, (Object)keyWord);
            });
        }
        QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
            {
                this.put("order", new String[]{"desc"});
                this.put("column", new String[]{"update_time"});
            }
        }, (Object)((Object)new Goods()));
        return query;
    }

    private void handleEqString(String value, QueryWrapper<Goods> query, SFunction<Goods, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    private List<GoodsVO> handleDataNew(List<GoodsVO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList<GoodsVO>(0);
        }
        return list.stream().peek(h -> {
            h.setCosRatio(StringUtils.isNotBlank((CharSequence)h.getCosRatio()) ? h.getCosRatio() + "%" : "");
            h.setTotalSales(NumberConverterUtil.numToAbbrConverter(h.getTotalSales()));
            h.setLivesSales(NumberConverterUtil.numToAbbrConverter(h.getLivesSales()));
            h.setVideosSales(NumberConverterUtil.numToAbbrConverter(h.getVideosSales()));
            h.setLivesNum(NumberConverterUtil.numToAbbrConverter(h.getLivesNum()));
            h.setVideosNum(NumberConverterUtil.numToAbbrConverter(h.getVideosNum()));
        }).collect(Collectors.toList());
    }

    @Override
    public IPage<GoodsItems> queryCollectList(Map map) {
        IPage<GoodsItems> page = new IPage<GoodsItems>(Long.parseLong(map.get("pageIndex") + ""), Long.parseLong(map.get("pageSize") + ""));
        QueryWrapper<Goods> queryWrapper = this.getQueryWrapperNew(map);
        page = this.goodsMapper.queryPageList(page, queryWrapper, SysUtil.getLoginUser());
        page.setRecords(this.handleData(page.getRecords()));
        return page;
    }

    private QueryWrapper<Goods> getQueryWrapperNew(Map map) {
        String keyWord;
        Boolean videos;
        Boolean live;
        String totalSales;
        Object cosRatio;
        QueryWrapper query = new QueryWrapper();
        String priceRange = (String)map.get("spjg");
        if (StringUtils.isNotBlank((CharSequence)priceRange)) {
            this.handleMinMax(priceRange, (QueryWrapper<Goods>)query, Goods::getPriceRange);
        }
        if ((cosRatio = map.get("yjbl")) != null && !"0".equals(cosRatio.toString())) {
            this.handleMinMax(cosRatio.toString(), (QueryWrapper<Goods>)query, Goods::getCosRatio);
        }
        if (StringUtils.isNotBlank((CharSequence)(totalSales = (String)map.get("spxl")))) {
            this.handleMinMax(totalSales, (QueryWrapper<Goods>)query, Goods::getTotalSales);
        }
        if ((live = (Boolean)map.get("islive")).booleanValue()) {
            query.lambda().gt(Goods::getLivesNum, (Object)0);
        }
        if ((videos = (Boolean)map.get("isVideo")).booleanValue()) {
            query.lambda().gt(Goods::getVideosNum, (Object)0);
        }
        if ((keyWord = (String)map.get("keyWord")) != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)q.lambda().like(Goods::getTitle, (Object)keyWord);
            });
        }
        QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
            {
                this.put("order", new String[]{"desc"});
                this.put("column", new String[]{"update_time"});
            }
        }, (Object)((Object)new Goods()));
        return query;
    }

    private void handleMinMax(String value, QueryWrapper<Goods> query, SFunction<Goods, ?> field) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                int min = Integer.valueOf(split[0]);
                int max = Integer.valueOf(split[1]);
                query.lambda().between(field, (Object)min, (Object)max);
                break;
            }
            case 1: {
                int min2 = Integer.valueOf(split[0]);
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)min2);
                    break;
                }
                query.lambda().ge(field, (Object)min2);
                break;
            }
            default: {
                throw new ELSBootException("\u6570\u636e\u914d\u7f6e\u6709\u8bef");
            }
        }
    }

    private List<GoodsItems> handleData(List<GoodsItems> list) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList<GoodsItems>(0);
        }
        return list.stream().peek(h -> {
            h.setCosRatio(StringUtils.isNotBlank((CharSequence)h.getCosRatio()) ? h.getCosRatio() + "%" : "");
            h.setTotalSales30Day(NumberConverterUtil.numToAbbrConverter(h.getTotalSales30Day()));
            h.setLiveSales30Day(NumberConverterUtil.numToAbbrConverter(h.getLiveSales30Day()));
            h.setAwemeSales30Day(NumberConverterUtil.numToAbbrConverter(h.getAwemeSales30Day()));
            h.setLive30Day(NumberConverterUtil.numToAbbrConverter(h.getLive30Day()));
            h.setAweme30Day(NumberConverterUtil.numToAbbrConverter(h.getAweme30Day()));
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(GoodsCollectDTO dto) {
        if (dto.getCollect() == 1) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(GoodsCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        GoodsVO entity = dto.getEntity();
        if (dto.getCollect() == 1) {
            GoodsCollect collect = new GoodsCollect();
            collect.setGoodsId(entity.getGoodsId());
            collect.setPlatform(1);
            collect.setElsAccount(elsAccount);
            collect.setSubAccount(subAccount);
            this.save((Object)collect);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(GoodsCollect::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(GoodsCollect::getPlatform, (Object)1);
            queryWrapper.lambda().eq(GoodsCollect::getGoodsId, (Object)entity.getGoodsId());
            this.remove((Wrapper)queryWrapper);
        }
    }

    private void addMarkToSpider(GoodsCollectDTO dto) {
        this.saveEntity(dto.getEntity());
    }

    private void saveEntity(GoodsVO vo) {
        Goods entity = new Goods();
        entity.setGoodsId(vo.getGoodsId());
        entity.setImageUrl(vo.getImageUrl());
        entity.setTitle(vo.getTitle());
        entity.setPriceRange(vo.getPriceRange());
        entity.setCosRatio(vo.getCosRatio().contains("%") ? vo.getCosRatio().split("%")[0] : "");
        entity.setTotalSales(NumberConverterUtil.abbrToNumConverter(vo.getTotalSales()));
        entity.setLivesSales(NumberConverterUtil.abbrToNumConverter(vo.getLivesSales()));
        entity.setVideosSales(NumberConverterUtil.abbrToNumConverter(vo.getVideosSales()));
        entity.setLivesNum(NumberConverterUtil.abbrToNumConverter(vo.getLivesNum()));
        entity.setVideosNum(NumberConverterUtil.abbrToNumConverter(vo.getVideosNum()));
        entity.setDetailUrl(vo.getDetailUrl());
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(Goods::getGoodsId, (Object)entity.getGoodsId());
        Goods info = (Goods)((Object)this.goodsMapper.selectOne((Wrapper)query));
        if (info == null) {
            entity.setPlatform(1);
            entity.setId("");
            this.goodsMapper.insert((Object)entity);
        } else {
            entity.setId(info.getId());
            this.goodsMapper.updateById((Object)entity);
        }
    }
}

