/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.service.JobRpcService;
import com.els.modules.common.utils.DataFormatUtils;
import com.els.modules.store.entity.StoreHead;
import com.els.modules.store.entity.StoreItem;
import com.els.modules.store.service.StoreHeadService;
import com.els.modules.store.service.StoreItemService;
import com.els.modules.topman.entity.TopManShopItemList;
import com.els.modules.topman.service.TopManShopItemListService;
import com.mongodb.client.MongoCursor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class StoreJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(StoreJob.class);
    private final String STORE_COLLECTION_NAME = "tb_doudian_shop_detail";
    private final int BATCH_SIZE = 5000;
    @Resource
    private StoreHeadService storeHeadService;
    @Resource
    private StoreItemService storeItemService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private TopManShopItemListService topManShopItemListService;

    public void execute(String parameter) {
        log.info("------------start StoreJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_shop_detail").find().noCursorTimeout(true).batchSize(5000).cursor();){
            List<String> headIds;
            ArrayList<StoreHead> headList = new ArrayList<StoreHead>();
            ArrayList<StoreItem> itemList = new ArrayList<StoreItem>();
            log.info("------------start StoreJob cursor -----------1");
            while (cursor.hasNext()) {
                ++i;
                Document doc = (Document)cursor.next();
                try {
                    StoreHead head = this.insertStoreHead(doc);
                    StoreItem item = this.insertStoreItem(doc);
                    headList.add(head);
                    itemList.add(item);
                }
                catch (Exception e) {
                    log.error("StoreJob error ", (Throwable)e);
                }
                if (i % 1000 != 0) continue;
                log.info("------------start StoreJob cursor -----------" + i);
                try {
                    this.storeHeadService.saveOrUpdateBatch(headList);
                    headIds = itemList.stream().map(StoreItem::getHeadId).distinct().collect(Collectors.toList());
                    this.storeItemService.deleteBatch(headIds);
                    this.storeItemService.saveBatch(itemList);
                }
                catch (Exception e) {
                    log.error("saveOrUpdateBatch error", (Throwable)e);
                }
                headList = new ArrayList();
                itemList = new ArrayList();
            }
            log.info("------------start StoreJob cursor -----------" + i);
            this.storeHeadService.saveOrUpdateBatch(headList);
            headIds = itemList.stream().map(StoreItem::getHeadId).distinct().collect(Collectors.toList());
            this.storeItemService.deleteBatch(headIds);
            this.storeItemService.saveBatch(itemList);
        }
        catch (Exception e) {
            log.error("StoreJob error", (Throwable)e);
        }
    }

    private StoreHead insertStoreHead(Document doc) {
        StoreHead head = new StoreHead();
        head.setId(doc.getString((Object)"_id"));
        head.setLogo(doc.getString((Object)"shop_pic"));
        head.setElsAccount("100000");
        head.setName(doc.getString((Object)"shop_name"));
        head.setPlatform("1");
        head.setShopId(doc.getString((Object)"shop_id"));
        head.setCategory(doc.getString((Object)"shop_category"));
        Map<String, BigDecimal> shopDsrs = this.getShopDsrs((Document)doc.get((Object)"shop_dsr"));
        head.setExperienceNum(shopDsrs.get("experienceScore"));
        head.setGoodsExperience(shopDsrs.get("productExperienceScore"));
        head.setService(shopDsrs.get("shopServiceScore"));
        head.setLogisticsExperience(shopDsrs.get("logisticsScore"));
        Document shopContact = (Document)doc.get((Object)"shop_contact", Document.class);
        head.setShopPhone(shopContact.getString((Object)"phone"));
        return head;
    }

    private Map<String, BigDecimal> getShopDsrs(Document doc) {
        HashMap<String, BigDecimal> shopDsrs = new HashMap<String, BigDecimal>();
        BigDecimal experienceScore = BigDecimal.ZERO;
        BigDecimal productExperienceScore = BigDecimal.ZERO;
        BigDecimal logisticsScore = BigDecimal.ZERO;
        BigDecimal shopServiceScore = BigDecimal.ZERO;
        if (doc.get((Object)"experience_score") != null) {
            experienceScore = DataFormatUtils.numberToBigDecimal(doc.get((Object)"experience_score"));
        }
        if (doc.get((Object)"product_experience_score") != null) {
            productExperienceScore = DataFormatUtils.numberToBigDecimal(doc.get((Object)"product_experience_score"));
        }
        if (doc.get((Object)"logistics_score") != null) {
            logisticsScore = DataFormatUtils.numberToBigDecimal(doc.get((Object)"logistics_score"));
        }
        if (doc.get((Object)"shop_service_score") != null) {
            shopServiceScore = DataFormatUtils.numberToBigDecimal(doc.get((Object)"shop_service_score"));
        }
        shopDsrs.put("experienceScore", experienceScore);
        shopDsrs.put("productExperienceScore", productExperienceScore);
        shopDsrs.put("logisticsScore", logisticsScore);
        shopDsrs.put("shopServiceScore", shopServiceScore);
        return shopDsrs;
    }

    private StoreItem insertStoreItem(Document doc) {
        StoreItem item = new StoreItem();
        item.setElsAccount("100000");
        item.setHeadId(doc.getString((Object)"_id"));
        Map<String, String> shopDatas = this.getShopDatas((Document)doc.get((Object)"shop_data"));
        item.setSalesNum(DataFormatUtils.stringToBigDecimal(shopDatas.get("sellNum")));
        item.setTopmanNum(DataFormatUtils.stringToBigDecimal(shopDatas.get("authorNum")));
        item.setQueryDay("30");
        List<TopManShopItemList> list = this.topManShopItemListService.selectByShopId(doc.getString((Object)"shop_id"));
        if (CollectionUtil.isNotEmpty(list)) {
            BigDecimal goodsNum = list.stream().map(TopManShopItemList::getPopularizeGoodsQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal livesNum = list.stream().map(TopManShopItemList::getLiveQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal videosNum = list.stream().map(TopManShopItemList::getVideoQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            item.setGoodsNum(goodsNum);
            item.setLivesNum(livesNum);
            item.setVideosNum(videosNum);
        }
        return item;
    }

    private Map<String, String> getShopDatas(Document doc) {
        HashMap<String, String> shopDatas = new HashMap<String, String>();
        String sellNum = "";
        String authorNum = "";
        if (doc.get((Object)"sell_num30") != null) {
            sellNum = (String)doc.get((Object)"sell_num30");
        }
        if (doc.get((Object)"author_num30") != null) {
            authorNum = (String)doc.get((Object)"author_num30");
        }
        shopDatas.put("sellNum", sellNum);
        shopDatas.put("authorNum", authorNum);
        return shopDatas;
    }
}

