/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.RedBookTopManCollectDTO;
import com.els.modules.industryinfo.dto.RedBookTopManDetailDTO;
import com.els.modules.industryinfo.dto.RedBookTopManInformationDTO;
import com.els.modules.industryinfo.entity.RedBookTopManInformation;
import com.els.modules.industryinfo.service.RedBookTopManInformationService;
import com.els.modules.industryinfo.utils.spider.vo.RedBookTopManDetailHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rb/topMan"})
@Api(tags={"\u5c0f\u7ea2\u4e66\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class RedBookTopManController {
    @Autowired
    private RedBookTopManInformationService redBookTopManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<?> listAll(@RequestBody SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        IPage<RedBookTopManInformation> pageList = this.redBookTopManInformationService.queryTopManList(topManDto);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="0") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        return Result.ok(this.redBookTopManInformationService.getOptions(type, clearCache));
    }

    @PostMapping(value={"/collect"})
    @AutoLog(value="\u6536\u85cf\u8fbe\u4eba")
    public Result<?> collect(@RequestBody RedBookTopManCollectDTO dto) {
        this.redBookTopManInformationService.collect(dto);
        return Result.ok();
    }

    @PostMapping(value={"/addMark"})
    @AutoLog(value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    public Result<?> addMarkToSpider(@RequestBody RedBookTopManCollectDTO dto) {
        this.redBookTopManInformationService.addMarkToSpider(dto);
        return Result.ok();
    }

    @ApiOperation(value="\u8be6\u60c5\u5934\u90e8", notes="\u8be6\u60c5\u5934\u90e8")
    @PostMapping(value={"/detailHead"})
    public Result<?> getDetailHead(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailHead(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u8d8b\u52bf", notes="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u8d8b\u52bf")
    @PostMapping(value={"/detailFansOverall"})
    public Result<?> getDetailFansOverall(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailFansOverall(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u753b\u50cf", notes="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u753b\u50cf")
    @PostMapping(value={"/detailFansProfile"})
    public Result<?> getDetailFansProfile(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailFansProfile(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790-\u7b14\u8bb0\u6982\u89c8", notes="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790-\u7b14\u8bb0\u6982\u89c8")
    @PostMapping(value={"/detailNotesRate"})
    public Result<?> getDetailNotesRate(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailNotesRate(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790-\u7b14\u8bb0\u5217\u8868", notes="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790-\u7b14\u8bb0\u5217\u8868")
    @PostMapping(value={"/detailNotesDetail"})
    public Result<?> getDetailNotesDetail(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailNotesDetail(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u63a8\u5e7f\u5206\u6790", notes="\u8be6\u60c5-\u63a8\u5e7f\u5206\u6790")
    @PostMapping(value={"/detailPromotion"})
    public Result<?> getDetailPromotion(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailPromotion(dto);
        return Result.ok((Object)vo);
    }
}

