/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.mapper.TopManMsgTaskMapper;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.service.TopManMsgTaskService;
import com.els.modules.industryinfo.utils.spider.entity.LoginRp;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.vo.TopManInformationVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgTaskServiceImpl
extends BaseServiceImpl<TopManMsgTaskMapper, TopManMsgTask>
implements TopManMsgTaskService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskServiceImpl.class);
    @Autowired
    private TopManInformationService topManInformationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Lazy
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;

    private TopManMsgTask getOneByPlatform(String platform) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)));
    }

    @Override
    public void saveBySubAccount(TopManMsgTask topManMsgTask, String type) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask db = this.getOneByPlatform(topManMsgTask.getPlatform());
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            topManMsgTask.setSubAccount(loginUser.getSubAccount());
            topManMsgTask.setDeleted(CommonConstant.STATUS_NO);
            ((TopManMsgTaskMapper)this.baseMapper).insert((Object)topManMsgTask);
        } else {
            topManMsgTask.setId(db.getId());
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
        switch (type) {
            case "1": {
                updateWrapper.set((Object)"filter_info_json", (Object)topManMsgTask.getFilterInfoJson());
                break;
            }
            case "2": {
                this.checkPsd(topManMsgTask);
                updateWrapper.set((Object)"platform_url", (Object)topManMsgTask.getPlatformUrl());
                updateWrapper.set((Object)"platform_account", (Object)topManMsgTask.getPlatformAccount());
                updateWrapper.set((Object)"platform_psd", (Object)topManMsgTask.getPlatformPsd());
                break;
            }
            case "3": {
                updateWrapper.set((Object)"msg_id", (Object)topManMsgTask.getMsgId());
            }
        }
        this.update((Wrapper)updateWrapper);
    }

    private void checkPsd(TopManMsgTask topManMsgTask) {
        switch (topManMsgTask.getPlatform()) {
            case "1": {
                HashMap params = Maps.newHashMap();
                params.put("userName", topManMsgTask.getPlatformAccount());
                params.put("userPwd", topManMsgTask.getPlatformPsd());
                LoginRp loginRp = this.spiderApiUtil.postForEntityNotCheckTime(SpiderMethodType.DOUYIN_IM_LOGIN, params, LoginRp.class);
            }
        }
    }

    @Override
    public void edit(TopManMsgTask topManMsgTask) {
        int count = ((TopManMsgTaskMapper)this.baseMapper).updateById((Object)topManMsgTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void startUp(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getMsgId()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u6d88\u606f\u8bbe\u7f6e");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformUrl()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5730\u5740");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5bc6\u7801");
        ArrayList sends = Lists.newArrayList();
        List subLists = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSubAdd, (Object)"1")).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).isNull(TopManMsgRecord::getTaskId));
        String filterInfoJson = topManMsgTask.getFilterInfoJson();
        Assert.isTrue((CollUtil.isNotEmpty((Collection)subLists) || StrUtil.isNotBlank((CharSequence)filterInfoJson) ? 1 : 0) != 0, (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u6dfb\u52a0\u5efa\u8054\u8fbe\u4eba\u6216\u672a\u8bbe\u7f6e\u68c0\u7d22\u6761\u4ef6");
        int pageSize = 400;
        if (CollUtil.isNotEmpty((Collection)subLists)) {
            pageSize -= subLists.size();
            sends.addAll(subLists);
        }
        if (pageSize > 0 && StrUtil.isNotBlank((CharSequence)filterInfoJson)) {
            JSONObject jsonObject = JSON.parseObject((String)filterInfoJson);
            TopManInformationVO topManInformationVO = (TopManInformationVO)jsonObject.getObject("filterInfo", TopManInformationVO.class);
            Assert.isTrue((ObjectUtil.isNotEmpty((Object)topManInformationVO.getScreenItem()) && (CollUtil.isNotEmpty(topManInformationVO.getScreenItem().getCargoInformation()) || CollUtil.isNotEmpty(topManInformationVO.getScreenItem().getTalentInformation()) || CollUtil.isNotEmpty(topManInformationVO.getScreenItem().getOther()) || CollUtil.isNotEmpty(topManInformationVO.getScreenItem().getTalentClassification())) ? 1 : 0) != 0, (String)"\u68c0\u7d22\u6761\u4ef6\u4e3a\u7a7a");
            SimplePostRequestParam topManDto = new SimplePostRequestParam();
            topManDto.setKeyWord(jsonObject.getString("keyWord"));
            topManDto.setFilterInfo((Object)topManInformationVO);
            topManDto.setPageSize(Integer.valueOf(pageSize));
            IPage<? extends TopManResultEntity> page = this.topManInformationService.queryTopManList((SimplePostRequestParam<TopManInformationVO>)topManDto, TopManQueryType.onlyIdByMsgTask);
            Assert.isTrue((CollUtil.isNotEmpty((Collection)sends) || CollUtil.isNotEmpty((Collection)page.getRecords()) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u53ef\u4ee5\u89e6\u8fbe\u7684\u8fbe\u4eba");
            if (ObjectUtil.isNotEmpty(page) && CollUtil.isNotEmpty((Collection)page.getRecords())) {
                List topManMsgRecord = page.getRecords().stream().map(x -> {
                    TopManMsgRecord record = new TopManMsgRecord();
                    record.setMsgId(topManMsgTask.getMsgId());
                    record.setTaskId(topManMsgTask.getId());
                    record.setSubAccount(topManMsgTask.getSubAccount());
                    record.setTopmanId(x.getTopManId());
                    record.setTopmanName(x.getTopManName());
                    record.setRelationId(x.getId());
                    record.setPlatform(x.getPlatform());
                    record.setSendStatus("0");
                    record.setReplyStatus("0");
                    record.setDeleted(CommonConstant.STATUS_NO);
                    record.setId(IdWorker.getIdStr());
                    return record;
                }).collect(Collectors.toList());
                sends.addAll(topManMsgRecord);
            }
        }
        if (CollUtil.isNotEmpty((Collection)sends)) {
            this.sensMsg(sends, topManMsgTask);
            this.saveRecord(topManMsgTask, sends);
            topManMsgTask.setStatus("1");
        }
        this.updateById((Object)topManMsgTask);
    }

    private void sensMsg(List<TopManMsgRecord> sends, TopManMsgTask topManMsgTask) {
        ArrayList rqs = Lists.newArrayList();
        sends.forEach(x -> {
            if (StrUtil.isNotBlank((CharSequence)x.getTopmanName())) {
                TopmanMsgRqDto rq = new TopmanMsgRqDto();
                rq.setTaskId(x.getId());
                rq.setTopmanName(x.getTopmanName());
                rqs.add(rq);
            }
        });
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        params.put("content", ((TopManMsgConfig)((Object)this.topManMsgConfigService.getById((Serializable)((Object)topManMsgTask.getMsgId())))).getMsgContent());
        params.put("topmanList", rqs);
        log.info("rqs[{}]", (Object)JSON.toJSONString((Object)rqs));
        log.info("rqs2[{}]", (Object)JSON.toJSONString((Object)params));
        LoginRp rp = this.spiderApiUtil.postForEntityNotCheckTime(SpiderMethodType.DOUYIN_IM_MESSAGE, params, LoginRp.class);
        log.info("\u53d1\u9001\u6d88\u606frp is [{}]", (Object)JSON.toJSONString((Object)rp));
    }

    private void saveRecord(TopManMsgTask topManMsgTask, List<TopManMsgRecord> sends) {
        ArrayList adds = Lists.newArrayList();
        ArrayList edits = Lists.newArrayList();
        sends.forEach(x -> {
            x.setMsgId(topManMsgTask.getMsgId());
            x.setTaskId(topManMsgTask.getId());
            if (StrUtil.isBlank((CharSequence)x.getId())) {
                adds.add(x);
            } else {
                edits.add(x);
            }
        });
        if (CollUtil.isNotEmpty((Collection)adds)) {
            this.topManMsgRecordService.saveBatch(sends);
        }
        if (CollUtil.isNotEmpty((Collection)edits)) {
            this.topManMsgRecordService.updateBatchById(edits);
        }
    }

    @Override
    public void stop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        topManMsgTask.setStatus("0");
        this.updateById((Object)topManMsgTask);
    }

    @Override
    public TopManMsgTask getData(String platform) {
        TopManMsgTask db = this.getOneByPlatform(platform);
        return db;
    }
}

