/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.industryinfo.dto.GoodsItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsLiveRecord;
import com.els.modules.industryinfo.entity.TopManLiveItemList;
import com.els.modules.industryinfo.mapper.GoodsLiveRecordMapper;
import com.els.modules.industryinfo.mapper.TopManLiveItemListMapper;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.GoodsLiveRecordService;
import com.els.modules.industryinfo.vo.GoodsLiveRecordVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsLiveRecordServiceImpl
extends BaseServiceImpl<GoodsLiveRecordMapper, GoodsLiveRecord>
implements GoodsLiveRecordService {
    @Autowired
    private GoodsLiveRecordMapper goodsLiveRecordMapper;
    @Autowired
    private GoodsHeadService goodsHeadService;
    @Resource
    private TopManLiveItemListMapper topManLiveItemListMapper;

    @Override
    public List<GoodsLiveRecord> selectByMainId(String mainId) {
        return this.goodsLiveRecordMapper.selectByMainId(mainId);
    }

    @Override
    public IPage<GoodsLiveRecordVO> queryLivePage(Page<TopManLiveItemList> page, QueryWrapper<TopManLiveItemList> queryWrapper, GoodsItemQueryDTO queryDTO) {
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        IPage<GoodsLiveRecordVO> livePage = this.topManLiveItemListMapper.topManLiveItemListPage(page, queryWrapper, queryDTO);
        if (CollectionUtils.isNotEmpty((Collection)livePage.getRecords())) {
            GoodsHead goodsHead = this.goodsHeadService.selectByGoodsId(queryDTO.getGoodsId());
            for (GoodsLiveRecordVO vo : livePage.getRecords()) {
                if (goodsHead != null) {
                    vo.setGoodsPrice(goodsHead.getPrice());
                }
                if (vo.getSalesAmountMax() != null && vo.getGoodsPrice() != null && vo.getGoodsPrice().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal salesNum = vo.getSalesAmountMax().divide(vo.getGoodsPrice(), 0, 4);
                    vo.setSalesNum(salesNum);
                }
                if (vo.getSalesNum() == null || vo.getLiveBrowsesNum() == null || vo.getLiveBrowsesNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal convertRate = vo.getSalesNum().divide(vo.getLiveBrowsesNum(), 4, 4);
                vo.setConvertRate(convertRate);
            }
        }
        return livePage;
    }
}

