/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.utils.spider.spiderApi;

import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.industryinfo.utils.spider.entity.LoginRp;
import com.els.modules.industryinfo.utils.spider.properties.SpiderBaseProperties;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderResponse;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SpiderApiUtil {
    private final Map<String, String> spiderApiMethods = new HashMap<String, String>(20);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Autowired
    private ApplicationContext applicationContext;
    private final RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory(){
        {
            this.setReadTimeout(5000);
            this.setConnectTimeout(5000);
        }
    });
    private final RestTemplate RT = new RestTemplate();
    public static final ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor(){
        {
            this.setCorePoolSize(3);
            this.setMaxPoolSize(5);
            this.setKeepAliveSeconds(60);
            this.setThreadNamePrefix("spider-api-");
            this.initialize();
        }
    };

    public <T> T getForEntity(SpiderMethodType methodType, Map<String, Object> param, Class<T> resultClass) {
        AtomicReference result = new AtomicReference();
        Optional<String> redisKey = Optional.ofNullable(this.getRedisKey(methodType, param));
        redisKey.ifPresent(key -> result.set(this.redisUtil.get(key)));
        if (result.get() == null) {
            String paramString = this.getParamString(param);
            String method = this.findMethod(methodType.getPropertiesClass(), methodType.getFieldName());
            String url = this.spiderBaseProperties.getUrl() + ":" + this.spiderBaseProperties.getPort() + method + paramString;
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, methodType.getBeanClass(), new Object[0]);
            result.set(this.handleResult(forEntity, resultClass));
            redisKey.ifPresent(key -> this.redisUtil.set(key, result.get(), (long)methodType.getCacheTime().intValue()));
        }
        return (T)result.get();
    }

    public <T> T postForEntity(SpiderMethodType methodType, Map<?, ?> param, Class<T> resultClass) {
        AtomicReference result = new AtomicReference();
        Optional<String> redisKey = Optional.ofNullable(this.getRedisKey(methodType, param));
        redisKey.ifPresent(key -> result.set(this.redisUtil.get(key)));
        if (result.get() == null) {
            String method = this.findMethod(methodType.getPropertiesClass(), methodType.getFieldName());
            String url = this.spiderBaseProperties.getUrl() + ":" + this.spiderBaseProperties.getPort() + method;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json");
            HttpEntity paramEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)paramEntity, methodType.getBeanClass(), new Object[0]);
            result.set(this.handleResult(forEntity, resultClass));
            redisKey.ifPresent(key -> this.redisUtil.set(key, result.get(), (long)methodType.getCacheTime().intValue()));
        }
        return (T)result.get();
    }

    public <T> T postForEntityNotCheckTime(SpiderMethodType methodType, Map<String, Object> param, Class<T> resultClass) {
        AtomicReference<T> result = new AtomicReference<T>();
        if (result.get() == null) {
            String method = this.findMethod(methodType.getPropertiesClass(), methodType.getFieldName());
            String url = this.spiderBaseProperties.getUrl() + ":" + this.spiderBaseProperties.getPort() + method;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json");
            HttpEntity paramEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity forEntity = this.RT.postForEntity(url, (Object)paramEntity, methodType.getBeanClass(), new Object[0]);
            result.set(this.handleResult(forEntity, resultClass));
        }
        return (T)result.get();
    }

    private <T> T handleResult(ResponseEntity<?> entity, Class<T> resultClass) {
        this.checkRequest(entity);
        Object response = Objects.requireNonNull(entity.getBody());
        if (response instanceof LoginRp) {
            return (T)response;
        }
        Object result = response instanceof SpiderResponse ? ((SpiderResponse)response).getData() : response;
        return (T)result;
    }

    private String getRedisKey(SpiderMethodType methodType, Map<?, ?> param) {
        String redisKey = null;
        if (methodType.getCacheTime() != null) {
            StringBuilder sb = new StringBuilder("SPIDER_").append(methodType.name());
            param.values().forEach(a -> sb.append("_").append(a));
            redisKey = sb.toString();
        }
        return redisKey;
    }

    private String findMethod(Class<?> propertiesClass, String fieldName) {
        try {
            String methodKey = propertiesClass.getName() + "_" + fieldName;
            String method = this.spiderApiMethods.get(methodKey);
            if (method == null) {
                Field declaredField = propertiesClass.getDeclaredField(fieldName);
                Object properties = this.applicationContext.getBean(propertiesClass);
                declaredField.setAccessible(true);
                method = (String)declaredField.get(properties);
                this.spiderApiMethods.put(methodKey, method);
            }
            return method;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkRequest(ResponseEntity<?> forEntity) {
        if (!HttpStatus.OK.equals((Object)forEntity.getStatusCode())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8bf7\u6c42\u5931\u8d25"));
        }
        Object body = forEntity.getBody();
        if (body == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u6682\u65e0\u6570\u636e"));
        }
        if (body instanceof LoginRp && ((LoginRp)body).getCode() == 200) {
            return;
        }
        if (body instanceof SpiderResponse && 200 != ((SpiderResponse)body).getStatus()) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)((SpiderResponse)body).getMsg()));
        }
    }

    private String getParamString(Map<String, Object> param) {
        StringBuilder sb = new StringBuilder("?");
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || "".equals(key) || value == null) continue;
            sb.append(key).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean checkCache(SpiderMethodType methodType, Map<String, Object> param) {
        String key = null;
        if (methodType.getCacheTime() != null) {
            StringBuilder sb = new StringBuilder("SPIDER_").append(methodType.name());
            param.values().forEach(a -> sb.append(a).append("_"));
            key = sb.toString();
        }
        if (key != null) {
            return methodType.getCheckFunction().accept(this.redisUtil.get(key));
        }
        return false;
    }
}

