/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.mapper.TopManMsgTaskMapper;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.service.TopManMsgTaskService;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManIndexListPage;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManInfoEntity;
import com.els.modules.industryinfo.utils.spider.entity.LoginRp;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.properties.TopManMsgProperties;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgTaskServiceImpl
extends BaseServiceImpl<TopManMsgTaskMapper, TopManMsgTask>
implements TopManMsgTaskService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskServiceImpl.class);
    @Autowired
    private TopManInformationService topManInformationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Lazy
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;

    private TopManMsgTask getOneByPlatform(String platform) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveBySubAccount(TopManMsgTask topManMsgTask, String type) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask db = this.getOneByPlatform(topManMsgTask.getPlatform());
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            topManMsgTask.setSubAccount(loginUser.getSubAccount());
            topManMsgTask.setDeleted(CommonConstant.STATUS_NO);
            ((TopManMsgTaskMapper)this.baseMapper).insert((Object)topManMsgTask);
        } else {
            topManMsgTask.setId(db.getId());
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
        switch (type) {
            case "1": {
                updateWrapper.set((Object)"filter_info_json", (Object)topManMsgTask.getFilterInfoJson());
                break;
            }
            case "2": {
                this.checkPsd(topManMsgTask);
                updateWrapper.set((Object)"platform_url", (Object)topManMsgTask.getPlatformUrl());
                updateWrapper.set((Object)"platform_account", (Object)topManMsgTask.getPlatformAccount());
                updateWrapper.set((Object)"platform_psd", (Object)topManMsgTask.getPlatformPsd());
                break;
            }
            case "3": {
                updateWrapper.set((Object)"msg_id", (Object)topManMsgTask.getMsgId());
            }
        }
        this.update((Wrapper)updateWrapper);
    }

    private void checkPsd(TopManMsgTask topManMsgTask) {
        switch (topManMsgTask.getPlatform()) {
            case "1": {
                HashMap params = Maps.newHashMap();
                params.put("userName", topManMsgTask.getPlatformAccount());
                params.put("userPwd", topManMsgTask.getPlatformPsd());
                LoginRp loginRp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.DOUYIN_IM_LOGIN, params, LoginRp.class);
            }
        }
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).ne(BaseEntity::getId, (Object)topManMsgTask.getId())) == 0 ? 1 : 0) != 0, (String)"\u6b64\u8d26\u53f7\u5df2\u88ab\u4f7f\u7528");
    }

    @Override
    public void edit(TopManMsgTask topManMsgTask) {
        int count = ((TopManMsgTaskMapper)this.baseMapper).updateById((Object)topManMsgTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void startUp(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getMsgId()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u6d88\u606f\u8bbe\u7f6e");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5bc6\u7801");
        int limitSize = this.topManMsgProperties.getLimit();
        List sends = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"0"));
        if (CollUtil.isEmpty((Collection)sends)) {
            sends = Lists.newArrayList();
        } else {
            sends.forEach(x -> x.setSubAdd("2"));
        }
        String filterInfoJson = topManMsgTask.getFilterInfoJson();
        if ((limitSize -= sends.size()) > 0) {
            List subLists = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSubAdd, (Object)"1")).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).isNull(TopManMsgRecord::getTaskId)).last("limit " + limitSize));
            Assert.isTrue((CollUtil.isNotEmpty((Collection)sends) || CollUtil.isNotEmpty((Collection)subLists) || StrUtil.isNotBlank((CharSequence)filterInfoJson) ? 1 : 0) != 0, (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u6dfb\u52a0\u5efa\u8054\u8fbe\u4eba\u6216\u672a\u8bbe\u7f6e\u68c0\u7d22\u6761\u4ef6");
            if (CollUtil.isNotEmpty((Collection)subLists)) {
                limitSize -= subLists.size();
                sends.addAll(subLists);
            }
        }
        if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)filterInfoJson)) {
            SimplePostRequestParam topManDto = new SimplePostRequestParam();
            RequestOptionVO requestOptionVO = new RequestOptionVO();
            JSONObject jsonObject = JSON.parseObject((String)filterInfoJson);
            JSONObject f = jsonObject.getJSONObject("filterInfo");
            requestOptionVO.setTaskType(f.getString("taskType"));
            requestOptionVO.setPlatformType(f.getString("platformType"));
            JSONObject screen = f.getJSONObject("screenItem");
            HashMap screenItem = Maps.newHashMap();
            screen.keySet().forEach(key -> {
                JSONArray jsonArray = screen.getJSONArray(key);
                screenItem.put(key, jsonArray.toJavaList(RequestOptionVO.ScreenItem.class));
            });
            requestOptionVO.setScreenItem((Map)screenItem);
            topManDto.setFilterInfo((Object)requestOptionVO);
            topManDto.setKeyWord(f.getString("keyWord"));
            List<TopManMsgRecord> searchList = this.handleDouYinListData((SimplePostRequestParam<RequestOptionVO>)topManDto, topManMsgTask, limitSize);
            sends.addAll(searchList);
        }
        if (CollUtil.isNotEmpty((Collection)sends)) {
            this.sensMsg(sends, topManMsgTask);
            this.saveRecord(topManMsgTask, sends);
            topManMsgTask.setStatus("1");
        }
        this.updateById((Object)topManMsgTask);
    }

    private List<TopManMsgRecord> handleDouYinListData(SimplePostRequestParam<RequestOptionVO> topManDto, TopManMsgTask task, int limit) {
        ArrayList list = Lists.newArrayList();
        List oldTaskRecord = this.topManMsgRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)task.getId()));
        List oldTopManNames = oldTaskRecord.stream().map(x -> x.getTopmanName()).distinct().collect(Collectors.toList());
        int total = this.topManMsgProperties.getPageSize();
        int totalData = 0;
        int pageNo = 1;
        boolean endFlag = true;
        while (endFlag) {
            topManDto.setPageNo(Integer.valueOf(pageNo));
            topManDto.setPageSize(Integer.valueOf(total));
            Map<String, Object> apiParam = this.topManInformationService.getApiParam(topManDto);
            DyTopManIndexListPage apiResult = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_INDEX_LIST, apiParam, DyTopManIndexListPage.class);
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getList())) {
                ++pageNo;
                for (DyTopManInfoEntity apiData : apiResult.getList()) {
                    if (ObjectUtil.isEmpty((Object)apiData.getAuthorBase()) || ObjectUtil.isEmpty((Object)apiData.getAuthorBase().getNickname()) || oldTopManNames.contains(apiData.getAuthorBase().getNickname())) continue;
                    if (totalData >= limit) {
                        return list;
                    }
                    oldTopManNames.add(apiData.getAuthorBase().getNickname());
                    TopManMsgRecord topManMsgRecord = new TopManMsgRecord();
                    topManMsgRecord.setTaskId(task.getId());
                    topManMsgRecord.setSendStatus("0");
                    topManMsgRecord.setPlatform(task.getPlatform());
                    topManMsgRecord.setMsgId(task.getMsgId());
                    topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
                    topManMsgRecord.setElsAccount(task.getElsAccount());
                    topManMsgRecord.setSubAccount(task.getSubAccount());
                    topManMsgRecord.setId(IdWorker.getIdStr());
                    topManMsgRecord.setTopmanId(apiData.getAuthorBase().getUid());
                    topManMsgRecord.setTopmanName(apiData.getAuthorBase().getNickname());
                    topManMsgRecord.setAvatar(apiData.getAuthorBase().getAvatar());
                    if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorBase().getFansNum())) {
                        topManMsgRecord.setFansNum(apiData.getAuthorBase().getFansNum().toString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorVideo()) && ObjectUtil.isNotEmpty((Object)apiData.getAuthorVideo().getPlayMedian())) {
                        topManMsgRecord.setVideoPlayAvg(apiData.getAuthorVideo().getPlayMedian().toString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive())) {
                        if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getWatchingNumber())) {
                            topManMsgRecord.setWatchingNumber(apiData.getAuthorLive().getWatchingNumber().toString());
                        }
                        if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getSaleLow()) && ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getSaleHigh())) {
                            topManMsgRecord.setLiveSaleAvg(apiData.getAuthorLive().getSaleLow().toString() + " - " + apiData.getAuthorLive().getSaleHigh());
                        }
                    }
                    list.add(topManMsgRecord);
                    ++totalData;
                }
                continue;
            }
            endFlag = false;
        }
        return list;
    }

    private void sensMsg(List<TopManMsgRecord> sends, TopManMsgTask topManMsgTask) {
        ArrayList rqs = Lists.newArrayList();
        sends.forEach(x -> {
            if (StrUtil.isNotBlank((CharSequence)x.getTopmanName())) {
                TopmanMsgRqDto rq = new TopmanMsgRqDto();
                rq.setTaskId(x.getId());
                rq.setTopmanName(x.getTopmanName());
                rqs.add(rq);
            }
        });
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        params.put("content", ((TopManMsgConfig)((Object)this.topManMsgConfigService.getById((Serializable)((Object)topManMsgTask.getMsgId())))).getMsgContent());
        params.put("topmanList", rqs);
        log.info("\u8bf7\u6c42py\u6296\u97f3\u53d1\u9001\u6d88\u606f\u5165\u53c2[{}]", (Object)JSON.toJSONString((Object)params));
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.DOUYIN_IM_MESSAGE, params, LoginRp.class);
        log.info("py\u6296\u97f3\u53d1\u9001\u6d88\u606f\u51fa\u53c2 is [{}]", (Object)JSON.toJSONString((Object)rp));
    }

    private void saveRecord(TopManMsgTask topManMsgTask, List<TopManMsgRecord> sends) {
        ArrayList saveOrUpdate = Lists.newArrayList();
        sends.forEach(x -> {
            x.setMsgId(topManMsgTask.getMsgId());
            x.setTaskId(topManMsgTask.getId());
        });
        if (CollUtil.isNotEmpty((Collection)saveOrUpdate)) {
            this.topManMsgRecordService.saveOrUpdateBatch(saveOrUpdate);
        }
    }

    @Override
    public void stop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        this.spiderApiUtil.postForEntityMsg(SpiderMethodType.DOUYIN_IM_STOP, params, LoginRp.class);
        topManMsgTask.setStatus("0");
        this.updateById((Object)topManMsgTask);
    }

    @Override
    public TopManMsgTask getData(String platform) {
        TopManMsgTask db = this.getOneByPlatform(platform);
        return db;
    }
}

