/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.vo.TopManMsgRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/msg/topManMsgRecord"})
public class TopManMsgRecordController
extends BaseController<TopManMsgRecord, TopManMsgRecordService> {
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManInformationService topManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list/{platform}/{type}"})
    public Result<?> queryPageList(TopManMsgRecord topManMsgRecord, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req, @PathVariable(value="platform") String platform, @PathVariable(value="type") String type) {
        String topManName = topManMsgRecord.getTopmanName();
        if (StrUtil.isNotBlank((CharSequence)topManName)) {
            topManMsgRecord.setTopmanName(null);
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topManMsgRecord), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"platform", (Object)platform);
        LoginUser loginUser = SysUtil.getLoginUser();
        queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
        if (StrUtil.isNotBlank((CharSequence)topManName)) {
            queryWrapper.like((Object)"topman_name", (Object)topManName);
        }
        if ("2".equals(type)) {
            queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.topManMsgRecordService.page((IPage)page, (Wrapper)queryWrapper);
        Page voPage = new Page();
        List dbs = pageList.getRecords();
        if (CollUtil.isNotEmpty((Collection)dbs)) {
            voPage.setTotal(pageList.getTotal());
            voPage.setCurrent(pageList.getCurrent());
            voPage.setSize(pageList.getSize());
            List msgIds = dbs.stream().map(x -> x.getMsgId()).distinct().collect(Collectors.toList());
            Map<String, TopManMsgConfig> msgm = this.topManMsgConfigService.listByIds(msgIds).stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
            List list = dbs.stream().map(row -> {
                TopManMsgRecordVo topManMsgRecordVo = new TopManMsgRecordVo();
                BeanUtil.copyProperties((Object)row, (Object)((Object)topManMsgRecordVo), (String[])new String[0]);
                if (ObjectUtil.isNotEmpty(msgm.get(row.getMsgId()))) {
                    topManMsgRecordVo.setMsgContent(((TopManMsgConfig)((Object)((Object)msgm.get(row.getMsgId())))).getMsgContent());
                }
                return topManMsgRecordVo;
            }).collect(Collectors.toList());
            voPage.setRecords(list);
        }
        return Result.ok((Object)voPage);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TopManMsgRecord topManMsgRecord) {
        this.topManMsgRecordService.add(topManMsgRecord);
        return Result.ok((Object)((Object)topManMsgRecord));
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TopManMsgRecord topManMsgRecord) {
        this.topManMsgRecordService.edit(topManMsgRecord);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.topManMsgRecordService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.topManMsgRecordService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TopManMsgRecord topManMsgRecord = (TopManMsgRecord)((Object)this.topManMsgRecordService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)topManMsgRecord));
    }
}

