/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.service.JobRpcService;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.industryinfo.entity.GoodsDataItem;
import com.els.modules.industryinfo.entity.GoodsItem;
import com.els.modules.industryinfo.mapper.GoodsItemMapper;
import com.els.modules.industryinfo.mapper.TopManGoodsItemListMapper;
import com.els.modules.industryinfo.service.GoodsDataItemService;
import com.els.modules.industryinfo.vo.GoodsRecordVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GoodsStatJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(GoodsStatJob.class);
    @Resource
    private GoodsItemMapper goodsItemMapper;
    @Resource
    private GoodsDataItemService goodsDataItemService;
    @Resource
    private TopManGoodsItemListMapper topManGoodsItemListMapper;
    private List<String> dayList = new ArrayList<String>(){
        {
            this.add("1");
            this.add("7");
            this.add("30");
            this.add("90");
        }
    };

    private long getPages(int size) {
        Page page = new Page(1L, (long)size);
        IPage<GoodsItem> itemPage = this.goodsItemMapper.goodsItemPage((Page<GoodsItem>)page);
        long pages = itemPage.getTotal() / itemPage.getSize();
        if (itemPage.getTotal() % itemPage.getSize() != 0L) {
            ++pages;
        }
        return pages;
    }

    public void execute(String parameter) {
        log.info("------------start GoodsStatJob-----------");
        try {
            int size = 5000;
            long pages = this.getPages(size);
            int i = 1;
            while ((long)i < pages + 1L) {
                Page page = new Page((long)i, (long)size);
                IPage<GoodsItem> itemPage = this.goodsItemMapper.goodsItemPage((Page<GoodsItem>)page);
                log.info("------------insertGoodsDataItem-----------pages:" + i);
                this.insertGoodsDataItem(itemPage.getRecords());
                ++i;
            }
        }
        catch (Exception e) {
            log.error("GoodsStatJob error ", (Throwable)e);
        }
    }

    private void insertGoodsDataItem(List<GoodsItem> itemList) {
        List<String> goodsIds = itemList.stream().map(GoodsItem::getGoodsId).distinct().collect(Collectors.toList());
        Map<String, List<GoodsItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(GoodsItem::getGoodsId));
        List<GoodsRecordVO> recordList = this.topManGoodsItemListMapper.listByGoodsIds(goodsIds);
        Map<String, List<GoodsRecordVO>> recordmMap = recordList.stream().collect(Collectors.groupingBy(GoodsRecordVO::getGoodsId));
        ArrayList<List<GoodsDataItem>> allList = new ArrayList<List<GoodsDataItem>>(10);
        ArrayList dataItemList = new ArrayList(1000);
        allList.add(dataItemList);
        int i = 0;
        for (String goodsId : goodsIds) {
            List<GoodsItem> items = itemMap.get(goodsId);
            List<GoodsRecordVO> records = recordmMap.get(goodsId);
            for (String queryDay : this.dayList) {
                List nList = (List)allList.get(i);
                GoodsDataItem goodsDataItem = this.getGoodsDataItem(goodsId, items, records, queryDay);
                nList.add(goodsDataItem);
                if (dataItemList.size() != 1000) continue;
                ++i;
                allList.add(dataItemList);
                allList.add(new ArrayList(1000));
            }
        }
        log.info("------------start GoodsStatJob cursor -----------" + i);
        this.goodsDataItemService.deleteBatch(goodsIds);
        this.goodsDataItemService.insertBatch(allList);
    }

    private GoodsDataItem getGoodsDataItem(String goodsId, List<GoodsItem> items, List<GoodsRecordVO> records, String queryDay) {
        Date[] dates = TimeTranslateUtil.dayToDate((String)queryDay);
        GoodsDataItem dataItem = new GoodsDataItem();
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal salesNum = BigDecimal.ZERO;
        BigDecimal salesNumLive = BigDecimal.ZERO;
        BigDecimal salesNumVideo = BigDecimal.ZERO;
        BigDecimal topmanNum = BigDecimal.ZERO;
        BigDecimal livesNum = BigDecimal.ZERO;
        BigDecimal videosNum = BigDecimal.ZERO;
        BigDecimal browsesNum = BigDecimal.ZERO;
        if (items != null && items.size() > 0) {
            List finalItems = items.stream().filter(h -> h.getSaleDate() != null && (h.getSaleDate().after(dates[0]) || h.getSaleDate().equals(dates[0])) && h.getSaleDate().before(dates[1])).collect(Collectors.toList());
            price = items.get(0).getPrice();
            if (finalItems.size() > 0) {
                salesNum = finalItems.stream().map(GoodsItem::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                topmanNum = finalItems.stream().map(GoodsItem::getTopmanNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                browsesNum = finalItems.stream().map(GoodsItem::getBrowsesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        if (records != null && records.size() > 0) {
            List videos;
            List lives = records.stream().filter(h -> h.getLiveStartTime() != null && (h.getLiveStartTime().after(dates[0]) || h.getLiveStartTime().equals(dates[0])) && h.getLiveStartTime().before(dates[1])).collect(Collectors.toList());
            if (lives.size() > 0) {
                salesNumLive = lives.stream().map(GoodsRecordVO::getSalesNumLive).reduce(BigDecimal.ZERO, BigDecimal::add);
                livesNum = new BigDecimal(lives.size());
            }
            if ((videos = records.stream().filter(h -> h.getVideoPublishTime() != null && (h.getVideoPublishTime().after(dates[0]) || h.getVideoPublishTime().equals(dates[0])) && h.getVideoPublishTime().before(dates[1])).collect(Collectors.toList())).size() > 0) {
                salesNumVideo = videos.stream().map(GoodsRecordVO::getSalesNumVideo).reduce(BigDecimal.ZERO, BigDecimal::add);
                videosNum = new BigDecimal(videos.size());
            }
        }
        dataItem.setElsAccount("100000");
        dataItem.setGoodsId(goodsId);
        dataItem.setSalesNum(salesNum);
        dataItem.setSalesAmountMin(price.multiply(salesNum));
        dataItem.setSalesAmountMax(price.multiply(salesNum));
        dataItem.setSalesNumLive(salesNumLive);
        dataItem.setSalesNumVideo(salesNumVideo);
        dataItem.setTopmanNum(topmanNum);
        dataItem.setLivesNum(livesNum);
        dataItem.setVideosNum(videosNum);
        dataItem.setBrowsesNum(browsesNum);
        if (browsesNum != null && browsesNum.compareTo(BigDecimal.ZERO) > 0) {
            dataItem.setConvertRate(salesNum.divide(browsesNum, 4, 4));
        }
        dataItem.setQueryDay(queryDay);
        dataItem.setCreateTime(new Date());
        dataItem.setCreateBy("admin");
        dataItem.setUpdateTime(new Date());
        dataItem.setUpdateBy("admin");
        return dataItem;
    }
}

