/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.AdapterFactory;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.adapter.msg.ITopManMessageAdapter;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.mapper.TopManMsgTaskMapper;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.service.TopManMsgTaskService;
import com.els.modules.industryinfo.utils.RedissonUtil;
import com.els.modules.industryinfo.utils.spider.entity.LoginRp;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.properties.TopManMsgProperties;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgTaskServiceImpl
extends BaseServiceImpl<TopManMsgTaskMapper, TopManMsgTask>
implements TopManMsgTaskService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskServiceImpl.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Lazy
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private AdapterFactory adapterFactory;

    @Override
    public TopManMsgTask getOneByPlatform(String platform) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveBySubAccount(TopManMsgTask topManMsgTask, String type) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask db = this.getOneByPlatform(topManMsgTask.getPlatform());
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            topManMsgTask.setSubAccount(loginUser.getSubAccount());
            topManMsgTask.setDeleted(CommonConstant.STATUS_NO);
            ((TopManMsgTaskMapper)this.baseMapper).insert((Object)topManMsgTask);
        } else {
            topManMsgTask.setId(db.getId());
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
        switch (type) {
            case "1": {
                updateWrapper.set((Object)"filter_info_json", (Object)topManMsgTask.getFilterInfoJson());
                break;
            }
            case "2": {
                this.checkPsd(topManMsgTask);
                updateWrapper.set((Object)"platform_url", (Object)topManMsgTask.getPlatformUrl());
                updateWrapper.set((Object)"platform_account", (Object)topManMsgTask.getPlatformAccount());
                updateWrapper.set((Object)"platform_psd", (Object)topManMsgTask.getPlatformPsd());
                break;
            }
            case "3": {
                updateWrapper.set((Object)"msg_id", (Object)topManMsgTask.getMsgId());
            }
        }
        this.update((Wrapper)updateWrapper);
    }

    private void checkPsd(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "login_opt"), params, LoginRp.class);
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).ne(BaseEntity::getId, (Object)topManMsgTask.getId())) == 0 ? 1 : 0) != 0, (String)"\u6b64\u8d26\u53f7\u5df2\u88ab\u4f7f\u7528");
    }

    @Override
    public void edit(TopManMsgTask topManMsgTask) {
        int count = ((TopManMsgTaskMapper)this.baseMapper).updateById((Object)topManMsgTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void startUp(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getMsgId()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u6d88\u606f\u8bbe\u7f6e");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5bc6\u7801");
        String lockKey = "TOPMAN_MSG_" + topManMsgTask.getPlatformAccount() + "_" + topManMsgTask.getPlatform();
        RLock lock = this.redissonUtil.lock(lockKey);
        Assert.notNull((Object)lock, (String)"\u6b64\u8d26\u53f7\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        try {
            int limitSize = this.topManMsgProperties.getLimit();
            List sends = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getPush, (Object)"0"));
            if (CollUtil.isEmpty((Collection)sends)) {
                sends = Lists.newArrayList();
            }
            String filterInfoJson = topManMsgTask.getFilterInfoJson();
            if ((limitSize -= sends.size()) > 0) {
                List subLists = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSubAdd, (Object)"1")).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecord::getPush, (Object)"0")).isNull(TopManMsgRecord::getTaskId)).last("limit " + limitSize));
                Assert.isTrue((CollUtil.isNotEmpty((Collection)sends) || CollUtil.isNotEmpty((Collection)subLists) || StrUtil.isNotBlank((CharSequence)filterInfoJson) ? 1 : 0) != 0, (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u6dfb\u52a0\u5efa\u8054\u8fbe\u4eba\u6216\u672a\u8bbe\u7f6e\u68c0\u7d22\u6761\u4ef6");
                if (CollUtil.isNotEmpty((Collection)subLists)) {
                    limitSize -= subLists.size();
                    sends.addAll(subLists);
                }
            }
            ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
            if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)filterInfoJson)) {
                List<TopManMsgRecord> searchList = adapter.getSearchData(filterInfoJson, topManMsgTask, limitSize);
                sends.addAll(searchList);
            }
            if (CollUtil.isNotEmpty((Collection)sends)) {
                this.sensMsg(sends, topManMsgTask);
                this.saveRecord(topManMsgTask, sends);
                topManMsgTask.setStatus("1");
            }
            this.updateById((Object)topManMsgTask);
        }
        catch (Exception e) {
            log.error("\u5f00\u542f\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            this.redissonUtil.unLock(lock);
        }
    }

    private void sensMsg(List<TopManMsgRecord> sends, TopManMsgTask topManMsgTask) {
        ArrayList rqs = Lists.newArrayList();
        sends.forEach(x -> {
            if (StrUtil.isNotBlank((CharSequence)x.getTopmanName())) {
                TopmanMsgRqDto rq = new TopmanMsgRqDto();
                rq.setTaskId(x.getId());
                rq.setTopmanName(x.getTopmanName());
                rqs.add(rq);
            }
        });
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        params.put("content", ((TopManMsgConfig)((Object)this.topManMsgConfigService.getById((Serializable)((Object)topManMsgTask.getMsgId())))).getMsgContent());
        params.put("topmanList", rqs);
        log.info("\u8bf7\u6c42py\u6296\u97f3\u53d1\u9001\u6d88\u606f\u5165\u53c2[{}]", (Object)JSON.toJSONString((Object)params));
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "send_opt"), params, LoginRp.class);
        log.info("py\u6296\u97f3\u53d1\u9001\u6d88\u606f\u51fa\u53c2 is [{}]", (Object)JSON.toJSONString((Object)rp));
    }

    private void saveRecord(TopManMsgTask topManMsgTask, List<TopManMsgRecord> sends) {
        sends.forEach(x -> {
            x.setMsgId(topManMsgTask.getMsgId());
            x.setTaskId(topManMsgTask.getId());
            x.setPush("1");
            x.setReplyStatus("0");
            x.setSendStatus("0");
        });
        this.topManMsgRecordService.saveOrUpdateBatch(sends);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void stop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(platform, "stop_opt"), params, LoginRp.class);
        topManMsgTask.setStatus("0");
        this.updateById((Object)topManMsgTask);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"is_push", (Object)"0");
        updateWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        updateWrapper.eq((Object)"send_status", (Object)"0");
        this.topManMsgRecordService.update((Wrapper)updateWrapper);
    }

    @Override
    public TopManMsgTask getData(String platform) {
        TopManMsgTask db = this.getOneByPlatform(platform);
        return db;
    }
}

