/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.BilibiliTopManCollectDTO;
import com.els.modules.industryinfo.entity.BilibiliTopManInformation;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.entity.TopManSpiderMark;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.enumerate.MongoCollectionType;
import com.els.modules.industryinfo.mapper.BilibiliTopManInformationMapper;
import com.els.modules.industryinfo.service.BilibiliTopManInformationService;
import com.els.modules.industryinfo.service.MongoEntityService;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.mongodb.client.MongoCursor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BilibiliTopManInformationServiceImpl
extends BaseServiceImpl<BilibiliTopManInformationMapper, BilibiliTopManInformation>
implements BilibiliTopManInformationService {
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(BilibiliTopManCollectDTO dto) {
        if (MarkYn.check(dto.getCollect())) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(BilibiliTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        BilibiliTopManInformation entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(entity.getTopmanId());
            topManCollectBean.setPlatform("4");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"4");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getTopmanId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(BilibiliTopManCollectDTO dto) {
        this.saveRedBookSpiderTopMan(dto.getEntity());
    }

    private void addMarkToMongo(BilibiliTopManCollectDTO dto) {
        BilibiliTopManInformation entity = dto.getEntity();
        String topManId = String.valueOf(entity.getTopmanId());
        MongoCollectionType collectMark = MongoCollectionType.TB_REDBOOK_ELS_TOPMAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", topManId);
        Map<String, TopManSpiderMark> data = this.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(topManId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(topManId);
            topManSpiderMark.setTaskType(dto.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)topManId));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private <T extends MongoEntityService> Map<String, T> handleMongo(MongoCollectionType collectionType, HashMap<String, String> param, Class<T> beanClass) {
        Document inquireDoc = new Document();
        for (Map.Entry<String, String> p : param.entrySet()) {
            inquireDoc.append(p.getKey(), (Object)p.getValue());
        }
        try (MongoCursor cursor = this.mongoTemplate.getCollection(collectionType.getCollectName()).find((Bson)inquireDoc).noCursorTimeout(true).cursor();){
            HashMap<String, MongoEntityService> map = new HashMap<String, MongoEntityService>(20);
            while (cursor.hasNext()) {
                Document coreData = (Document)cursor.next();
                String subKey = collectionType.getSubKey();
                if (subKey != null) {
                    List keyData = coreData.getList((Object)subKey, Document.class);
                    for (Document keyDatum : keyData) {
                        String s = keyDatum.toJson();
                        MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                        map.put(t.getKeyId(), t);
                    }
                    continue;
                }
                String s = coreData.toJson();
                MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                map.put(t.getKeyId(), t);
            }
            HashMap<String, MongoEntityService> hashMap = map;
            return hashMap;
        }
    }

    private void saveRedBookSpiderTopMan(BilibiliTopManInformation information) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(BilibiliTopManInformation::getTopmanId, (Object)information.getTopmanId());
        Integer integer = ((BilibiliTopManInformationMapper)this.baseMapper).selectCount((Wrapper)query);
        if (integer == 0) {
            information.setPlatform("4");
            information.setId("");
            ((BilibiliTopManInformationMapper)this.baseMapper).insert((Object)information);
        }
    }
}

