/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.industryinfo.dto.StoreHeadQueryDTO;
import com.els.modules.industryinfo.entity.StoreHead;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreHeadQueryParam {
    private static final Logger log = LoggerFactory.getLogger(StoreHeadQueryParam.class);

    public static QueryWrapper<StoreHead> getQueryParam(StoreHead head, Map<String, String[]> parameterMap, StoreHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String salesAmount;
        String videosNum;
        String topman;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), parameterMap);
        String experienceNum = queryDTO.getStoreExperienceNum();
        if (StringUtils.isNotBlank((CharSequence)experienceNum) && experienceNum.contains("-")) {
            String[] strings = experienceNum.split("-");
            queryWrapper.between((Object)"experience_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
        }
        if (StringUtils.isNotBlank((CharSequence)(topman = queryDTO.getStoreTopmanNum()))) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.between((Object)"topman_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                queryWrapper.gt((Object)"topman_num", (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.eq((Object)"topman_num", (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
            String[] strings;
            if (videosNum.contains("-")) {
                strings = videosNum.split("-");
                queryWrapper.between((Object)"videos_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (videosNum.contains(">")) {
                strings = videosNum.split(">");
                queryWrapper.gt((Object)"videos_num", (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
            String[] strings;
            if (salesAmount.contains("-")) {
                strings = salesAmount.split("-");
                queryWrapper.between((Object)"sales_amount_max", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (salesAmount.contains(">")) {
                strings = salesAmount.split(">");
                queryWrapper.gt((Object)"sales_amount_max", (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.gt((Object)"lives_num", (Object)BigDecimal.ZERO);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.gt((Object)"videos_num", (Object)BigDecimal.ZERO);
        }
        return queryWrapper;
    }

    public static StoreHeadQueryDTO getQueryParamExport(StoreHead head, Map<String, String[]> paramMap) {
        String[] storeExperienceNums = paramMap.get("storeExperienceNum");
        String[] storeTopmanNums = paramMap.get("storeTopmanNum");
        String[] storeVideosNums = paramMap.get("storeVideosNum");
        String[] storeSalesAmounts = paramMap.get("storeSalesAmount");
        String[] goodsLives = paramMap.get("goodsLive");
        String[] goodsVideos = paramMap.get("goodsVideo");
        String[] timeSelects = paramMap.get("timeSelect");
        StoreHeadQueryDTO queryDTO = new StoreHeadQueryDTO();
        if (storeExperienceNums != null && storeExperienceNums.length > 0) {
            String storeExperienceNum = storeExperienceNums[0];
            queryDTO.setStoreExperienceNum(storeExperienceNum);
        }
        if (storeTopmanNums != null && storeTopmanNums.length > 0) {
            String storeTopmanNum = storeTopmanNums[0];
            queryDTO.setStoreTopmanNum(storeTopmanNum);
        }
        if (storeVideosNums != null && storeVideosNums.length > 0) {
            String storeVideosNum = storeVideosNums[0];
            queryDTO.setStoreVideosNum(storeVideosNum);
        }
        if (storeSalesAmounts != null && storeSalesAmounts.length > 0) {
            String storeSalesAmount = storeSalesAmounts[0];
            queryDTO.setStoreSalesAmount(storeSalesAmount);
        }
        if (goodsLives != null && goodsLives.length > 0) {
            String goodsLive = goodsLives[0];
            queryDTO.setGoodsLive(Boolean.valueOf(goodsLive));
        }
        if (goodsVideos != null && goodsVideos.length > 0) {
            String goodsVideo = goodsVideos[0];
            queryDTO.setGoodsVideo(Boolean.valueOf(goodsVideo));
        }
        if (timeSelects != null && timeSelects.length > 0) {
            String timeSelect = timeSelects[0];
            queryDTO.setTimeSelect(timeSelect);
        }
        return queryDTO;
    }
}

