/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.excel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.els.common.excel.service.BaseExportService;
import com.els.modules.industryinfo.dto.TopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.query.TopmanRecordQueryParam;
import com.els.modules.industryinfo.service.GoodsTopmanRecordService;
import com.els.modules.industryinfo.vo.TopmanItemVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="goodsTopmanItemExportServiceImpl")
public class GoodsTopmanItemExportServiceImpl
extends BaseExportService<TopManInformationHead, TopmanItemVO, TopManInformationHead> {
    @Resource
    private GoodsTopmanRecordService goodsTopmanRecordService;

    public List<TopmanItemVO> queryExportData(QueryWrapper<TopManInformationHead> queryWrapper, TopManInformationHead param, Map<String, String[]> paramMap) {
        QueryWrapper<TopManInformationHead> goodsTopmanItemQueryWrapper;
        List<TopmanItemVO> records;
        String[] goodsIds = paramMap.get("goodsId");
        String[] topmanFansNums = paramMap.get("topmanFansNum");
        String[] topmanGoodsWoms = paramMap.get("topmanGoodsWom");
        String[] topmanPhoneNumbers = paramMap.get("topmanPhoneNumber");
        String[] topmanTimeSelects = paramMap.get("topmanTimeSelect");
        TopmanItemQueryDTO queryDTO = new TopmanItemQueryDTO();
        if (goodsIds != null && goodsIds.length > 0) {
            String goodsId = goodsIds[0];
            queryDTO.setGoodsId(goodsId);
        }
        if (topmanFansNums != null && topmanFansNums.length > 0) {
            String topmanFansNum = topmanFansNums[0];
            queryDTO.setTopmanFansNum(topmanFansNum);
        }
        if (topmanGoodsWoms != null && topmanGoodsWoms.length > 0) {
            String topmanGoodsWom = topmanGoodsWoms[0];
            queryDTO.setTopmanGoodsWom(topmanGoodsWom);
        }
        if (topmanPhoneNumbers != null && topmanPhoneNumbers.length > 0) {
            String topmanPhoneNumber = topmanPhoneNumbers[0];
            queryDTO.setTopmanPhoneNumber(Boolean.valueOf(topmanPhoneNumber));
        }
        if (topmanTimeSelects != null && topmanTimeSelects.length > 0) {
            String topmanTimeSelect = topmanTimeSelects[0];
            queryDTO.setTopmanTimeSelect(topmanTimeSelect);
        }
        if (CollectionUtils.isNotEmpty(records = this.goodsTopmanRecordService.queryTopmanList(goodsTopmanItemQueryWrapper = TopmanRecordQueryParam.getQueryParam(param, paramMap, queryDTO), queryDTO))) {
            for (TopmanItemVO vo : records) {
                if (vo.getSalesAmountMax() == null || vo.getPrice() == null || vo.getPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal salesNum = vo.getSalesAmountMax().divide(vo.getPrice(), 0, 4);
                vo.setSalesNum(salesNum);
            }
        }
        return records;
    }
}

