/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.utils;

import com.els.modules.industryinfo.utils.RedissonConfig;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={RLock.class})
@Import(value={RedissonConfig.class})
public class RedissonUtil {
    private static final Logger log = LoggerFactory.getLogger(RedissonUtil.class);
    @Autowired
    private RedissonClient redissonClient;

    public RLock lock(String key) {
        RLock lock = this.redissonClient.getLock(key);
        try {
            boolean result = lock.tryLock(0L, TimeUnit.SECONDS);
            return result ? lock : null;
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u9501\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public RLock lock(String key, Long time) {
        RLock lock = this.redissonClient.getLock(key);
        try {
            Assert.isTrue((time > 0L ? 1 : 0) != 0, (String)"\u9501\u5fc5\u987b\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4");
            boolean result = lock.tryLock(0L, time.longValue(), TimeUnit.SECONDS);
            return result ? lock : null;
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u9501\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public boolean lock(RLock lock, Long time) throws InterruptedException {
        return lock.tryLock(0L, time.longValue(), TimeUnit.SECONDS);
    }

    public void unLock(RLock lock) {
        try {
            if (null != lock && lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        catch (Exception e) {
            log.error("\u91ca\u653e\u9501\u5931\u8d25:" + lock.getName());
        }
    }
}

