/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.adapter.msg;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.common.constant.CommonConstant;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.adapter.msg.TopManMsgAdapter;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.service.KuaiShouTopManInformationService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.utils.spider.entity.KuaiShouIndexListPage;
import com.els.modules.industryinfo.utils.spider.entity.KuaiShouTopManInfo;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.properties.TopManMsgProperties;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.vo.KsTopManInformationVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"2"})
public class KuaiShouMsgAdapter
extends TopManMsgAdapter {
    private static final Logger log = LoggerFactory.getLogger(KuaiShouMsgAdapter.class);
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private KuaiShouTopManInformationService informationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;

    @Override
    public List<TopManMsgRecord> getSearchData(String filterInfoJson, TopManMsgTask topManMsgTask, int limitSize) {
        JSONObject jsonObject = JSON.parseObject((String)filterInfoJson);
        KsTopManInformationVO requestOptionVO = new KsTopManInformationVO();
        JSONObject f = jsonObject.getJSONObject("filterInfo");
        requestOptionVO.setTaskType(f.getString("taskType"));
        requestOptionVO.setPlatformType(f.getString("platformType"));
        JSONObject screen = f.getJSONObject("screenItem");
        KsTopManInformationVO.ScreenItem screenItem = new KsTopManInformationVO.ScreenItem();
        screen.keySet().forEach(key -> {
            JSONArray jsonArray = screen.getJSONArray(key);
            switch (key) {
                case "contentType": {
                    screenItem.setContentType(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "industry": {
                    screenItem.setIndustry(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "contentForm": {
                    screenItem.setContentForm(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "starRecommendation": {
                    screenItem.setStarRecommendation(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "talentInfo": {
                    screenItem.setTalentInfo(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "talentIndex": {
                    screenItem.setTalentIndex(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "fanInfo": {
                    screenItem.setFanInfo(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                    break;
                }
                case "contentPerformance": {
                    screenItem.setContentPerformance(jsonArray.toJavaList(KsTopManInformationVO.ScreenItemField.class));
                }
            }
        });
        String kw = f.getString("keyWord");
        if (CollUtil.isEmpty(screenItem.getContentType()) && CollUtil.isEmpty(screenItem.getIndustry()) && CollUtil.isEmpty(screenItem.getContentForm()) && CollUtil.isEmpty(screenItem.getStarRecommendation()) && CollUtil.isEmpty(screenItem.getTalentInfo()) && CollUtil.isEmpty(screenItem.getTalentIndex()) && CollUtil.isEmpty(screenItem.getFanInfo()) && CollUtil.isEmpty(screenItem.getContentPerformance()) && StrUtil.isBlank((CharSequence)kw)) {
            return Lists.newArrayList();
        }
        requestOptionVO.setScreenItem(screenItem);
        SimplePostRequestParam topManDto = new SimplePostRequestParam();
        topManDto.setFilterInfo((Object)requestOptionVO);
        topManDto.setKeyWord(kw);
        ArrayList records = Lists.newArrayList();
        records.addAll(this.handleListData(filterInfoJson, (SimplePostRequestParam<KsTopManInformationVO>)topManDto, topManMsgTask, limitSize));
        return records;
    }

    private List<TopManMsgRecord> handleListData(String filterInfoJson, SimplePostRequestParam<KsTopManInformationVO> topManDto, TopManMsgTask task, int limit) {
        ArrayList list = Lists.newArrayList();
        List oldTaskRecord = this.topManMsgRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)task.getId()));
        List oldTopManNames = oldTaskRecord.stream().map(x -> x.getTopmanName()).distinct().collect(Collectors.toList());
        int total = this.topManMsgProperties.getPageSize();
        int totalData = 0;
        int pageNo = 1;
        boolean endFlag = true;
        boolean first = true;
        long subTotal = 0L;
        while (endFlag) {
            topManDto.setPageNo(Integer.valueOf(pageNo));
            topManDto.setPageSize(Integer.valueOf(total));
            Map<?, ?> map = null;
            try {
                map = this.informationService.apiGetList(topManDto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SpiderMethodType kuaiShouIndexList = SpiderMethodType.KUAI_SHOU_INDEX_LIST;
            Class<KuaiShouIndexListPage> responseClass = KuaiShouIndexListPage.class;
            KuaiShouIndexListPage apiResult = this.spiderApiUtil.postForEntity(kuaiShouIndexList, map, responseClass);
            if (first) {
                subTotal = apiResult.getTotal();
                first = false;
            }
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getStarList()) && subTotal > 0L) {
                ++pageNo;
                for (KuaiShouTopManInfo apiData : apiResult.getStarList()) {
                    --subTotal;
                    if (totalData >= limit) {
                        return list;
                    }
                    if (oldTopManNames.contains(apiData.getName())) continue;
                    oldTopManNames.add(apiData.getName());
                    TopManMsgRecord topManMsgRecord = new TopManMsgRecord();
                    topManMsgRecord.setTaskId(task.getId());
                    topManMsgRecord.setPlatform(task.getPlatform());
                    topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
                    topManMsgRecord.setElsAccount(task.getElsAccount());
                    topManMsgRecord.setSubAccount(task.getSubAccount());
                    topManMsgRecord.setSubAdd("2");
                    topManMsgRecord.setSearchContext(filterInfoJson);
                    topManMsgRecord.setSendStatus("0");
                    topManMsgRecord.setReplyStatus("0");
                    topManMsgRecord.setSendCount(0);
                    topManMsgRecord.setReplyCount(0);
                    topManMsgRecord.setId(IdWorker.getIdStr());
                    topManMsgRecord.setTopmanId(apiData.getUserId().toString());
                    topManMsgRecord.setStarId(apiData.getStarId().toString());
                    topManMsgRecord.setLiveStatus(apiData.getLiveStatus().toString());
                    topManMsgRecord.setTopmanName(apiData.getName());
                    topManMsgRecord.setAvatar(apiData.getHeadUrl());
                    if (ObjectUtil.isNotEmpty((Object)apiData.getFansNum())) {
                        topManMsgRecord.setFansNum(apiData.getFansNum().toString());
                    }
                    list.add(topManMsgRecord);
                    ++totalData;
                }
                continue;
            }
            endFlag = false;
        }
        return list;
    }
}

