/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.job.utils.DataFormatUtils;
import com.els.modules.organ.entity.PurchaserOrganIndustryReleaseItem;
import com.els.modules.organ.entity.XhsPurchaserOrganHead;
import com.els.modules.organ.entity.XhsPurchaserOrganSignerTalent;
import com.els.modules.organ.service.PurchaserOrganIndustryReleaseItemService;
import com.els.modules.organ.service.XhsPurchaserOrganHeadService;
import com.els.modules.organ.service.XhsPurchaserOrganSignerTalentService;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class XhsMcnOrganizationJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(XhsMcnOrganizationJob.class);
    @Autowired
    private XhsPurchaserOrganHeadService xhsPurchaserOrganHeadService;
    @Autowired
    private XhsPurchaserOrganSignerTalentService xhsPurchaserOrganSignerTalentService;
    @Autowired
    private PurchaserOrganIndustryReleaseItemService purchaserOrganIndustryReleaseItemService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TB_XIAOHONGSHU_MCN_DATA = "tb_xiaohongshu_mcn_data";
    private final String TB_XIAOHONGSHU_MCN_DATA_BRAND_COOPERATION = "tb_xiaohongshu_mcn_data_brand_cooperation";
    private final String TB_XIAOHONGSHU_MCN_DATA_STORE_COMMERCE = "tb_xiaohongshu_mcn_data_store_commerce";
    private final int BATCH_SIZE = 5000;

    public void execute(String parameter) {
        log.info("------------start GoodsCategoryJob-----------");
        boolean i = false;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_xiaohongshu_mcn_data").find().noCursorTimeout(true).batchSize(5000).cursor();){
            ArrayList<XhsPurchaserOrganHead> entityList = new ArrayList<XhsPurchaserOrganHead>();
            log.info("------------start GoodsCategoryJob111111 -----------1");
            boolean nIndex = false;
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    XhsPurchaserOrganHead purchaserOrganHead = this.genOrganization(doc);
                    this.saveOrganSignerTalent(purchaserOrganHead.getId());
                    entityList.add(purchaserOrganHead);
                }
                catch (Exception e) {
                    log.error("GoodsCategoryJob error ", (Throwable)e);
                }
            }
            this.xhsPurchaserOrganHeadService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("GoodsCategoryJob error", (Throwable)e);
        }
    }

    private XhsPurchaserOrganHead genOrganization(Document doc) {
        XhsPurchaserOrganHead head = new XhsPurchaserOrganHead();
        head.setId(doc.getString((Object)"_id"));
        head.setElsAccount("100000");
        head.setPlatform("3");
        head.setLogo(doc.getString((Object)"bussiness_logo"));
        head.setOrganName(doc.getString((Object)"bussiness_name"));
        head.setRegion(doc.getString((Object)"region"));
        head.setOrganType("0");
        head.setAuthenEnterprise(doc.getString((Object)"company_name"));
        head.setSignerNum(DataFormatUtils.numberToBigDecimal(doc.getInteger((Object)"kol_count")));
        head.setFanNum(DataFormatUtils.numberToBigDecimal(doc.getInteger((Object)"kol_fans_count")));
        head.setNoteNum(DataFormatUtils.numberToBigDecimal(doc.getInteger((Object)"note_sum")));
        head.setLiveNum(DataFormatUtils.numberToBigDecimal(doc.getInteger((Object)"live_sum")));
        head.setXhsAccount(doc.getString((Object)"red_id"));
        head.setShortdescription(doc.getString((Object)"short_description"));
        head.setOrganCode(doc.getString((Object)"userId"));
        return head;
    }

    private void saveOrganSignerTalent(String headId) {
        XhsPurchaserOrganSignerTalent signerTalent;
        Document topman2;
        Throwable throwable;
        MongoCursor brandCursor;
        Document inquerDoc = new Document();
        inquerDoc.append("invite_id", (Object)headId);
        ArrayList<XhsPurchaserOrganSignerTalent> xhsPurchaserOrganSignerTalents = new ArrayList<XhsPurchaserOrganSignerTalent>();
        HashMap<String, PurchaserOrganIndustryReleaseItem> categoryMap = new HashMap<String, PurchaserOrganIndustryReleaseItem>();
        try {
            brandCursor = this.mongoTemplate.getCollection("tb_xiaohongshu_mcn_data_brand_cooperation").find((Bson)inquerDoc).noCursorTimeout(true).cursor();
            throwable = null;
            try {
                while (brandCursor.hasNext()) {
                    topman2 = (Document)brandCursor.next();
                    signerTalent = this.genOrganSingerTalent(topman2, headId);
                    this.saveCategory(headId, signerTalent.getTopmanCategoty(), categoryMap);
                    xhsPurchaserOrganSignerTalents.add(signerTalent);
                }
                System.out.println("bbbbbbbbbbbbbbb=" + categoryMap);
                ArrayList purchaserOrganIndustryReleaseItems = new ArrayList(categoryMap.values());
                this.purchaserOrganIndustryReleaseItemService.deleteByMainId(headId);
                this.purchaserOrganIndustryReleaseItemService.saveOrUpdateBatch(purchaserOrganIndustryReleaseItems);
            }
            catch (Throwable topman2) {
                throwable = topman2;
                throw topman2;
            }
            finally {
                if (brandCursor != null) {
                    if (throwable != null) {
                        try {
                            brandCursor.close();
                        }
                        catch (Throwable topman2) {
                            throwable.addSuppressed(topman2);
                        }
                    } else {
                        brandCursor.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("insertOrganTopMan error", (Throwable)e);
        }
        try {
            brandCursor = this.mongoTemplate.getCollection("tb_xiaohongshu_mcn_data_store_commerce").find((Bson)inquerDoc).noCursorTimeout(true).cursor();
            throwable = null;
            try {
                while (brandCursor.hasNext()) {
                    topman2 = (Document)brandCursor.next();
                    signerTalent = this.genOrganStoreCommerce(topman2, headId);
                    xhsPurchaserOrganSignerTalents.add(signerTalent);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (brandCursor != null) {
                    if (throwable != null) {
                        try {
                            brandCursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        brandCursor.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("insertOrganTopMan error", (Throwable)e);
        }
        this.xhsPurchaserOrganSignerTalentService.saveOrUpdateBatch(xhsPurchaserOrganSignerTalents);
    }

    private XhsPurchaserOrganSignerTalent genOrganSingerTalent(Document topman, String headId) {
        XhsPurchaserOrganSignerTalent signerTalent = new XhsPurchaserOrganSignerTalent();
        signerTalent.setId(topman.getString((Object)"_id"));
        signerTalent.setHeadId(topman.getString((Object)"invite_id"));
        signerTalent.setTopmanId(topman.getString((Object)"topman_id"));
        signerTalent.setTopmanName(topman.getString((Object)"topman_name"));
        signerTalent.setTopmanLogo(topman.getString((Object)"topman_logo"));
        signerTalent.setTopmanCategoty(this.getContentTags(topman, "topman_content_tags", "taxonomy1Tag"));
        signerTalent.setTopmanTags(this.getFeatureTags(topman.getList((Object)"topman_feature_tags", String.class)));
        signerTalent.setTopmanRegoin(topman.getString((Object)"topman_regoin"));
        signerTalent.setUserType("0");
        signerTalent.setFanNum(DataFormatUtils.numberToBigDecimal(topman.getInteger((Object)"fans_num")));
        signerTalent.setPraiseNum(DataFormatUtils.numberToBigDecimal(topman.getInteger((Object)"like_collect_count_info")));
        signerTalent.setBusinessNum(DataFormatUtils.numberToBigDecimal(topman.getInteger((Object)"business_note_count")));
        signerTalent.setPicturePrice(DataFormatUtils.numberToBigDecimal(topman.getDouble((Object)"topman_picture_price")));
        signerTalent.setVideoPrice(DataFormatUtils.numberToBigDecimal(topman.getDouble((Object)"topman_video_price")));
        return signerTalent;
    }

    private XhsPurchaserOrganSignerTalent genOrganStoreCommerce(Document topman, String headId) {
        XhsPurchaserOrganSignerTalent signerTalent = new XhsPurchaserOrganSignerTalent();
        signerTalent.setId(topman.getString((Object)"_id"));
        signerTalent.setHeadId(topman.getString((Object)"invite_id"));
        signerTalent.setTopmanName(topman.getString((Object)"topman_name"));
        signerTalent.setTopmanId(topman.getString((Object)"topman_id"));
        signerTalent.setTopmanLogo(topman.getString((Object)"topman_logo"));
        signerTalent.setTopmanCategoty(this.getContentTags(topman, "topman_content_tags", "level1Tag"));
        signerTalent.setTopmanRegoin(topman.getString((Object)"topman_regoin"));
        signerTalent.setUserType("1");
        signerTalent.setFanNum(DataFormatUtils.numberToBigDecimal(topman.getInteger((Object)"fans_num")));
        signerTalent.setRecentPlay(String.valueOf(topman.getInteger((Object)"channels_num")));
        signerTalent.setCustomerPrice(DataFormatUtils.numberToBigDecimal(topman.getDouble((Object)"price")));
        signerTalent.setSpecialPrice(topman.getString((Object)"specialPrice"));
        signerTalent.setMarketPrice(topman.getString((Object)"match_price"));
        return signerTalent;
    }

    private void saveCategory(String headId, String category, Map<String, PurchaserOrganIndustryReleaseItem> categoryMap) {
        if (category.contains(",")) {
            String[] split;
            for (String str : split = category.split(",")) {
                if (categoryMap.containsKey(str)) continue;
                PurchaserOrganIndustryReleaseItem purchaserOrganIndustryReleaseItem = new PurchaserOrganIndustryReleaseItem();
                purchaserOrganIndustryReleaseItem.setCategory(str);
                purchaserOrganIndustryReleaseItem.setPlatform("3");
                purchaserOrganIndustryReleaseItem.setHeadId(headId);
                categoryMap.put(str, purchaserOrganIndustryReleaseItem);
            }
        } else if (!categoryMap.containsKey(category) && StringUtils.isNotEmpty((CharSequence)category)) {
            PurchaserOrganIndustryReleaseItem purchaserOrganIndustryReleaseItem = new PurchaserOrganIndustryReleaseItem();
            purchaserOrganIndustryReleaseItem.setCategory(category);
            purchaserOrganIndustryReleaseItem.setPlatform("3");
            purchaserOrganIndustryReleaseItem.setHeadId(headId);
            categoryMap.put(category, purchaserOrganIndustryReleaseItem);
        }
    }

    private String getContentTags(Document topman, String category, String val) {
        StringBuffer sb = new StringBuffer();
        List tags = (List)topman.get((Object)category);
        System.out.println("ccccccccccccccccccccccccc=" + tags);
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            for (Map map : tags) {
                String str = (String)map.get(val);
                if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
                sb.append(str).append(",");
            }
            sb = sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    private String getFeatureTags(List<String> tags) {
        StringBuffer sb = new StringBuffer();
        if (CollectionUtils.isNotEmpty(tags)) {
            for (String str : tags) {
                sb.append(str).append(",");
            }
            sb = sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }
}

