/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.utils.TimeTranslateUtil;
import com.els.common.vo.CountVO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsDataItem;
import com.els.modules.industryinfo.entity.GoodsFavorite;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsItem;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsLiveRecord;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsTopmanRecord;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.entity.GoodsVideoRecord;
import com.els.modules.industryinfo.entity.StoreHead;
import com.els.modules.industryinfo.mapper.GoodsFavoriteMapper;
import com.els.modules.industryinfo.mapper.GoodsHeadMapper;
import com.els.modules.industryinfo.mapper.GoodsItemMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveItemMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveRecordMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanRecordMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoRecordMapper;
import com.els.modules.industryinfo.mapper.TopManLiveItemListMapper;
import com.els.modules.industryinfo.mapper.TopManVideoItemListMapper;
import com.els.modules.industryinfo.service.GoodsDataItemService;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.GoodsItemService;
import com.els.modules.industryinfo.service.StoreHeadService;
import com.els.modules.industryinfo.vo.GoodsHeadStatisticsVO;
import com.els.modules.industryinfo.vo.GoodsHeadVO;
import com.els.modules.industryinfo.vo.GoodsLiveRecordVO;
import com.els.modules.industryinfo.vo.GoodsVideoRecordVO;
import com.els.modules.industryinfo.vo.TabCountVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsHeadServiceImpl
extends BaseServiceImpl<GoodsHeadMapper, GoodsHead>
implements GoodsHeadService {
    @Autowired
    private GoodsHeadMapper goodsHeadMapper;
    @Autowired
    private GoodsItemService goodsItemService;
    @Autowired
    private GoodsDataItemService goodsDataItemService;
    @Autowired
    private StoreHeadService storeHeadService;
    @Autowired
    private GoodsItemMapper goodsItemMapper;
    @Autowired
    private GoodsTopmanItemMapper goodsTopmanItemMapper;
    @Autowired
    private GoodsTopmanRecordMapper goodsTopmanRecordMapper;
    @Autowired
    private GoodsVideoItemMapper goodsVideoItemMapper;
    @Autowired
    private GoodsVideoRecordMapper goodsVideoRecordMapper;
    @Autowired
    private GoodsLiveItemMapper goodsLiveItemMapper;
    @Autowired
    private GoodsLiveRecordMapper goodsLiveRecordMapper;
    @Autowired
    private GoodsFavoriteMapper goodsFavoriteMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TopManLiveItemListMapper topManLiveItemListMapper;
    @Autowired
    private TopManVideoItemListMapper topManVideoItemListMapper;

    @Override
    public IPage<GoodsHead> queryPage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        IPage<GoodsHead> goodsHeadPage = ((GoodsHeadMapper)this.baseMapper).goodsHeadPage(page, queryWrapper, queryDTO);
        this.replenish(goodsHeadPage.getRecords(), queryDTO);
        return goodsHeadPage;
    }

    @Override
    public List<GoodsHead> queryList(QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        this.categoryListConvert(queryDTO);
        List<GoodsHead> list = ((GoodsHeadMapper)this.baseMapper).goodsHeadList(queryWrapper, queryDTO);
        this.replenish(list, queryDTO);
        return list;
    }

    @Override
    public IPage<GoodsHead> queryFavoritePage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        String subAccount;
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<GoodsFavorite> goodsFavoriteList = this.goodsFavoriteMapper.selectByElsAccount(elsAccount, subAccount = loginUser.getSubAccount());
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List headIds = goodsFavoriteList.stream().map(GoodsFavorite::getHeadId).collect(Collectors.toList());
            queryWrapper.in((Object)"gh.id", headIds);
        } else {
            queryWrapper.eq((Object)"gh.id", null);
        }
        this.categoryListConvert(queryDTO);
        IPage<GoodsHead> goodsHeadPage = ((GoodsHeadMapper)this.baseMapper).goodsHeadPage(page, queryWrapper, queryDTO);
        this.replenish(goodsHeadPage.getRecords(), queryDTO);
        return goodsHeadPage;
    }

    @Override
    public GoodsHeadQueryDTO categoryConvert(GoodsHeadQueryDTO queryDTO) {
        String category = queryDTO.getGoodsCategory();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains(",")) {
                category = category.replace(",", "|");
            } else if (category.contains("\u5168\u90e8")) {
                category = "";
            }
            queryDTO.setGoodsCategory(category);
        }
        return queryDTO;
    }

    @Override
    public GoodsHeadQueryDTO categoryListConvert(GoodsHeadQueryDTO queryDTO) {
        String category = queryDTO.getGoodsCategory();
        ArrayList<String> categorys = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains(",")) {
                String[] strings;
                for (String string : strings = category.split(",")) {
                    String[] strs = string.split("-");
                    categorys.add(strs[2]);
                }
            } else if (category.contains("\u5168\u90e8")) {
                categorys.add("");
            } else {
                String[] strs = category.split("-");
                categorys.add(strs[2]);
            }
            String finalCategory = org.apache.commons.lang3.StringUtils.join(categorys, (String)"|");
            queryDTO.setGoodsCategory(finalCategory);
        }
        return queryDTO;
    }

    private List<GoodsHead> replenish(List<GoodsHead> list, GoodsHeadQueryDTO queryDTO) {
        if (!CollectionUtils.isEmpty(list)) {
            List<String> ids = list.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            LoginUser loginUser = SysUtil.getLoginUser();
            String elsAccount = loginUser.getElsAccount();
            String subAccount = loginUser.getSubAccount();
            List<GoodsFavorite> favorites = this.goodsFavoriteMapper.selectGoodsFavoriteList(ids, elsAccount, subAccount);
            Map<Object, Object> favoriteMap = new HashMap();
            if (CollectionUtil.isNotEmpty(favorites)) {
                favoriteMap = favorites.stream().collect(Collectors.toMap(GoodsFavorite::getHeadId, h -> h, (k1, k2) -> k1));
            }
            for (GoodsHead goodsHead : list) {
                GoodsFavorite goodsFavorite = (GoodsFavorite)((Object)favoriteMap.get(goodsHead.getId()));
                goodsHead.setFavoriteGoods(false);
                if (goodsFavorite == null) continue;
                goodsHead.setFavoriteGoods(true);
            }
        }
        return list;
    }

    @Deprecated
    private QueryWrapper<GoodsHead> criteriaQuery(QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        List<GoodsItem> goodsItems;
        String goodsRate;
        String goodsPrice = queryDTO.getGoodsPrice();
        if (StringUtils.isNotBlank((CharSequence)goodsPrice)) {
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[0]));
                queryWrapper.lambda().le(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                queryWrapper.lambda().lt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().gt(GoodsHead::getCommissionRate, (Object)split);
                queryWrapper.lambda().le(GoodsHead::getCommissionRate, (Object)split1);
            }
            if (goodsRate.contains(">=")) {
                strings = goodsRate.split(">=");
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().ge(GoodsHead::getCommissionRate, (Object)split1);
            }
        }
        if (CollectionUtil.isNotEmpty(goodsItems = this.goodsItemService.queryList(queryDTO))) {
            List ids = goodsItems.stream().map(GoodsItem::getGoodsId).distinct().collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, ids);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        return queryWrapper;
    }

    @Override
    public GoodsHeadStatisticsVO goodsStat(GoodsTopmanItemQueryDTO queryDTO) {
        GoodsDataItem item = this.goodsDataItemService.queryByGoodsDataItem(queryDTO.getGoodsId(), queryDTO.getTopmanTimeSelect());
        GoodsHeadStatisticsVO vo = new GoodsHeadStatisticsVO();
        if (item != null) {
            BeanUtil.copyProperties((Object)((Object)item), (Object)vo, (String[])new String[0]);
        }
        return vo;
    }

    @Override
    public IPage<GoodsHeadStatisticsVO> queryGoodsItemPage(Page<GoodsItem> page, QueryWrapper<GoodsItem> queryWrapper, GoodsTopmanItemQueryDTO queryDTO) {
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
        queryDTO.setStartTime(TimeTranslateUtil.dateToLineTime((Date)dates[0]));
        queryDTO.setEndTime(TimeTranslateUtil.dateToLineTime((Date)dates[1]));
        queryWrapper.lambda().ge(GoodsItem::getSaleDate, (Object)dates[0]);
        queryWrapper.lambda().lt(GoodsItem::getSaleDate, (Object)dates[1]);
        Page itemPage = (Page)this.goodsItemService.page((IPage)page, (Wrapper)queryWrapper);
        List<GoodsHeadStatisticsVO> voList = this.replenishNew(queryDTO, itemPage.getRecords());
        Page voPage = new Page();
        BeanUtil.copyProperties((Object)itemPage, (Object)voPage, (String[])new String[0]);
        voPage.setRecords(voList);
        return voPage;
    }

    @Override
    public List<GoodsHeadStatisticsVO> replenishNew(GoodsTopmanItemQueryDTO queryDTO, List<GoodsItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        GoodsHead goodsHead = this.selectByGoodsId(queryDTO.getGoodsId());
        List<GoodsLiveRecordVO> liveList = this.topManLiveItemListMapper.topManLiveItemList(queryDTO);
        List<GoodsVideoRecordVO> videoList = this.topManVideoItemListMapper.topManVideoItemList(queryDTO);
        ArrayList<GoodsHeadStatisticsVO> voList = new ArrayList<GoodsHeadStatisticsVO>();
        for (GoodsItem item : list) {
            long count;
            GoodsHeadStatisticsVO vo = new GoodsHeadStatisticsVO();
            vo.setStatisticTime(DateUtil.format((Date)item.getSaleDate(), (String)"yyyy-MM-dd"));
            vo.setSalesNum(item.getSalesNum());
            if (goodsHead != null) {
                vo.setSalesAmountMin(goodsHead.getPrice().multiply(item.getSalesNum()));
                vo.setSalesAmountMax(goodsHead.getPrice().multiply(item.getSalesNum()));
            }
            if (CollectionUtil.isNotEmpty(liveList)) {
                count = liveList.stream().filter(h -> vo.getStatisticTime().equals(DateUtil.format((Date)h.getLiveStartTime(), (String)"yyyy-MM-dd"))).count();
                vo.setLivesNum(new BigDecimal(count));
            }
            if (CollectionUtil.isNotEmpty(videoList)) {
                count = videoList.stream().filter(h -> vo.getStatisticTime().equals(DateUtil.format((Date)h.getVideoPublishTime(), (String)"yyyy-MM-dd"))).count();
                vo.setVideosNum(new BigDecimal(count));
            }
            vo.setBrowsesNum(item.getBrowsesNum());
            vo.setTopmanNum(item.getTopmanNum());
            vo.setQueryDay(item.getQueryDay());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public GoodsHead selectByGoodsId(String goodsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(GoodsHead::getGoodsId, (Object)goodsId);
        return (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public List<GoodsHead> selectByGoodsIds(List<String> goodsIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(GoodsHead::getGoodsId, goodsIds);
        return ((GoodsHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public GoodsHeadVO queryById(String id) {
        GoodsDataItem goodsItem;
        GoodsHeadVO goodsHeadVO = new GoodsHeadVO();
        GoodsHead goodsHead = (GoodsHead)((Object)this.getById((Serializable)((Object)id)));
        if (goodsHead == null) {
            return goodsHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsHeadVO));
        String timeSelect = "30";
        StoreHead storeHead = this.storeHeadService.queryByShopId(goodsHead.getShopId());
        if (storeHead != null) {
            goodsHeadVO.setStoreName(storeHead.getName());
        }
        if ((goodsItem = this.goodsItemService.queryGoodsItem(goodsHead.getGoodsId(), timeSelect)) != null) {
            goodsHeadVO.setSalesNum(goodsItem.getSalesNum());
            goodsHeadVO.setSalesAmountMin(goodsItem.getSalesAmountMin());
            goodsHeadVO.setSalesAmountMax(goodsItem.getSalesAmountMax());
            goodsHeadVO.setSalesNumLive(goodsItem.getSalesNumLive());
            goodsHeadVO.setSalesNumVideo(goodsItem.getSalesNumVideo());
            goodsHeadVO.setTopmanNum(goodsItem.getTopmanNum());
            goodsHeadVO.setLivesNum(goodsItem.getLivesNum());
            goodsHeadVO.setVideosNum(goodsItem.getVideosNum());
            goodsHeadVO.setBrowsesNum(goodsItem.getBrowsesNum());
            goodsHeadVO.setConvertRate(goodsItem.getConvertRate());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        GoodsFavorite goodsFavorite = this.goodsFavoriteMapper.selectGoodsFavorite(goodsHead.getId(), elsAccount, subAccount);
        goodsHeadVO.setFavoriteGoods(false);
        if (goodsFavorite != null) {
            goodsHeadVO.setFavoriteGoods(true);
        }
        return goodsHeadVO;
    }

    @Override
    public GoodsHeadVO queryByIdNew(String id) {
        GoodsHeadVO goodsHeadVO = new GoodsHeadVO();
        GoodsHead goodsHead = ((GoodsHeadMapper)this.baseMapper).queryById(id);
        if (goodsHead == null) {
            return goodsHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsHeadVO));
        GoodsHeadStatisticsVO vo = ((GoodsHeadMapper)this.baseMapper).selectGoodsInfo(goodsHead.getGoodsId(), "30d");
        if (vo != null) {
            goodsHeadVO.setSalesNumLive(vo.getSalesNumLive());
            goodsHeadVO.setSalesNumVideo(vo.getSalesNumVideo());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        GoodsFavorite goodsFavorite = this.goodsFavoriteMapper.selectGoodsFavorite(goodsHead.getId(), elsAccount, subAccount);
        goodsHeadVO.setFavoriteGoods(false);
        if (goodsFavorite != null) {
            goodsHeadVO.setFavoriteGoods(true);
        }
        return goodsHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.insert((Object)goodsHead);
        super.setHeadDefaultValue((BaseEntity)goodsHead);
        this.insertData(goodsHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.updateById((Object)goodsHead);
        this.goodsTopmanItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsVideoItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsLiveItemMapper.deleteByMainId(goodsHead.getId());
        this.insertData(goodsHead, headVO);
    }

    @Override
    public void favorite(String id) {
        GoodsHead goodsHead = (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        GoodsFavorite goodsFavorite = new GoodsFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        goodsFavorite.setElsAccount(elsAccount);
        goodsFavorite.setUserId(subAccount);
        goodsFavorite.setHeadId(goodsHead.getId());
        goodsFavorite.setPlatform(goodsHead.getPlatform());
        goodsFavorite.setFavoriteTime(new Date());
        this.goodsFavoriteMapper.insert((Object)goodsFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        this.goodsFavoriteMapper.deleteGoodsFavorite(id, elsAccount, subAccount);
    }

    private void insertData(GoodsHead goodsHead, GoodsHeadVO headVO) {
        List<GoodsTopmanRecord> records;
        List<GoodsItem> goodsItemList = headVO.getGoodsItemList();
        List<GoodsTopmanItem> goodsTopmanItemList = headVO.getGoodsTopmanItemList();
        List<GoodsTopmanRecord> goodsTopmanRecordList = headVO.getGoodsTopmanRecordList();
        List<GoodsVideoItem> goodsVideoItemList = headVO.getGoodsVideoItemList();
        List<GoodsVideoRecord> goodsVideoRecordList = headVO.getGoodsVideoRecordList();
        List<GoodsLiveItem> goodsLiveItemList = headVO.getGoodsLiveItemList();
        List<GoodsLiveRecord> goodsLiveRecordList = headVO.getGoodsLiveRecordList();
        if (!CollectionUtils.isEmpty(goodsItemList)) {
            for (GoodsItem goodsItem : goodsItemList) {
                goodsItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsItem, (BaseEntity)goodsHead);
            }
            if (!goodsItemList.isEmpty()) {
                this.goodsItemMapper.insertBatchSomeColumn(goodsItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsTopmanRecordList)) {
            for (GoodsTopmanRecord goodsTopmanRecord : goodsTopmanRecordList) {
                goodsTopmanRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsTopmanRecord, (BaseEntity)goodsHead);
            }
            if (!goodsTopmanRecordList.isEmpty()) {
                this.goodsTopmanRecordMapper.insertBatchSomeColumn(goodsTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.goodsTopmanRecordMapper.selectByMainId(goodsHead.getId()))) {
            for (GoodsTopmanRecord goodsTopmanRecord : records) {
                if (CollectionUtils.isEmpty(goodsTopmanItemList)) continue;
                for (GoodsTopmanItem entity2 : goodsTopmanItemList) {
                    entity2.setRecordId(goodsTopmanRecord.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)goodsHead);
                }
                if (goodsTopmanItemList.isEmpty()) continue;
                this.goodsTopmanItemMapper.insertBatchSomeColumn(goodsTopmanItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoItemList)) {
            for (GoodsVideoItem goodsVideoItem : goodsVideoItemList) {
                goodsVideoItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoItem, (BaseEntity)goodsHead);
            }
            if (!goodsVideoItemList.isEmpty()) {
                this.goodsVideoItemMapper.insertBatchSomeColumn(goodsVideoItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoRecordList)) {
            for (GoodsVideoRecord goodsVideoRecord : goodsVideoRecordList) {
                goodsVideoRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoRecord, (BaseEntity)goodsHead);
            }
            if (!goodsVideoRecordList.isEmpty()) {
                this.goodsVideoRecordMapper.insertBatchSomeColumn(goodsVideoRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveItemList)) {
            for (GoodsLiveItem goodsLiveItem : goodsLiveItemList) {
                goodsLiveItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveItem, (BaseEntity)goodsHead);
            }
            if (!goodsLiveItemList.isEmpty()) {
                this.goodsLiveItemMapper.insertBatchSomeColumn(goodsLiveItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveRecordList)) {
            for (GoodsLiveRecord goodsLiveRecord : goodsLiveRecordList) {
                goodsLiveRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveRecord, (BaseEntity)goodsHead);
            }
            if (!goodsLiveRecordList.isEmpty()) {
                this.goodsLiveRecordMapper.insertBatchSomeColumn(goodsLiveRecordList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.goodsTopmanItemMapper.deleteByMainId(id);
        this.goodsVideoItemMapper.deleteByMainId(id);
        this.goodsLiveItemMapper.deleteByMainId(id);
        this.goodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.goodsTopmanItemMapper.deleteByMainId(serializable.toString());
            this.goodsVideoItemMapper.deleteByMainId(serializable.toString());
            this.goodsLiveItemMapper.deleteByMainId(serializable.toString());
            this.goodsHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<CountVO> categoryCounts(GoodsHeadQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<TabCountVO> list = this.goodsHeadMapper.tabCountByShopId(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "goodsCategory", null, Integer.valueOf(list.size())));
        if (CollectionUtil.isNotEmpty(list)) {
            List types = list.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getType())).map(TabCountVO::getType).distinct().collect(Collectors.toList());
            LinkedHashSet<String> finalTypes = new LinkedHashSet<String>();
            for (String type : types) {
                if (type.contains("-")) {
                    String[] split = type.split("-");
                    finalTypes.addAll(Arrays.asList(split));
                    continue;
                }
                finalTypes.add(type);
            }
            for (String finalType : finalTypes) {
                long count = list.stream().filter(h -> h.getType().contains(finalType)).count();
                result.add(new CountVO(I18nUtil.translate((String)"", (String)finalType), "goodsCategory", finalType, Integer.valueOf((int)count)));
            }
        }
        return result;
    }
}

