/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationAlbumListEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationBasicAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationDetailsEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationFanAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationLatestTenVideoTrendsEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationLiveAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationPromotionAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationSpecialListEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationVideoListEntity;
import com.els.modules.industryinfo.enumerate.BStationOptionsType;
import com.els.modules.industryinfo.enumerate.BStationOptionsTypeGroup;
import com.els.modules.industryinfo.mapper.BStationTopManInformationMapper;
import com.els.modules.industryinfo.service.BStationTopManInformationService;
import com.els.modules.industryinfo.utils.HttpRequestUtils;
import com.els.modules.industryinfo.vo.BStationManInformationVO;
import com.els.modules.industryinfo.vo.BStationRequestParamVO;
import com.els.modules.industryinfo.weboption.OptionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BStationTopManInformationServiceImpl
implements BStationTopManInformationService {
    @Value(value="${bs.ipAddress}")
    private String ipAddress;
    @Autowired
    BStationTopManInformationMapper baseMapper;
    private static final Map<String, String> orderTag = new HashMap<String, String>(10);

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<BStationOptionsTypeGroup, BStationOptionsType> init = OptionFactory.init(BStationOptionsTypeGroup.class, BStationOptionsType.class);
        init.setCollection("tb_huahuo_category");
        switch (type) {
            case "videoTopMan": {
                init.when(BStationOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc, "videoTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.otherFilter, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan"));
                break;
            }
            case "liveTopMan": {
                init.when(BStationOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc, "liveTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "liveTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "liveTopMan"));
                break;
            }
            case "collectTopMan": {
                init.when(BStationOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc, "collectTopMan")).when(BStationOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc, "collectTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.otherFilter, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan"));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    @Override
    public IPage<BStationTopManInformationEntity> queryTopManList(SimplePostRequestParam<BStationManInformationVO> topManDto) throws Exception {
        IPage<BStationTopManInformationEntity> page = new IPage<BStationTopManInformationEntity>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        String param = BStationTopManInformationServiceImpl.apiGetList(taskType, topManDto);
        System.out.println("ipAddress:" + this.ipAddress);
        switch (taskType) {
            case "videoTopMan": {
                String urlVideo = this.ipAddress + "/bilibili/content/cooperation/api/list";
                JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, param);
                if (jsonObjectVideo == null) {
                    return page;
                }
                JSONArray dataVideo = jsonObjectVideo.getJSONArray("data");
                List bStationManInformationVOVideo = dataVideo.toJavaList(BStationTopManInformationEntity.class);
                page.setTotal((long)jsonObjectVideo.getInteger("total_count").intValue());
                this.handleResult(bStationManInformationVOVideo, filterInfo.getPlatformType());
                page.setRecords(bStationManInformationVOVideo);
                break;
            }
            case "liveTopMan": {
                String urlLive = this.ipAddress + "/bilibili/live/cooperation/api/telent_live_data/list";
                JSONObject jsonObjectLive = HttpRequestUtils.doPost(urlLive, param);
                if (jsonObjectLive == null) {
                    ArrayList bStationManInformationVOLive = new ArrayList();
                    page.setRecords(bStationManInformationVOLive);
                    return page;
                }
                JSONArray dataLive = jsonObjectLive.getJSONArray("data");
                List bStationManInformationVOLive = dataLive.toJavaList(BStationTopManInformationEntity.class);
                page.setTotal((long)jsonObjectLive.getInteger("total_count").intValue());
                this.handleResult(bStationManInformationVOLive, filterInfo.getPlatformType());
                page.setRecords(bStationManInformationVOLive);
                break;
            }
            case "collectTopMan": {
                QueryWrapper queryWrapper = new QueryWrapper();
                page = this.baseMapper.selectCollectTopMan(page, (Wrapper<BStationTopManInformationEntity>)queryWrapper, SysUtil.getLoginUser(), "", "");
                break;
            }
            default: {
                throw new ELSBootException("\u8be5\u8bf7\u6c42\u4e0d\u5408\u6cd5");
            }
        }
        return page;
    }

    @Override
    public BStationTopManInformationDetailsEntity bStationTopManDetails(String bStationId, String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upper_mid", bStationId);
        param.put("mcn_id", topmanId);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/video/analysis/details";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            return new BStationTopManInformationDetailsEntity();
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List topManInfos = data.toJavaList(BStationTopManInformationDetailsEntity.TopManInfo.class);
        List topManVideoData = data.toJavaList(BStationTopManInformationDetailsEntity.TopManVideoData.class);
        List topManLiveData = data.toJavaList(BStationTopManInformationDetailsEntity.TopManLiveData.class);
        List topManCoreData = data.toJavaList(BStationTopManInformationDetailsEntity.TopManCoreData.class);
        BStationTopManInformationDetailsEntity bStationTopManInformationDetails = new BStationTopManInformationDetailsEntity();
        bStationTopManInformationDetails.setTopManInfo((BStationTopManInformationDetailsEntity.TopManInfo)topManInfos.get(0));
        bStationTopManInformationDetails.setTopManCoreData((BStationTopManInformationDetailsEntity.TopManCoreData)topManCoreData.get(0));
        bStationTopManInformationDetails.setTopManLiveData((BStationTopManInformationDetailsEntity.TopManLiveData)topManLiveData.get(0));
        bStationTopManInformationDetails.setTopManVideoData((BStationTopManInformationDetailsEntity.TopManVideoData)topManVideoData.get(0));
        List<String> ids = Arrays.asList(((BStationTopManInformationDetailsEntity.TopManInfo)topManInfos.get(0)).getTopmanId());
        List<BStationTopManInformationEntity> bStationTopManInformationEntities = this.baseMapper.checkAddedAndCollect(ids, SysUtil.getLoginUser(), "4");
        if (CollectionUtils.isNotEmpty(bStationTopManInformationEntities)) {
            bStationTopManInformationDetails.setIsAdded(bStationTopManInformationEntities.get(0).getIsAdded());
            bStationTopManInformationDetails.setIsCollection(bStationTopManInformationEntities.get(0).getIsCollection());
        }
        return bStationTopManInformationDetails;
    }

    @Override
    public IPage<BStationTopManInformationBasicAnalysisEntity> bStationTopManFanBasicAnalysisList(String bStationId, String fanCode, int pageNO) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("upper_mid", bStationId);
        if (StringUtils.isNotEmpty((CharSequence)fanCode)) {
            param.put("fans_range", fanCode);
        }
        param.put("page", pageNO);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/similar/fan/telent/list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            Page page = new Page();
            return page;
        }
        JSONArray dataVideo = jsonObject.getJSONArray("data");
        List bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManInformationBasicAnalysisEntity.class);
        Integer current = jsonObject.getInteger("page");
        Integer total = jsonObject.getInteger("total");
        Page page = new Page((long)current.intValue(), 9L, (long)total.intValue());
        page.setRecords(bStationTopManInformationBasicAnalysisEntities);
        return page;
    }

    @Override
    public List<BStationTopManInformationBasicAnalysisEntity.Screen> bStationTopManFanBasicAnalysisCategory() {
        HashMap param = new HashMap();
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/similar/fan/telent/category";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            ArrayList<BStationTopManInformationBasicAnalysisEntity.Screen> bStationTopManInformationBasicAnalysisEntities = new ArrayList<BStationTopManInformationBasicAnalysisEntity.Screen>();
            return bStationTopManInformationBasicAnalysisEntities;
        }
        JSONArray dataVideo = jsonObject.getJSONArray("data");
        List bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManInformationBasicAnalysisEntity.Screen.class);
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public List<BStationTopManInformationBasicAnalysisEntity> bStationTopManContentBasicAnalysisList(String bStationId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upper_mid", bStationId);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/similar/content/telent/list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            ArrayList<BStationTopManInformationBasicAnalysisEntity> bStationTopManInformationBasicAnalysisEntities = new ArrayList<BStationTopManInformationBasicAnalysisEntity>();
            return bStationTopManInformationBasicAnalysisEntities;
        }
        JSONArray dataVideo = jsonObject.getJSONArray("data");
        List bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManInformationBasicAnalysisEntity.class);
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public BStationTopManInformationFanAnalysisEntity bStationTopManFanAnalysisDetails(String bStationId, String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upper_mid", bStationId);
        param.put("mcn_id", topmanId);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/fan_analysis/details";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            BStationTopManInformationFanAnalysisEntity bStationTopManInformationBasicAnalysisEntities = new BStationTopManInformationFanAnalysisEntity();
            return bStationTopManInformationBasicAnalysisEntities;
        }
        JSONArray fanIncrementTrends = jsonObject.getJSONArray("fanIncrementTrends");
        List fanIncrements = fanIncrementTrends.toJavaList(BStationTopManInformationFanAnalysisEntity.FanTrend.class);
        JSONArray fanTotalTrends = jsonObject.getJSONArray("fanTotalTrends");
        List fanTotals = fanTotalTrends.toJavaList(BStationTopManInformationFanAnalysisEntity.FanTrend.class);
        JSONArray genderDistributions = jsonObject.getJSONArray("genderDistributions");
        List genders = genderDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.GenderDistribution.class);
        JSONArray ageDistributions = jsonObject.getJSONArray("ageDistributions");
        List ages = ageDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.AgeDistribution.class);
        JSONArray equipmentDistributions = jsonObject.getJSONArray("equipmentDistributions");
        List equipments = equipmentDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.EquipmentDistribution.class);
        JSONArray regionDistributions = jsonObject.getJSONArray("regionDistributions");
        List regions = regionDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.RegionDistribution.class);
        JSONArray genderMost = jsonObject.getJSONArray("genderMost");
        List genderMosts = genderMost.toJavaList(String.class);
        JSONArray regionMost = jsonObject.getJSONArray("regionMost");
        List regionMosts = regionMost.toJavaList(String.class);
        BStationTopManInformationFanAnalysisEntity bStationTopManInformationFanAnalysis = new BStationTopManInformationFanAnalysisEntity();
        bStationTopManInformationFanAnalysis.setFanTotalTrends(fanTotals);
        bStationTopManInformationFanAnalysis.setFanIncrementTrends(fanIncrements);
        bStationTopManInformationFanAnalysis.setAgeDistributions(ages);
        bStationTopManInformationFanAnalysis.setEquipmentDistributions(equipments);
        bStationTopManInformationFanAnalysis.setGenderDistributions(genders);
        bStationTopManInformationFanAnalysis.setRegionDistributions(regions);
        bStationTopManInformationFanAnalysis.setGenderMost(genderMosts);
        bStationTopManInformationFanAnalysis.setRegionMost(regionMosts);
        return bStationTopManInformationFanAnalysis;
    }

    @Override
    public List<BStationTopManInformationPromotionAnalysisEntity> bStationTopManPromotionAnalysisDetails(String bStationId, String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upper_mid", bStationId);
        param.put("mcn_id", topmanId);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/promotion_analysis/details";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            ArrayList<BStationTopManInformationPromotionAnalysisEntity> bStationTopManInformationPromotionAnalysisEntities = new ArrayList<BStationTopManInformationPromotionAnalysisEntity>();
            return bStationTopManInformationPromotionAnalysisEntities;
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List bStationTopManInformationPromotionAnalysisEntities = data.toJavaList(BStationTopManInformationPromotionAnalysisEntity.class);
        return bStationTopManInformationPromotionAnalysisEntities;
    }

    @Override
    public List<BStationTopManInformationLatestTenVideoTrendsEntity> bStationTopManLatestTenVideoTrends(String bStationId, String type) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upper_mid", bStationId);
        param.put("trend_type", type);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/latest_10_video_trends/details";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            ArrayList<BStationTopManInformationLatestTenVideoTrendsEntity> latestTenVideoTrendsEntities = new ArrayList<BStationTopManInformationLatestTenVideoTrendsEntity>();
            return latestTenVideoTrendsEntities;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List latestTenVideoTrendsEntities = jsonArray.toJavaList(BStationTopManInformationLatestTenVideoTrendsEntity.class);
        return latestTenVideoTrendsEntities;
    }

    @Override
    public BStationTopManInformationLiveAnalysisEntity bStationTopManLiveAnalysis(String bStationId, String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upper_mid", bStationId);
        param.put("mcn_id", topmanId);
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/live/cooperation/api/telent_live_analysis/details";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            BStationTopManInformationLiveAnalysisEntity bStationTopManInformationLiveAnalysisEntity = new BStationTopManInformationLiveAnalysisEntity();
            return bStationTopManInformationLiveAnalysisEntity;
        }
        BStationTopManInformationLiveAnalysisEntity bStationTopManInformationLiveAnalysisEntity = (BStationTopManInformationLiveAnalysisEntity)jsonObject.toJavaObject(BStationTopManInformationLiveAnalysisEntity.class);
        return bStationTopManInformationLiveAnalysisEntity;
    }

    @Override
    public BStationTopManInformationVideoListEntity bStationTopManVideoList(String bStationId, String categoryId, String page, String keyword) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("mid", bStationId);
        param.put("tid", categoryId);
        param.put("pn", page);
        param.put("ps", "30");
        param.put("keyword", keyword);
        param.put("order", "pubdate");
        param.put("jsonp", "jsonp");
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/work/api/work_analysis_video/video_list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            BStationTopManInformationVideoListEntity bStationTopManInformationLiveAnalysisEntity = new BStationTopManInformationVideoListEntity();
            return bStationTopManInformationLiveAnalysisEntity;
        }
        JSONArray video = jsonObject.getJSONArray("video");
        List videoLists = video.toJavaList(BStationTopManInformationVideoListEntity.VideoList.class);
        JSONArray catgory = jsonObject.getJSONArray("catgory");
        List videoCategories = catgory.toJavaList(BStationTopManInformationVideoListEntity.VideoCategory.class);
        Collections.sort(videoCategories);
        BStationTopManInformationVideoListEntity videoListEntity = new BStationTopManInformationVideoListEntity();
        videoListEntity.setVideo(videoLists);
        videoListEntity.setCategory(videoCategories);
        videoListEntity.setCurrent(jsonObject.getInteger("current"));
        videoListEntity.setSize(jsonObject.getInteger("size"));
        videoListEntity.setTotal(jsonObject.getInteger("total"));
        return videoListEntity;
    }

    @Override
    public IPage<BStationTopManInformationSpecialListEntity> bStationTopManSpecialList(String bStationId, String pageNo) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("mid", bStationId);
        param.put("pn", pageNo);
        param.put("ps", "12");
        param.put("sort", "publish_time");
        param.put("callback", "__jp3");
        param.put("jsonp", "jsonp");
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/work/api/work_analysis_special/special_list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null || jsonObject.getString("msg").equals("fail")) {
            Page page = new Page();
            return page;
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List bStationTopManInformationSpecialListEntities = data.toJavaList(BStationTopManInformationSpecialListEntity.class);
        Page page = new Page((long)jsonObject.getInteger("current").intValue(), (long)jsonObject.getInteger("size").intValue(), (long)jsonObject.getInteger("total").intValue());
        page.setRecords(bStationTopManInformationSpecialListEntities);
        return page;
    }

    @Override
    public IPage<BStationTopManInformationAlbumListEntity> bStationTopManAlbumList(String bStationId, String pageNo) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", bStationId);
        param.put("page_num", pageNo);
        param.put("page_size", "30");
        param.put("biz", "all");
        param.put("jsonp", "jsonp");
        String string = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/bilibili/work/api/work_analysis_album/album_list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        if (jsonObject == null) {
            Page page = new Page();
            return page;
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List bStationTopManInformationAlbumListEntities = data.toJavaList(BStationTopManInformationAlbumListEntity.class);
        Page page = new Page();
        page.setSize((long)jsonObject.getInteger("size").intValue());
        page.setTotal((long)jsonObject.getInteger("total").intValue());
        page.setRecords(bStationTopManInformationAlbumListEntities);
        return page;
    }

    private static String apiGetList(String taskType, SimplePostRequestParam<BStationManInformationVO> topManDto) throws Exception {
        BStationManInformationVO.ScreenItem screenItem;
        String column = topManDto.getColumn();
        String order = topManDto.getOrder();
        BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
        BStationRequestParamVO.Content ksSpiderApiIndexListVo = BStationTopManInformationServiceImpl.getRequestContent(taskType, topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            ksSpiderApiIndexListVo.setNickname_or_mid(keyWord);
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<BStationManInformationVO.ScreenItemField> otherFilter;
            List<BStationManInformationVO.ScreenItemField> putInfo;
            List<BStationManInformationVO.ScreenItemField> fansPortrait;
            List<BStationManInformationVO.ScreenItemField> talentInfo;
            List<BStationManInformationVO.ScreenItemField> liveType;
            List<BStationManInformationVO.ScreenItemField> commercialOrderType = screenItem.getCommercialOrderType();
            if (CollectionUtils.isNotEmpty(commercialOrderType)) {
                ksSpiderApiIndexListVo.setCommercial_tag_id(commercialOrderType.get(0).getValue());
            }
            if (CollectionUtils.isNotEmpty(liveType = screenItem.getLiveType())) {
                ksSpiderApiIndexListVo.setArea_id(liveType.get(0).getValue());
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u4eba\u8bbe\u6807\u7b7e": {
                            if (taskType.equals("videoTopMan")) {
                                ksSpiderApiIndexListVo.setCharacter_tag_id(a.getValue());
                                break;
                            }
                            ksSpiderApiIndexListVo.setLive_parent_tag(a.getValue());
                            break;
                        }
                        case "\u65e5\u5e38\u804c\u4e1a": {
                            ksSpiderApiIndexListVo.setOccupation_tag_id(a.getValue());
                            break;
                        }
                        case "\u7c89\u4e1d\u603b\u6570": {
                            BStationTopManInformationServiceImpl.getParam(a.getValue(), a.getTitle(), ksSpiderApiIndexListVo);
                            break;
                        }
                        case "\u8fbe\u4eba\u6027\u522b": {
                            ksSpiderApiIndexListVo.setGender(a.getValue());
                            break;
                        }
                        case "\u8fbe\u4eba\u5730\u57df": {
                            BStationTopManInformationServiceImpl.getRegion(a.getValue(), ksSpiderApiIndexListVo);
                            break;
                        }
                        case "\u662f\u5426\u7b7e\u7ea6": {
                            ksSpiderApiIndexListVo.setOnly_contract(a.getValue());
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(fansPortrait = screenItem.getFansPortrait())) {
                fansPortrait.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u7c89\u4e1d\u6027\u522b": {
                            ksSpiderApiIndexListVo.setFans_gender_tag(a.getValue());
                            break;
                        }
                        case "\u7c89\u4e1d\u5e74\u9f84": {
                            ksSpiderApiIndexListVo.setFans_age_tag(a.getValue());
                            break;
                        }
                        case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                            ksSpiderApiIndexListVo.setFans_region_tag(a.getValue());
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(putInfo = screenItem.getPutInfo())) {
                putInfo.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7": {
                            BStationTopManInformationServiceImpl.getParam(a.getValue(), a.getTitle(), ksSpiderApiIndexListVo);
                            break;
                        }
                        case "\u5408\u4f5c\u7c7b\u578b": {
                            ksSpiderApiIndexListVo.setCooperation_types(a.getValue());
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherFilter = screenItem.getOtherFilter())) {
                StringBuilder sb = new StringBuilder();
                for (BStationManInformationVO.ScreenItemField a2 : otherFilter) {
                    if (a2.getTitle().equals("\u8fd1\u671f\u5165\u9a7b")) {
                        BStationTopManInformationServiceImpl.getRecentlySettled(a2.getValue(), ksSpiderApiIndexListVo);
                    }
                    if (!a2.getTitle().equals("\u5408\u4f5c\u4e30\u5bcc") && !a2.getTitle().equals("\u7c89\u4e1d\u98d9\u5347") && !a2.getTitle().equals("\u591a\u6b21\u70ed\u95e8")) continue;
                    sb = sb.append(a2.getValue()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    sb = sb.delete(sb.length() - 1, sb.length());
                }
                ksSpiderApiIndexListVo.setSpark_tag(sb.toString());
            }
        }
        String json = JSON.toJSONString((Object)ksSpiderApiIndexListVo);
        System.out.println("bbbbbbbbbbbbb=" + json);
        return json;
    }

    public static BStationRequestParamVO.Content getRequestContent(String taskType, SimplePostRequestParam<BStationManInformationVO> topManDto) {
        BStationRequestParamVO.Content ksSpiderApiIndexListVo = new BStationRequestParamVO.Content();
        if (taskType.equals("liveTopMan")) {
            ksSpiderApiIndexListVo.setPage(topManDto.getPageNo());
            ksSpiderApiIndexListVo.setSize(topManDto.getPageSize());
            ksSpiderApiIndexListVo.setSort("desc");
            ksSpiderApiIndexListVo.setOrder_by("fans_num");
            ksSpiderApiIndexListVo.setIs_live("true");
            ksSpiderApiIndexListVo.setLive_parent_tag("");
            ksSpiderApiIndexListVo.setArea_id("");
            ksSpiderApiIndexListVo.setParent_area_id("");
        } else {
            ksSpiderApiIndexListVo.setPage(topManDto.getPageNo());
            ksSpiderApiIndexListVo.setSize(topManDto.getPageSize());
            ksSpiderApiIndexListVo.setSort("");
            ksSpiderApiIndexListVo.setOrder_by("");
            ksSpiderApiIndexListVo.setOnly_potential_upper("0");
            ksSpiderApiIndexListVo.setOccupation_tag_id("");
            ksSpiderApiIndexListVo.setCharacter_tag_id("");
            ksSpiderApiIndexListVo.setMin_task_price("");
            ksSpiderApiIndexListVo.setMax_task_price("");
            ksSpiderApiIndexListVo.setProvider_id("");
            ksSpiderApiIndexListVo.setSpark_tag("");
            ksSpiderApiIndexListVo.setCommercial_tag_id("");
            ksSpiderApiIndexListVo.setUpper_mid("");
            ksSpiderApiIndexListVo.setOnly_contract("0");
            ksSpiderApiIndexListVo.setGoods_permission("0");
            ksSpiderApiIndexListVo.setCooperation_types("");
            ksSpiderApiIndexListVo.setUse_dynamic_score("true");
            ksSpiderApiIndexListVo.setLast_7_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_7_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_14_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_30_days_set_price("0");
            ksSpiderApiIndexListVo.setHas_condition("1");
            if (taskType.equals("collectTopMan")) {
                ksSpiderApiIndexListVo.setArea_id("");
            }
        }
        ksSpiderApiIndexListVo.setFans_region_tag("");
        ksSpiderApiIndexListVo.setFans_age_tag("");
        ksSpiderApiIndexListVo.setFans_gender_tag("");
        ksSpiderApiIndexListVo.setMax_fans_num("");
        ksSpiderApiIndexListVo.setMin_fans_num("");
        ksSpiderApiIndexListVo.setSecond_region_id("");
        ksSpiderApiIndexListVo.setRegion_id("");
        ksSpiderApiIndexListVo.setGender("");
        ksSpiderApiIndexListVo.setNickname_or_mid("");
        return ksSpiderApiIndexListVo;
    }

    public static void getRecentlySettled(String str, BStationRequestParamVO.Content ksSpiderApiIndexListVo) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            switch (str) {
                case "\u8fd17\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_7_days_set_price("1");
                    break;
                }
                case "\u8fd114\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_14_days_set_price("1");
                    break;
                }
                case "\u8fd130\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_30_days_set_price("1");
                    break;
                }
                default: {
                    new ELSBootException("\u627e\u4e0d\u5230\u6539\u7c7b\u578b\u7b5b\u9009\u6761\u4ef6");
                }
            }
        }
    }

    public static void getRegion(String str, BStationRequestParamVO.Content ksSpiderApiIndexListVo) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            if (str.endsWith("-")) {
                String[] split = str.split("-");
                ksSpiderApiIndexListVo.setRegion_id(split[0]);
            } else {
                String[] split = str.split("-");
                ksSpiderApiIndexListVo.setRegion_id(split[0]);
                ksSpiderApiIndexListVo.setSecond_region_id(split[1]);
            }
        }
    }

    public static void getParam(String str, String type, BStationRequestParamVO.Content ksSpiderApiIndexListVo) {
        String[] split;
        if (type.equals("\u7c89\u4e1d\u603b\u6570")) {
            if (str.startsWith("-")) {
                split = str.split("-");
                ksSpiderApiIndexListVo.setMax_fans_num(split[1]);
            } else if (str.endsWith("-")) {
                split = str.split("-");
                ksSpiderApiIndexListVo.setMin_fans_num(split[0]);
            } else {
                split = str.split("-");
                ksSpiderApiIndexListVo.setMin_fans_num(split[0]);
                ksSpiderApiIndexListVo.setMax_fans_num(split[1]);
            }
        }
        if (type.equals("\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7")) {
            if (str.startsWith("-")) {
                split = str.split("-");
                ksSpiderApiIndexListVo.setMax_task_price(split[1]);
            } else if (str.endsWith("-")) {
                split = str.split("-");
                ksSpiderApiIndexListVo.setMin_task_price(split[0]);
            } else {
                split = str.split("-");
                ksSpiderApiIndexListVo.setMin_task_price(split[0]);
                ksSpiderApiIndexListVo.setMax_task_price(split[1]);
            }
        }
    }

    private void handleResult(List<BStationTopManInformationEntity> data, String platform) {
        List<String> topmanIds = data.stream().map(BStationTopManInformationEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<BStationTopManInformationEntity> addedAndCollects = this.baseMapper.checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(BStationTopManInformationEntity::getTopmanId, h -> h, (k1, k2) -> k1));
        }
        ArrayList resultEntityList = new ArrayList(data.size());
        for (BStationTopManInformationEntity topManInfo : data) {
            if (!map.containsKey(topManInfo.getTopmanId())) continue;
            BStationTopManInformationEntity info = (BStationTopManInformationEntity)map.get(topManInfo.getTopmanId());
            topManInfo.setIsCollection(info.getIsCollection());
            topManInfo.setIsAdded(info.getIsAdded());
        }
    }

    private List<TopManOptionsEntity.Tag> transferTopManCommercial(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getParam((Document)h, type));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document, String type) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (children.size() > 0) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (children1.size() < 0) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                System.out.println(children1.getClass().getName());
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferLiveTopMan(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"name").toString());
            tag.setValue(h.get((Object)"id").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getLiveParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getLiveParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"list", Map.class);
        children.forEach(a -> {
            TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
            tagCopy.setId(a.get("id").toString());
            tagCopy.setLabel(a.get("name").toString());
            tagCopy.setValue(a.get("id").toString());
            tagCopyList.add(tagCopy);
        });
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferFansPortrait(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> this.transferSub((Document)h, type, h.get((Object)"label").toString())).collect(Collectors.toList());
    }

    private TopManOptionsEntity.Tag transferSub(Document doc, String type, String label) {
        TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
        tag.setId(doc.get((Object)"id").toString());
        tag.setLabel(doc.getString((Object)"label"));
        tag.setValue(doc.get((Object)"value").toString());
        if (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a")) {
            tag.setComponentType("RMultipleChoice");
        } else if (label.equals("\u8fbe\u4eba\u6027\u522b") || label.equals("\u7c89\u4e1d\u6027\u522b") || label.equals("\u7c89\u4e1d\u5e74\u9f84") || label.equals("\u5408\u4f5c\u7c7b\u578b") || label.equals("\u8fd1\u671f\u5165\u9a7b") || label.equals("\u7c89\u4e1d\u57ce\u5e02\u7ebf")) {
            tag.setComponentType("RSelect");
        } else if (label.equals("\u662f\u5426\u7b7e\u7ea6") || label.equals("\u5408\u4f5c\u4e30\u5bcc") || label.equals("\u7c89\u4e1d\u98d9\u5347") || label.equals("\u591a\u6b21\u70ed\u95e8") || label.equals("\u5b9d\u85cf\u8fbe\u4eba")) {
            tag.setComponentType("RCheckbox");
        } else if (label.equals("\u7c89\u4e1d\u603b\u6570") || label.equals("\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7")) {
            tag.setComponentType("RCustomSelect");
        } else if (label.equals("\u8fbe\u4eba\u5730\u57df")) {
            tag.setComponentType("RCascader");
        }
        if (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u8fbe\u4eba\u5730\u57df")) {
            ArrayList tagCopyList = new ArrayList();
            List children = doc.getList((Object)"children", Map.class);
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (children1.size() < 0) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
            tag.setChildren(tagCopyList);
        } else {
            tag.setChildren(doc.getList((Object)"children", Object.class));
        }
        if ((type.equals("videoTopMan") || type.equals("collectTopMan")) && label.equals("\u76f4\u64ad\u6807\u7b7e")) {
            return null;
        }
        return tag;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", "10462362");
        param.put("page_num", "0");
        param.put("page_size", "30");
        param.put("biz", "all");
        param.put("jsonp", "jsonp");
        String string = JSON.toJSONString(param);
        String urlDetails = "http://192.168.20.62:8088/bilibili/work/api/work_analysis_album/album_list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        JSONArray data = jsonObject.getJSONArray("data");
        List bStationTopManInformationAlbumListEntities = data.toJavaList(BStationTopManInformationAlbumListEntity.class);
        System.out.println(bStationTopManInformationAlbumListEntities);
    }
}

