/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.weboption;

import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.industryinfo.weboption.OptionTypeInterface;
import com.els.modules.industryinfo.weboption.TypeGroupInterface;
import com.els.modules.industryinfo.weboption.function.DocHandler;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

public class OptionFactory {
    private static final Logger log = LogManager.getLogger(OptionFactory.class);
    private static MongoTemplate mongoTemplate;
    private static RedisUtil redisUtil;

    public static <GT extends TypeGroupInterface<GT, T>, T extends OptionTypeInterface> OptionHandler<GT, T> init(Class<GT> typeGroup, Class<T> type) {
        return new OptionHandler(typeGroup, type);
    }

    @Component
    public static class MongoRegister {
        @Resource
        private MongoTemplate mongoTemplate;
        @Resource
        private RedisUtil redisUtil;

        @PostConstruct
        public void registerMongo() {
            mongoTemplate = this.mongoTemplate;
            redisUtil = this.redisUtil;
        }
    }

    public static class OptionHandler<GT extends TypeGroupInterface<GT, T>, T extends OptionTypeInterface> {
        private String collection;
        private final Class<GT> typeGroup;
        private final Class<T> optionType;
        private String mongoKey = "name";
        private boolean arealyWhen = false;
        private final Map<T, DocHandler> typeH = new HashMap<T, DocHandler>(10);

        public OptionHandler<GT, T> setCollection(@NonNull String collection) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            this.collection = collection;
            return this;
        }

        private OptionHandler(@NonNull Class<GT> typeGroup, @NonNull Class<T> optionType) {
            if (typeGroup == null) {
                throw new NullPointerException("typeGroup is marked non-null but is null");
            }
            if (optionType == null) {
                throw new NullPointerException("optionType is marked non-null but is null");
            }
            this.typeGroup = typeGroup;
            this.optionType = optionType;
        }

        public OptionHandler<GT, T> when(@NonNull T type, @NonNull DocHandler handler) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            this.typeH.put(type, handler);
            this.arealyWhen = true;
            return this;
        }

        public OptionHandler<GT, T> setMongoKey(@NonNull String mongoKey) {
            if (mongoKey == null) {
                throw new NullPointerException("mongoKey is marked non-null but is null");
            }
            this.mongoKey = mongoKey;
            return this;
        }

        public List<TopManOptionsEntity> getResult(String typeGroupName) {
            return this.getResult(typeGroupName, false);
        }

        public List<TopManOptionsEntity> getResult(String typeGroupName, boolean clearCache) {
            TypeGroupInterface enumConstant;
            if (!this.arealyWhen) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u6267\u884cwhen\u518d\u6267\u884cgetResult"));
            }
            ArrayList<TopManOptionsEntity> result = new ArrayList<TopManOptionsEntity>(10);
            TypeGroupInterface tn = null;
            TypeGroupInterface[] typeGroupInterfaceArray = (TypeGroupInterface[])this.typeGroup.getEnumConstants();
            int n = typeGroupInterfaceArray.length;
            for (int i = 0; i < n && (tn = (TypeGroupInterface)(enumConstant = typeGroupInterfaceArray[i]).getTypeGroup(typeGroupName)) == null; ++i) {
            }
            if (tn == null) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u578b\u7ec4"));
            }
            try (MongoCursor document = mongoTemplate.getCollection(this.collection).find().noCursorTimeout(true).cursor();){
                while (document.hasNext()) {
                    TopManOptionsEntity topManOptionsEntity = null;
                    Document next = (Document)document.next();
                    String typeKey = next.getString((Object)this.mongoKey);
                    Object optionsType = tn.getType(typeKey);
                    if (optionsType == null) {
                        log.warn(typeKey + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5904\u7406\u5668\uff0c\u786e\u8ba4\u662f\u5426\u6709\u8c03\u7528when\u53bb\u521b\u5efa\u8be5\u7c7b\u578b\u7684\u5904\u7406\u5668");
                        continue;
                    }
                    DocHandler docHandler = this.typeH.get(optionsType);
                    if (docHandler != null) {
                        topManOptionsEntity = optionsType.getResult(next, docHandler);
                    }
                    if (topManOptionsEntity == null) continue;
                    if (typeKey.equals("\u8fbe\u4eba\u4fe1\u606f")) {
                        topManOptionsEntity.getChildren().removeAll(Collections.singleton(null));
                        List list = topManOptionsEntity.getChildren();
                    }
                    result.add(topManOptionsEntity);
                }
            }
            return result;
        }
    }
}

