/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.utils.TimeTranslateUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.dto.TopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsTopmanRecord;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.mapper.GoodsTopmanRecordMapper;
import com.els.modules.industryinfo.mapper.TopManInformationHeadMapper;
import com.els.modules.industryinfo.service.GoodsTopmanItemService;
import com.els.modules.industryinfo.service.GoodsTopmanRecordService;
import com.els.modules.industryinfo.vo.TabCountVO;
import com.els.modules.industryinfo.vo.TopmanItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsTopmanRecordServiceImpl
extends BaseServiceImpl<GoodsTopmanRecordMapper, GoodsTopmanRecord>
implements GoodsTopmanRecordService {
    @Autowired
    private GoodsTopmanRecordMapper goodsTopmanRecordMapper;
    @Autowired
    private GoodsTopmanItemService goodsTopmanItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private TopManInformationHeadMapper topManInformationHeadMapper;

    @Override
    public List<GoodsTopmanRecord> selectByMainId(String mainId) {
        return this.goodsTopmanRecordMapper.selectByMainId(mainId);
    }

    @Override
    public IPage<TopmanItemVO> queryTopmanPage(Page<TopManInformationHead> page, QueryWrapper<TopManInformationHead> queryWrapper, TopmanItemQueryDTO queryDTO) {
        IPage<TopmanItemVO> itemPage;
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        String contentType = queryDTO.getTopmanContentType();
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            if (contentType.contains(",")) {
                contentType = contentType.replace(",", "|");
            } else if (contentType.contains("\u5168\u90e8")) {
                contentType = "";
            }
            queryDTO.setTopmanContentType(contentType);
        }
        if (CollectionUtils.isNotEmpty((Collection)(itemPage = this.topManInformationHeadMapper.topManInformationHeadPageByGoodsId(page, queryWrapper, queryDTO)).getRecords())) {
            for (TopmanItemVO vo : itemPage.getRecords()) {
                if (vo.getSalesAmountMax() == null || vo.getPrice() == null || vo.getPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal salesNum = vo.getSalesAmountMax().divide(vo.getPrice(), 0, 4);
                vo.setSalesNum(salesNum);
            }
        }
        return itemPage;
    }

    @Override
    public List<TopmanItemVO> queryTopmanList(QueryWrapper<TopManInformationHead> queryWrapper, TopmanItemQueryDTO queryDTO) {
        List<TopmanItemVO> voList;
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        String contentType = queryDTO.getTopmanContentType();
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            if (contentType.contains(",")) {
                contentType = contentType.replace(",", "|");
            } else if (contentType.contains("\u5168\u90e8")) {
                contentType = "";
            }
            queryDTO.setTopmanContentType(contentType);
        }
        if (CollectionUtils.isNotEmpty(voList = this.topManInformationHeadMapper.topManInformationHeadListByGoodsId(queryWrapper, queryDTO))) {
            for (TopmanItemVO vo : voList) {
                if (vo.getSalesAmountMax() == null || vo.getPrice() == null || vo.getPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal salesNum = vo.getSalesAmountMax().divide(vo.getPrice(), 0, 4);
                vo.setSalesNum(salesNum);
            }
        }
        return voList;
    }

    @Override
    @Deprecated
    public QueryWrapper<GoodsTopmanRecord> criteriaQuery(QueryWrapper<GoodsTopmanRecord> queryWrapper, GoodsTopmanItemQueryDTO queryDTO) {
        List<GoodsTopmanItem> records;
        Boolean phoneNumber;
        String goodsWom;
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        if (timeSelect.length() < 10) {
            Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)dates[0], (Object)dates[1]);
        } else if (timeSelect.contains("\u81f3")) {
            String[] strings = timeSelect.split("\u81f3");
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)strings[0], (Object)strings[1]);
        }
        String fansNum = queryDTO.getTopmanFansNum();
        if (StringUtils.isNotBlank((CharSequence)fansNum)) {
            String[] strings;
            if (fansNum.contains("-")) {
                strings = fansNum.split("-");
                queryWrapper.lambda().gt(GoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(GoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains("<")) {
                strings = fansNum.split("<");
                queryWrapper.lambda().lt(GoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains(">")) {
                strings = fansNum.split(">");
                queryWrapper.lambda().gt(GoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsWom = queryDTO.getTopmanGoodsWom()))) {
            String[] strings;
            if (goodsWom.contains("-")) {
                strings = goodsWom.split("-");
                queryWrapper.lambda().between(GoodsTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (goodsWom.contains("<")) {
                strings = goodsWom.split("<");
                queryWrapper.lambda().lt(GoodsTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(GoodsTopmanRecord::getGoodsWom, (Object)new BigDecimal(goodsWom));
            }
        }
        if ((phoneNumber = queryDTO.getTopmanPhoneNumber()) != null && phoneNumber.booleanValue()) {
            queryWrapper.lambda().isNotNull(GoodsTopmanRecord::getPhoneNumber);
        }
        if (CollectionUtil.isNotEmpty(records = this.goodsTopmanItemService.queryList(queryDTO))) {
            List recordIds = records.stream().map(GoodsTopmanItem::getRecordId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, recordIds);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        return queryWrapper;
    }

    @Override
    public List<CountVO> contentTypeCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        List<TabCountVO> list = this.topManInformationHeadMapper.tabCountByGoodsId(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "talentClassification", null, Integer.valueOf(list.size())));
        if (CollectionUtil.isEmpty(list)) {
            return result;
        }
        LinkedHashSet<String> finalTypes = new LinkedHashSet<String>();
        for (TabCountVO vo : list) {
            if (!StringUtils.isNotBlank((CharSequence)vo.getType())) continue;
            if (vo.getType().contains("-")) {
                String[] split = vo.getType().split("-");
                finalTypes.addAll(Arrays.asList(split));
                continue;
            }
            finalTypes.add(vo.getType());
        }
        if (CollectionUtil.isNotEmpty(finalTypes)) {
            for (String finalType : finalTypes) {
                long count = list.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getType()) && h.getType().contains(finalType)).count();
                result.add(new CountVO(I18nUtil.translate((String)"", (String)finalType), "talentClassification", finalType, Integer.valueOf((int)count)));
            }
        }
        return result;
    }

    @Override
    public List<CountVO> goodsWomCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        List<TabCountVO> list = this.topManInformationHeadMapper.tabCountByGoodsId(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "topmanGoodsWom", null, Integer.valueOf(list.size())));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("topmanGoodsWom", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            long total = 0L;
            if (dto.getValue().contains("-")) {
                String[] strings = dto.getValue().split("-");
                total = list.stream().filter(h -> h.getGoodsWom() != null && h.getGoodsWom().compareTo(new BigDecimal(strings[0])) >= 0 && h.getGoodsWom().compareTo(new BigDecimal(strings[1])) <= 0).count();
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "topmanGoodsWom", dto.getValue(), Integer.valueOf((int)total)));
        }
        return result;
    }
}

