/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.industryinfo.entity.McnAttachmentEntity;
import com.els.modules.industryinfo.service.McnAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mcn/upload"})
@Api(tags={""})
public class McnAttachmentController
extends BaseController<McnAttachmentEntity, McnAttachmentService> {
    private static final Logger log = Logger.getLogger(McnAttachmentController.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    @Autowired
    private McnAttachmentService mcnAttachmentService;

    @AutoLog(value="MCN\u56fe\u7247-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u56fe\u7247", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/noToken/file"}, method={RequestMethod.POST})
    public Result<?> upload(@RequestBody JSONObject jsonParam) {
        String topmanId = jsonParam.getString("topmanId");
        Assert.hasText((String)topmanId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8fbe\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a"));
        String platform = jsonParam.getString("platform");
        Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
        byte[] bytes = jsonParam.getBytes("file");
        StorageFileInfo fileInfo = new StorageFileInfo();
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowday = dtf.format(time);
        String documentName = topmanId + ".jpg";
        documentName = documentName.replaceAll("-", "_");
        String documentType = "";
        String documentLocation = File.separator + "pic" + File.separator + documentName;
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
        savePath = savePath.replaceAll(" ", "_");
        fileInfo.setPath(savePath);
        fileInfo.setFilename(documentName);
        fileInfo.setOriginalFilename(documentName);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        fileInfo = this.fileStoreSignServiceImpl.storeFile((InputStream)inputStream, fileInfo, (String)null);
        System.out.println("adddddddddddddd=" + fileInfo);
        String url = this.fileStoreSignServiceImpl.getDownloadPath(fileInfo.getPath(), fileInfo.getSaveType());
        System.out.println("sdddddddddddddddd=" + url);
        McnAttachmentEntity attachment = new McnAttachmentEntity();
        attachment.setTopmanId(topmanId);
        attachment.setId(topmanId);
        attachment.setPlatform(platform);
        attachment.setFileName(fileInfo.getOriginalFilename());
        attachment.setFileSize(String.valueOf(fileInfo.getSize()));
        attachment.setFilePath(fileInfo.getPath());
        attachment.setTopmanAvatar(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), fileInfo.getSaveType()));
        boolean result = this.mcnAttachmentService.saveOrUpdate((Object)attachment);
        if (result) {
            return Result.ok((Object)((Object)attachment));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    public static void uploadFile(byte[] file, String filePath, String fileName) throws Exception {
        File targetFile = new File(filePath);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(filePath + "/" + fileName);
        out.write(file);
        out.flush();
        out.close();
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List mcnAttachmentEntities;
        List list = this.mcnAttachmentService.list();
        List bStationId = list.stream().map(McnAttachmentEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(mcnAttachmentEntities = this.mcnAttachmentService.listByIds(bStationId)))) {
            for (McnAttachmentEntity purchaseAttachment : mcnAttachmentEntities) {
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        this.mcnAttachmentService.removeByIds(idList);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/delete"})
    public Result<?> deleteById(@RequestParam(name="id") String id) {
        ArrayList<String> filePaths = new ArrayList<String>();
        McnAttachmentEntity byId = (McnAttachmentEntity)((Object)this.mcnAttachmentService.getById((Serializable)((Object)id)));
        filePaths.add(byId.getFilePath());
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        System.out.println("aaaaaaaaaaaaaaaaaaaaaaaaaaaa:" + b);
        this.mcnAttachmentService.removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }
}

