/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.adapter.msg;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.common.constant.CommonConstant;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.industryinfo.adapter.msg.TopManMsgAdapter;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManIndexListPage;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManInfoEntity;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.properties.TopManMsgProperties;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"1"})
public class DouYinMsgAdapter
extends TopManMsgAdapter {
    private static final Logger log = LoggerFactory.getLogger(DouYinMsgAdapter.class);
    @Autowired
    private TopManInformationService topManInformationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;
    @Autowired
    private SpiderApiUtil spiderApiUtil;

    @Override
    public List<TopManMsgRecord> getSearchData(String filterInfoJson, TopManMsgTask topManMsgTask, int limitSize) {
        SimplePostRequestParam topManDto = new SimplePostRequestParam();
        RequestOptionVO requestOptionVO = new RequestOptionVO();
        JSONObject jsonObject = JSON.parseObject((String)filterInfoJson);
        JSONObject f = jsonObject.getJSONObject("filterInfo");
        requestOptionVO.setTaskType(f.getString("taskType"));
        requestOptionVO.setPlatformType(f.getString("platformType"));
        JSONObject screen = f.getJSONObject("screenItem");
        HashMap screenItem = Maps.newHashMap();
        AtomicBoolean emptyFlag = new AtomicBoolean(true);
        screen.keySet().forEach(key -> {
            JSONArray jsonArray = screen.getJSONArray(key);
            List screenItems = jsonArray.toJavaList(RequestOptionVO.ScreenItem.class);
            if (CollUtil.isNotEmpty((Collection)screenItems)) {
                emptyFlag.set(false);
            }
            screenItem.put(key, screenItems);
        });
        requestOptionVO.setScreenItem((Map)screenItem);
        topManDto.setFilterInfo((Object)requestOptionVO);
        topManDto.setKeyWord(f.getString("keyWord"));
        if (StrUtil.isBlank((CharSequence)f.getString("keyWord")) && emptyFlag.get()) {
            return Lists.newArrayList();
        }
        ArrayList searchList = this.handleDouYinListData(filterInfoJson, (SimplePostRequestParam<RequestOptionVO>)topManDto, topManMsgTask, limitSize);
        return CollUtil.isNotEmpty(searchList) ? searchList : Lists.newArrayList();
    }

    private List<TopManMsgRecord> handleDouYinListData(String filterInfoJson, SimplePostRequestParam<RequestOptionVO> topManDto, TopManMsgTask task, int limit) {
        ArrayList list = Lists.newArrayList();
        List oldTaskRecord = this.topManMsgRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)task.getId()));
        List oldTopManNames = oldTaskRecord.stream().map(x -> x.getTopmanName()).distinct().collect(Collectors.toList());
        int total = this.topManMsgProperties.getPageSize();
        int totalData = 0;
        int pageNo = 1;
        boolean endFlag = true;
        while (endFlag) {
            topManDto.setPageNo(Integer.valueOf(pageNo));
            topManDto.setPageSize(Integer.valueOf(total));
            Map<String, Object> apiParam = this.topManInformationService.getApiParam(topManDto);
            DyTopManIndexListPage apiResult = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_INDEX_LIST, apiParam, DyTopManIndexListPage.class);
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getList())) {
                ++pageNo;
                for (DyTopManInfoEntity apiData : apiResult.getList()) {
                    if (ObjectUtil.isEmpty((Object)apiData.getAuthorBase()) || ObjectUtil.isEmpty((Object)apiData.getAuthorBase().getNickname()) || oldTopManNames.contains(apiData.getAuthorBase().getNickname())) continue;
                    if (totalData >= limit) {
                        return list;
                    }
                    oldTopManNames.add(apiData.getAuthorBase().getNickname());
                    TopManMsgRecord topManMsgRecord = new TopManMsgRecord();
                    topManMsgRecord.setTaskId(task.getId());
                    topManMsgRecord.setPlatform(task.getPlatform());
                    topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
                    topManMsgRecord.setSubAdd("2");
                    topManMsgRecord.setElsAccount(task.getElsAccount());
                    topManMsgRecord.setSubAccount(task.getSubAccount());
                    topManMsgRecord.setSearchContext(filterInfoJson);
                    topManMsgRecord.setSendStatus("0");
                    topManMsgRecord.setReplyStatus("0");
                    topManMsgRecord.setSendCount(0);
                    topManMsgRecord.setReplyCount(0);
                    topManMsgRecord.setId(IdWorker.getIdStr());
                    topManMsgRecord.setTopmanId(apiData.getAuthorBase().getUid());
                    topManMsgRecord.setTopmanName(apiData.getAuthorBase().getNickname());
                    topManMsgRecord.setAvatar(apiData.getAuthorBase().getAvatar());
                    if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorBase().getFansNum())) {
                        topManMsgRecord.setFansNum(apiData.getAuthorBase().getFansNum().toString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorVideo()) && ObjectUtil.isNotEmpty((Object)apiData.getAuthorVideo().getPlayMedian())) {
                        topManMsgRecord.setVideoPlayAvg(apiData.getAuthorVideo().getPlayMedian().toString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive())) {
                        if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getWatchingNumber())) {
                            topManMsgRecord.setWatchingNumber(apiData.getAuthorLive().getWatchingNumber().toString());
                        }
                        if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getSaleLow()) && ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getSaleHigh())) {
                            topManMsgRecord.setLiveSaleAvg(apiData.getAuthorLive().getSaleLow().toString() + " - " + apiData.getAuthorLive().getSaleHigh());
                        }
                    }
                    list.add(topManMsgRecord);
                    ++totalData;
                }
                continue;
            }
            endFlag = false;
        }
        return list;
    }
}

