/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.kafka;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.industryinfo.dto.TopManMsgReplyDto;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.service.McnAttachmentService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumer {
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private McnAttachmentService mcnAttachmentService;

    public void listenTestGroup(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        ack.acknowledge();
    }

    @KafkaListener(topics={"douyin_auto_touch_result", "kuaishou_topman_msg_result"})
    public void listenAutoTuchTopMapMsg(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            TopmanMsgRqDto msg = (TopmanMsgRqDto)JSON.parseObject((String)value, TopmanMsgRqDto.class);
            this.topManMsgRecordService.handleMsg(msg);
        }
        ack.acknowledge();
    }

    @KafkaListener(topics={"douyin_auto_touch_msg_reply", "kuaishou_auto_touch_msg_reply"})
    public void listenTopMapReply(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            TopManMsgReplyDto msg = (TopManMsgReplyDto)JSON.parseObject((String)value, TopManMsgReplyDto.class);
            this.topManMsgRecordService.handleReplyMsg(msg);
        }
        ack.acknowledge();
    }

    @KafkaListener(topics={"mcn_upload_file1111"})
    public void listenTopMapBstationPic(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            JSONObject jsonObject = JSON.parseObject((String)value);
            this.mcnAttachmentService.upload(jsonObject);
        }
        ack.acknowledge();
    }
}

