/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.AdapterFactory;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.adapter.msg.ITopManMessageAdapter;
import com.els.modules.industryinfo.dto.TopManMsgCaptchaDto;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgRecordHis;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.enumerate.MsgTypeEnum;
import com.els.modules.industryinfo.mapper.TopManMsgTaskMapper;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgRecordHisService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.service.TopManMsgTaskService;
import com.els.modules.industryinfo.utils.RedissonUtil;
import com.els.modules.industryinfo.utils.spider.entity.LoginRp;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.properties.TopManMsgProperties;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgTaskServiceImpl
extends BaseServiceImpl<TopManMsgTaskMapper, TopManMsgTask>
implements TopManMsgTaskService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskServiceImpl.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Lazy
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private AdapterFactory adapterFactory;
    @Autowired
    private TopManMsgRecordHisService hisService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public TopManMsgTask getOneByPlatform(String platform) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveBySubAccount(TopManMsgTask topManMsgTask, String type) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask db = this.getOneByPlatform(topManMsgTask.getPlatform());
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            topManMsgTask.setSubAccount(loginUser.getSubAccount());
            topManMsgTask.setDeleted(CommonConstant.STATUS_NO);
            ((TopManMsgTaskMapper)this.baseMapper).insert((Object)topManMsgTask);
        } else {
            topManMsgTask.setId(db.getId());
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
        switch (type) {
            case "1": {
                updateWrapper.set((Object)"filter_info_json", (Object)topManMsgTask.getFilterInfoJson());
                break;
            }
            case "2": {
                this.checkPsd(topManMsgTask);
                updateWrapper.set((Object)"platform_url", (Object)topManMsgTask.getPlatformUrl());
                updateWrapper.set((Object)"platform_account", (Object)topManMsgTask.getPlatformAccount());
                updateWrapper.set((Object)"platform_psd", (Object)topManMsgTask.getPlatformPsd());
            }
        }
        this.update((Wrapper)updateWrapper);
    }

    private void checkPsd(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "login_opt"), params, LoginRp.class);
        TopManMsgTask db = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).ne(BaseEntity::getId, (Object)topManMsgTask.getId()), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
            Assert.isTrue((boolean)false, (String)("\u6b64\u8d26\u53f7\u5df2\u88ab" + db.getElsAccount() + db.getSubAccount() + "\u4f7f\u7528"));
        }
    }

    @Override
    public void edit(TopManMsgTask topManMsgTask) {
        int count = ((TopManMsgTaskMapper)this.baseMapper).updateById((Object)topManMsgTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private TopManMsgConfig getContent(List<TopManMsgConfig> list, Integer sortNum) {
        if (ObjectUtil.isNotNull((Object)sortNum)) {
            return list.stream().filter(x -> x.getSortNum().equals(sortNum)).findFirst().orElse(new TopManMsgConfig());
        }
        return list.get(0);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public TopManMsgTask startUp(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5bc6\u7801");
        String lockKey = "TOPMAN_MSG_" + topManMsgTask.getPlatformAccount() + "_" + topManMsgTask.getPlatform();
        List<TopManMsgConfig> msgConfigs = this.topManMsgConfigService.listBySubAccount(topManMsgTask.getElsAccount(), topManMsgTask.getSubAccount(), topManMsgTask.getPlatform());
        Assert.isTrue((boolean)CollUtil.isNotEmpty(msgConfigs), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u6d88\u606f\u8bbe\u7f6e");
        long time = 120L;
        RLock lock = this.redissonUtil.lock(lockKey, (Long)time);
        try {
            List lev2;
            if ("1".equals(topManMsgTask.getNeedCheck())) {
                Assert.notNull((Object)lock, (String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            Map<String, List<TopManMsgConfig>> msgMap = msgConfigs.stream().collect(Collectors.groupingBy(x -> x.getMsgType()));
            Map<String, TopManMsgConfig> msgIdMap = msgConfigs.stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
            List<TopManMsgConfig> callMsgs = msgMap.get(MsgTypeEnum.CALL.getCode());
            Assert.isTrue((boolean)CollUtil.isNotEmpty(msgConfigs), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u62db\u547c\u6d88\u606f\u8bbe\u7f6e");
            int limitSize = this.topManMsgProperties.getLimit();
            List sends = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(TopManMsgRecord::getSubAdd, (Object)"1")).eq(TopManMsgRecord::getPush, (Object)"0")).last("limit " + limitSize));
            if (CollUtil.isEmpty((Collection)sends)) {
                sends = Lists.newArrayList();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String now = simpleDateFormat.format(new Date()) + " 00:00:00";
            if ((limitSize -= sends.size()) > 0 && CollUtil.isNotEmpty((Collection)(lev2 = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"1")).eq(TopManMsgRecord::getReplyStatus, (Object)"0")).eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).lt(BaseEntity::getUpdateTime, (Object)now)).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit " + limitSize))))) {
                sends.addAll(lev2);
                limitSize -= sends.size();
            }
            List<TopManMsgConfig> chatMsgs = msgMap.get(MsgTypeEnum.CHAT.getCode());
            List calls = Lists.newArrayList();
            if (CollUtil.isNotEmpty(chatMsgs)) {
                calls = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"1")).eq(TopManMsgRecord::getReplyStatus, (Object)"1")).lt(BaseEntity::getUpdateTime, (Object)now)).orderByAsc(TopManMsgRecord::getSubAdd));
            }
            String filterInfoJson = topManMsgTask.getFilterInfoJson();
            ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
            if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)filterInfoJson)) {
                List<TopManMsgRecord> searchList = adapter.getSearchData(filterInfoJson, topManMsgTask, limitSize);
                sends.addAll(searchList);
            }
            if (CollUtil.isNotEmpty((Collection)sends) || CollUtil.isNotEmpty((Collection)calls)) {
                List<TopManMsgRecord> finallys = this.handleMsgConfig(topManMsgTask, sends, calls, callMsgs, chatMsgs, limitSize);
                this.sensMsgAndSaveRecord(finallys, topManMsgTask, msgIdMap);
                topManMsgTask.setStatus("1");
            } else {
                Assert.isTrue((boolean)false, (String)"\u672a\u627e\u5230\u53ef\u89e6\u8fbe\u7684\u8fbe\u4eba");
            }
            this.updateById((Object)topManMsgTask);
        }
        catch (Exception e) {
            log.error("\u5f00\u542f\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            this.redissonUtil.unLock(lock);
            return topManMsgTask;
        }
    }

    private List<TopManMsgRecord> handleMsgConfig(TopManMsgTask task, List<TopManMsgRecord> sends, List<TopManMsgRecord> calls, List<TopManMsgConfig> callMsgs, List<TopManMsgConfig> chatMsgs, int limitSize) {
        TopManMsgConfig config;
        Map<Integer, TopManMsgConfig> call = callMsgs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        Map<Object, Object> chat = Maps.newHashMap();
        if (ObjectUtil.isNotEmpty(chatMsgs)) {
            chat = chatMsgs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        }
        ArrayList finallys = Lists.newArrayList();
        HashSet sendSet = Sets.newHashSet();
        for (TopManMsgRecord send : sends) {
            if (!sendSet.contains(send.getTopmanName())) {
                send.setTaskId(task.getId());
                if (send.getSendCount() == 0) {
                    config = call.get(1);
                    if (ObjectUtil.isEmpty((Object)((Object)config))) continue;
                    send.setMsgId(config.getId());
                    send.setMsgContent(config.getMsgContent());
                    finallys.add(send);
                    continue;
                }
                config = call.get(send.getSendCount() + 1);
                if (ObjectUtil.isEmpty((Object)((Object)config)) || !ObjectUtil.isNotEmpty((Object)((Object)config)) || this.hisService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)send.getId())).eq(TopManMsgRecordHis::getSortNum, (Object)config.getSortNum())) != 0) continue;
                send.setMsgId(config.getId());
                send.setMsgContent(config.getMsgContent());
                finallys.add(send);
                continue;
            }
            sendSet.add(send.getTopmanName());
        }
        for (TopManMsgRecord reply : calls) {
            if (reply.getReplyCount() == 1) {
                config = (TopManMsgConfig)((Object)chat.get(1));
                if (ObjectUtil.isEmpty((Object)((Object)config))) continue;
                reply.setMsgId(config.getId());
                reply.setMsgContent(config.getMsgContent());
                finallys.add(reply);
                continue;
            }
            config = (TopManMsgConfig)((Object)chat.get(reply.getSendCount() + 1));
            if (ObjectUtil.isEmpty((Object)((Object)config)) || !ObjectUtil.isNotEmpty((Object)((Object)config)) || this.hisService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)reply.getId())).eq(TopManMsgRecordHis::getSortNum, (Object)config.getSortNum())) != 0) continue;
            reply.setMsgId(config.getId());
            reply.setMsgContent(config.getMsgContent());
            finallys.add(reply);
        }
        return finallys;
    }

    private void sensMsgAndSaveRecord(List<TopManMsgRecord> finallys, TopManMsgTask topManMsgTask, Map<String, TopManMsgConfig> msgIdMap) {
        Map<String, List<TopManMsgRecord>> finalMap = finallys.stream().collect(Collectors.groupingBy(x -> x.getTopmanName()));
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        ArrayList rqs = Lists.newArrayList();
        ArrayList records = Lists.newArrayList();
        ArrayList hisList = Lists.newArrayList();
        finalMap.forEach((k, v) -> {
            TopmanMsgRqDto.Msg msg = new TopmanMsgRqDto.Msg();
            msg.setTopmanName((String)k);
            ArrayList contents = Lists.newArrayList();
            TopManMsgRecord record = (TopManMsgRecord)((Object)((Object)v.get(0)));
            records.add(record);
            v.forEach(row -> {
                TopmanMsgRqDto.Msg.Content content = new TopmanMsgRqDto.Msg.Content();
                TopManMsgRecordHis his = new TopManMsgRecordHis();
                his.setTaskId(record.getId());
                his.setId(IdWorker.getIdStr());
                content.setTaskId(his.getId());
                content.setContent(row.getMsgContent());
                his.setSendMsgId(row.getMsgId());
                his.setSendMsgContent(row.getMsgContent());
                TopManMsgConfig config = (TopManMsgConfig)((Object)((Object)((Object)msgIdMap.get(row.getMsgId()))));
                his.setMsgType(config.getMsgType());
                his.setSortNum(config.getSortNum());
                hisList.add(his);
                contents.add(content);
                msg.getMsg().add(content);
            });
            rqs.add(msg);
        });
        params.put("topmanList", rqs);
        log.info("\u8bf7\u6c42py\u6296\u97f3\u53d1\u9001\u6d88\u606f\u5165\u53c2[{}]", (Object)JSON.toJSONString((Object)params));
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "send_opt"), params, LoginRp.class);
        log.info("py\u6296\u97f3\u53d1\u9001\u6d88\u606f\u51fa\u53c2 is [{}]", (Object)JSON.toJSONString((Object)rp));
        this.topManMsgRecordService.saveOrUpdateBatch(records);
        this.hisService.saveBatch(hisList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void stop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        this.handleTaskStop(topManMsgTask);
        String lockKey = "TOPMAN_MSG_" + topManMsgTask.getPlatformAccount() + "_" + topManMsgTask.getPlatform();
        long time = 120L;
        this.redissonUtil.lock(lockKey, (Long)time);
    }

    private void handleTaskStop(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "stop_opt"), params, LoginRp.class);
        topManMsgTask.setStatus("0");
        this.updateById((Object)topManMsgTask);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper.eq((Object)"send_status", (Object)"0");
        queryWrapper.ne((Object)"is_sub_add", (Object)"1");
        queryWrapper.ne((Object)"is_added", (Object)"1");
        List records = Optional.ofNullable(this.topManMsgRecordService.list((Wrapper)queryWrapper)).orElse(Lists.newArrayList());
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper1.eq((Object)"send_status", (Object)"0");
        queryWrapper1.eq((Object)"is_sub_add", (Object)"1");
        records.addAll(this.topManMsgRecordService.list((Wrapper)queryWrapper1));
        if (CollUtil.isNotEmpty((Collection)records)) {
            List taskIds = records.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            this.hisService.remove((Wrapper)Wrappers.lambdaQuery().in(TopManMsgRecordHis::getTaskId, taskIds));
            this.topManMsgRecordService.remove((Wrapper)queryWrapper);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        updateWrapper.eq((Object)"send_status", (Object)"0");
        updateWrapper.lambda().and(wrapper -> {
            LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TopManMsgRecord::getIsAdded, (Object)"1")).or()).eq(TopManMsgRecord::getSubAdd, (Object)"1");
        });
        updateWrapper.set((Object)"is_push", (Object)"0");
        this.topManMsgRecordService.update((Wrapper)updateWrapper);
    }

    @Override
    public TopManMsgTask getData(String platform) {
        TopManMsgTask db = this.getOneByPlatform(platform);
        return db;
    }

    @Override
    public void processCaptcha(TopManMsgCaptchaDto rq) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)rq.getId()));
        TopManMsgCaptchaDto topManMsgCaptchaDto = (TopManMsgCaptchaDto)this.mongoTemplate.findOne(query, TopManMsgCaptchaDto.class);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgCaptchaDto), (String)"\u672a\u83b7\u53d6\u5230\u6570\u636e!");
        if (ObjectUtil.isEmpty((Object)topManMsgCaptchaDto)) {
            topManMsgCaptchaDto = new TopManMsgCaptchaDto();
        }
        topManMsgCaptchaDto.setType(rq.getType());
        topManMsgCaptchaDto.setUserName(rq.getUserName());
        String key = "TOPMAN_MSG_CAPTCHA:" + rq.getType() + rq.getUserName();
        this.redisUtil.set(key, (Object)topManMsgCaptchaDto);
    }

    @Override
    public TopManMsgCaptchaDto getCaptcha(TopManMsgCaptchaDto rq) {
        String key = "TOPMAN_MSG_CAPTCHA:" + rq.getType() + rq.getUserName();
        if (this.redisUtil.hasKey(key)) {
            TopManMsgCaptchaDto dto = (TopManMsgCaptchaDto)this.redisUtil.get(key);
            this.redisUtil.del(new String[]{key});
            return dto;
        }
        return null;
    }

    @Override
    public void enterCaptcha(TopManMsgCaptchaDto rq) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userName").is((Object)rq.getUserName()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)rq.getType()));
        Update update = new Update();
        update.set("captcha", (Object)rq.getCaptcha());
        update.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, TopManMsgCaptchaDto.COLLECTION_NAME);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"platform_account", (Object)rq.getUserName());
        updateWrapper.eq((Object)"platform", (Object)rq.getType());
        updateWrapper.set((Object)"verification_code", (Object)rq.getCaptcha());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void noTokenStop(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getPlatformAccount()), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getPlatform()), (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
        TopManMsgTask dbTask = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)dbTask)), (String)"\u4fe1\u606f\u5f02\u5e38");
        this.handleTaskStop(dbTask);
    }
}

