/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.ZhiHuTopManInformationDTO;
import com.els.modules.industryinfo.entity.ZhiHuTopManInformation;
import com.els.modules.industryinfo.enumerate.ZhiHuOptionsTypeGroup;
import com.els.modules.industryinfo.mapper.ZhiHuTopManInformationMapper;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.service.ZhiHuTopManInformationService;
import com.els.modules.industryinfo.utils.spider.dto.ZhiHuTopManApiDTO;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.utils.spider.vo.ZhiHuTopManApiPage;
import com.els.modules.industryinfo.utils.spider.vo.ZhiHuTopManApiVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ZhiHuTopManInformationServiceImpl
extends BaseServiceImpl<ZhiHuTopManInformationMapper, ZhiHuTopManInformation>
implements ZhiHuTopManInformationService {
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private AccountRpcService accountRpcService;

    @Override
    public IPage<ZhiHuTopManInformation> queryTopManList(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        IPage<ZhiHuTopManInformation> page = new IPage<ZhiHuTopManInformation>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        ZhiHuTopManInformationDTO filterInfo = (ZhiHuTopManInformationDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if (ZhiHuOptionsTypeGroup.zhiHuTopMan.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBodyTopMan(topManDto);
            SpiderMethodType methodType = SpiderMethodType.ZHI_HU_LIST;
            Class<ZhiHuTopManApiPage> responseClass = ZhiHuTopManApiPage.class;
            ZhiHuTopManApiPage data = this.spiderApiUtil.postForEntity(methodType, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType()));
        } else {
            QueryWrapper<ZhiHuTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
            page = ((ZhiHuTopManInformationMapper)this.baseMapper).selectCollectTopMan(page, queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private QueryWrapper<ZhiHuTopManInformation> getQueryWrapper(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        String[] columns;
        String column;
        ZhiHuTopManInformationDTO filterInfo = (ZhiHuTopManInformationDTO)topManDto.getFilterInfo();
        ZhiHuTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(ZhiHuTopManInformation::getName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(ZhiHuTopManInformation::getUid, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new ZhiHuTopManInformation()));
        }
        return query;
    }

    private List<ZhiHuTopManInformation> handleResult(ZhiHuTopManApiPage data, String platform) {
        List<ZhiHuTopManApiVO> starList = data.getList();
        if (CollectionUtil.isEmpty(starList)) {
            return new ArrayList<ZhiHuTopManInformation>(0);
        }
        List<String> topmanIds = starList.stream().map(ZhiHuTopManApiVO::getUserId).distinct().collect(Collectors.toList());
        List<ZhiHuTopManInformation> addedAndCollects = ((ZhiHuTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(ZhiHuTopManInformation::getUid, h -> h, (k1, k2) -> k1));
        }
        ArrayList<ZhiHuTopManInformation> resultEntityList = new ArrayList<ZhiHuTopManInformation>(starList.size());
        for (ZhiHuTopManApiVO topManInfo : starList) {
            ZhiHuTopManInformation rb = new ZhiHuTopManInformation();
            BeanUtils.copyProperties((Object)topManInfo, (Object)((Object)rb));
            ZhiHuTopManInformation info = (ZhiHuTopManInformation)((Object)map.get(topManInfo.getUserId()));
            if (info != null) {
                rb.setIsCollection(info.getIsCollection());
                rb.setIsAdded(info.getIsAdded());
            }
            resultEntityList.add(rb);
        }
        return resultEntityList;
    }

    private Map<?, ?> handleBodyTopMan(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        List<ZhiHuTopManInformationDTO.ScreenItemField> contentType;
        ZhiHuTopManInformationDTO.ScreenItem screenItem;
        ZhiHuTopManApiDTO spiderApiDTO = new ZhiHuTopManApiDTO(topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            spiderApiDTO.setKeyword(keyWord);
            spiderApiDTO.setSearchType("0");
        }
        if ((screenItem = ((ZhiHuTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem()) != null && CollectionUtil.isNotEmpty(contentType = screenItem.getContentType())) {
            List<String> collect = contentType.stream().map(ZhiHuTopManInformationDTO.ScreenItemField::getTitle).distinct().collect(Collectors.toList());
            spiderApiDTO.setContentTag(collect);
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }
}

