/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.StorageClass;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.attachment.oss.config.OSSConfigure;
import com.els.modules.attachment.oss.factory.OSSClientFactory;
import com.els.modules.industryinfo.entity.McnAttachmentEntity;
import com.els.modules.industryinfo.service.McnAttachmentService;
import com.els.modules.industryinfo.service.OssAttachmentService;
import com.els.modules.industryinfo.utils.HttpRequestUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class OssAttachmentServiceImpl
implements OssAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(OssAttachmentServiceImpl.class);
    private static OSSConfigure configure = OSSConfigure.getOOSconfigure();
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private McnAttachmentService mcnAttachmentService;
    private final String TB_DY_LOGIN_USER = "tb_dy_login_user";

    @Override
    public void upload(JSONObject jsonParam) {
        JSONArray upload = jsonParam.getJSONArray("upload");
        List jsonObjects = upload.toJavaList(JSONObject.class);
        log.info("\u4e0a\u4f20\u56fe\u7247list:" + jsonObjects.toString());
        if (CollectionUtils.isNotEmpty((Collection)jsonObjects)) {
            for (JSONObject jsonObject : jsonObjects) {
                this.handleFileData(jsonObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleFileData(JSONObject jsonParam) {
        String topmanId = jsonParam.getString("topmanId");
        Assert.hasText((String)topmanId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8fbe\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a"));
        StringBuilder sb = new StringBuilder("bilibili").append(COLON).append("upload").append(COLON).append(topmanId);
        String id = (String)this.redisUtil.get(sb.toString());
        if (id == null) {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"status").is((Object)"1"));
            criteriaList.add(Criteria.where((String)"web_server").is((Object)"1"));
            criteriaList.add(Criteria.where((String)"type").is((Object)"B\u7ad9\u82b1\u706b"));
            Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList.toArray(new Criteria[0])));
            Map cookieMap = (Map)this.mongoTemplate.findOne(query, Map.class, "tb_dy_login_user");
            String platform = jsonParam.getString("platform");
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
            String url = jsonParam.getString("url");
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"url\u4e0d\u80fd\u4e3a\u7a7a"));
            String path = jsonParam.getString("path");
            Assert.hasText((String)path, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a"));
            CloseableHttpClient client = null;
            HttpGet request = new HttpGet(url);
            try {
                client = HttpClients.createDefault();
                InputStream inputStream = HttpRequestUtils.httpGetImg(request, client, cookieMap.get("cookies").toString());
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
                String nowday = dtf.format(time);
                String documentName = topmanId + ".jpg";
                documentName = documentName.replaceAll("-", "_");
                String documentLocation = File.separator + "mcn" + File.separator + platform + File.separator + path + File.separator + "pic" + File.separator + documentName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
                savePath = savePath.replaceAll(" ", "_");
                long length = OssAttachmentServiceImpl.inputStreamToByteArray(inputStream).length;
                String s = this.uploadFile(inputStream, length, documentName, savePath);
                McnAttachmentEntity attachment = new McnAttachmentEntity();
                attachment.setTopmanId(topmanId);
                attachment.setPlatform(platform);
                attachment.setFileName(documentName);
                attachment.setFileSize(length);
                attachment.setFilePath(savePath);
                attachment.setTopmanAvatar(this.getDownload(s));
                attachment.setSaveType("oss");
                boolean b = this.mcnAttachmentService.saveOrUpdate((Object)attachment);
                log.info("bbbbbbbbbbbbbbbbbbbb", (Object)b);
                if (b) {
                    this.redisUtil.set(sb.toString(), (Object)topmanId, 72000000L);
                    log.info("\u8fbe\u4ebaid:" + topmanId + ":\u4e0a\u4f20\u6210\u529f:" + (Object)((Object)attachment));
                }
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                        request.releaseConnection();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return "";
    }

    public String uploadFile(InputStream inputStream, long fileLength, String fileName, String remotePath) throws IOException {
        OSSClient ossClient = OSSClientFactory.create();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(fileLength);
        objectMetadata.setCacheControl("no-cache");
        objectMetadata.setHeader("Pragma", (Object)"no-cache");
        objectMetadata.setContentType(OssAttachmentServiceImpl.contentType(fileName.substring(fileName.lastIndexOf("."))));
        objectMetadata.setContentDisposition("inline;filename=" + fileName);
        objectMetadata.setHeader("x-oss-storage-class", (Object)StorageClass.Standard.toString());
        objectMetadata.setObjectAcl(CannedAccessControlList.PublicRead);
        ossClient.putObject(configure.getBucketName(), remotePath, inputStream, objectMetadata);
        ossClient.shutdown();
        return remotePath + fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inputStreamToByteArray(InputStream inputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int num;
            byte[] buffer = new byte[1024];
            while ((num = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, num);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    @Override
    public String getDownload(String remotePath) {
        URL url;
        String urlStr;
        OSSClient ossClient = OSSClientFactory.create();
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1);
        Date nextYear = cal.getTime();
        if (remotePath.startsWith(File.separator)) {
            remotePath = remotePath.substring(1, remotePath.length());
        }
        if ((urlStr = (url = ossClient.generatePresignedUrl(configure.getBucketName(), remotePath, nextYear)).toString()).indexOf("http:") == 0) {
            urlStr = urlStr.replace("http:", "https:");
        }
        return urlStr;
    }

    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG") || FilenameExtension.equals("jpeg") || FilenameExtension.equals("JPG") || FilenameExtension.equals("jpg") || FilenameExtension.equals("PNG") || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML") || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx") || FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX") || FilenameExtension.equals("docx") || FilenameExtension.equals("DOC") || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
}

