/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.industryinfo.dto.ZhiHuTopManCollectDTO;
import com.els.modules.industryinfo.dto.ZhiHuTopManDetailDTO;
import com.els.modules.industryinfo.dto.ZhiHuTopManInformationDTO;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.entity.ZhiHuTopManInformation;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.enumerate.ZhiHuOptionsType;
import com.els.modules.industryinfo.enumerate.ZhiHuOptionsTypeGroup;
import com.els.modules.industryinfo.mapper.ZhiHuTopManInformationMapper;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.service.ZhiHuTopManInformationService;
import com.els.modules.industryinfo.utils.spider.dto.ZhiHuTopManApiDTO;
import com.els.modules.industryinfo.utils.spider.entity.ZhiHuTopManEntity;
import com.els.modules.industryinfo.utils.spider.entity.ZhiHuTopManPage;
import com.els.modules.industryinfo.utils.spider.entity.ZhuHuManDetailHeadEntity;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.utils.spider.vo.ZhuHuManDetailHeadVO;
import com.els.modules.industryinfo.weboption.OptionFactory;
import com.els.modules.industryinfo.weboption.function.DocHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ZhiHuTopManInformationServiceImpl
extends BaseServiceImpl<ZhiHuTopManInformationMapper, ZhiHuTopManInformation>
implements ZhiHuTopManInformationService {
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private AccountRpcService accountRpcService;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String contentType, String clearCache) {
        OptionFactory.OptionHandler<ZhiHuOptionsTypeGroup, ZhiHuOptionsType> init = OptionFactory.init(ZhiHuOptionsTypeGroup.class, ZhiHuOptionsType.class);
        init.setCollection("tb_zhihu_category");
        switch (contentType) {
            case "all": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferOptions(doc, "1")).when(ZhiHuOptionsType.other, (doc, param) -> this.transferOptions(doc, "1"));
                break;
            }
            case "article": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferOptions(doc, "1")).when(ZhiHuOptionsType.other2, (doc, param) -> this.transferOptions(doc, "1"));
                break;
            }
            case "video": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.videoTime, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferOptions(doc, "1")).when(ZhiHuOptionsType.other, (doc, param) -> this.transferOptions(doc, "1"));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(contentType, "1".equals(clearCache));
    }

    @Override
    public List<TopManOptionsEntity> getEnterpriseOptions(String type, String contentType, String clearCache) {
        OptionFactory.OptionHandler<ZhiHuOptionsTypeGroup, ZhiHuOptionsType> init = OptionFactory.init(ZhiHuOptionsTypeGroup.class, ZhiHuOptionsType.class);
        init.setCollection("tb_zhihu_category");
        switch (contentType) {
            case "allTopMan": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferOptions(doc, "2")).when(ZhiHuOptionsType.other, (doc, param) -> this.transferOptions(doc, "2"));
                break;
            }
            case "myTopMan": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferOptions(doc, "2")).when(ZhiHuOptionsType.other2, (doc, param) -> this.transferOptions(doc, "2"));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(contentType, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> transferOptions(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        ArrayList<TopManOptionsEntity.Tag> tagList = new ArrayList<TopManOptionsEntity.Tag>();
        docList.forEach(a -> tagList.add(this.transferSub((Document)a, type)));
        return tagList;
    }

    private TopManOptionsEntity.Tag transferSub(Document doc, String type) {
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        if (!"2".equals(type) || "\u7c89\u4e1d\u603b\u6570".equals(doc.getString((Object)"starTagName"))) {
            // empty if block
        }
        tag.setStarTagId(doc.getInteger((Object)"starTagId").toString());
        tag.setStarTagName(doc.getString((Object)"starTagName"));
        tag.setStarTagValue(doc.getString((Object)"starTagName"));
        tag.setComponentType(doc.getString((Object)"componentType"));
        tag.setSubTags(doc.getList((Object)"subTags", Object.class));
        return tag;
    }

    @Override
    public IPage<ZhiHuTopManInformation> queryTopManList(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        IPage<ZhiHuTopManInformation> page = new IPage<ZhiHuTopManInformation>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        ZhiHuTopManInformationDTO filterInfo = (ZhiHuTopManInformationDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if (ZhiHuOptionsTypeGroup.zhiHuTopMan.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBodyTopMan(topManDto);
            SpiderMethodType methodType = SpiderMethodType.ZHI_HU_LIST;
            Class<ZhiHuTopManPage> responseClass = ZhiHuTopManPage.class;
            ZhiHuTopManPage data = this.spiderApiUtil.postForEntity(methodType, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType()));
        } else {
            QueryWrapper<ZhiHuTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
            page = ((ZhiHuTopManInformationMapper)this.baseMapper).selectCollectTopMan(page, queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private QueryWrapper<ZhiHuTopManInformation> getQueryWrapper(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        String[] columns;
        String column;
        ZhiHuTopManInformationDTO filterInfo = (ZhiHuTopManInformationDTO)topManDto.getFilterInfo();
        ZhiHuTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(ZhiHuTopManInformation::getName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(ZhiHuTopManInformation::getUid, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new ZhiHuTopManInformation()));
        }
        return query;
    }

    private List<ZhiHuTopManInformation> handleResult(ZhiHuTopManPage data, String platform) {
        List<ZhiHuTopManEntity> starList = data.getList();
        if (CollectionUtil.isEmpty(starList)) {
            return new ArrayList<ZhiHuTopManInformation>(0);
        }
        List<String> topmanIds = starList.stream().map(h -> h.getUid().toString()).distinct().collect(Collectors.toList());
        List<ZhiHuTopManInformation> addedAndCollects = ((ZhiHuTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(ZhiHuTopManInformation::getUid, h -> h, (k1, k2) -> k1));
        }
        ArrayList<ZhiHuTopManInformation> resultEntityList = new ArrayList<ZhiHuTopManInformation>(starList.size());
        for (ZhiHuTopManEntity topManInfo : starList) {
            ZhiHuTopManInformation information = new ZhiHuTopManInformation();
            BeanUtils.copyProperties((Object)topManInfo, (Object)((Object)information));
            ZhiHuTopManInformation info = (ZhiHuTopManInformation)((Object)map.get(topManInfo.getUid().toString()));
            if (info != null) {
                information.setIsCollection(info.getIsCollection());
                information.setIsAdded(info.getIsAdded());
            }
            resultEntityList.add(information);
        }
        return resultEntityList;
    }

    private Map<?, ?> handleBodyTopMan(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        List<ZhiHuTopManInformationDTO.ScreenItemField> contentType;
        ZhiHuTopManInformationDTO.ScreenItem screenItem;
        ZhiHuTopManApiDTO spiderApiDTO = new ZhiHuTopManApiDTO(topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            spiderApiDTO.setName(keyWord);
        }
        if ((screenItem = ((ZhiHuTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem()) != null && CollectionUtil.isNotEmpty(contentType = screenItem.getContentType())) {
            List list = contentType.stream().map(ZhiHuTopManInformationDTO.ScreenItemField::getTitle).distinct().collect(Collectors.toList());
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    @Override
    public void collect(ZhiHuTopManCollectDTO dto) {
        if (MarkYn.check(dto.getCollect())) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(ZhiHuTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        ZhiHuTopManInformation entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(entity.getUid());
            topManCollectBean.setPlatform("6");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"6");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getUid());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(ZhiHuTopManCollectDTO dto) {
        this.saveTopMan(dto.getEntity());
    }

    private void saveTopMan(ZhiHuTopManInformation information) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(ZhiHuTopManInformation::getUid, (Object)information.getUid());
        Integer integer = ((ZhiHuTopManInformationMapper)this.baseMapper).selectCount((Wrapper)query);
        if (integer == 0) {
            information.setSubAccount(SysUtil.getLoginUser().getSubAccount());
            information.setPlatform("6");
            information.setId("");
            ((ZhiHuTopManInformationMapper)this.baseMapper).insert((Object)information);
        }
    }

    @Override
    public ZhuHuManDetailHeadVO getDetailHead(ZhiHuTopManDetailDTO dto) {
        ZhuHuManDetailHeadVO result = null;
        String redisKey = "ZhiHuTopManDetail_" + dto.getPuId();
        if (!"1".equals(dto.getClearCache())) {
            result = (ZhuHuManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("pu_id", dto.getPuId());
        if (result == null) {
            result = new ZhuHuManDetailHeadVO();
            ZhuHuManDetailHeadEntity entity = this.spiderApiUtil.postForEntity(SpiderMethodType.ZHI_HU_DETAIL, apiParam, ZhuHuManDetailHeadEntity.class);
            this.getDetailHeadTranslation(entity, result);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.ZHI_HU_DETAIL, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    dto.setClearCache("1");
                    this.getDetailHead(dto);
                });
            }
        }
        return result;
    }

    private void getDetailHeadTranslation(ZhuHuManDetailHeadEntity entity, ZhuHuManDetailHeadVO result) {
        List<ZhuHuManDetailHeadEntity.Detail.Offer> offerList;
        List<ZhuHuManDetailHeadEntity.Detail.PuWorks> puWorks;
        List<ZhuHuManDetailHeadEntity.Detail.AllOrderGoodsCapacity> goodsCapacities;
        List<ZhuHuManDetailHeadEntity.Detail.Badges> badgesList;
        if (entity == null || entity.getDetail() == null) {
            return;
        }
        ZhuHuManDetailHeadEntity.Detail detail = entity.getDetail();
        ZhuHuManDetailHeadVO.DetailHead detailHead = new ZhuHuManDetailHeadVO.DetailHead();
        BeanUtils.copyProperties((Object)detail, (Object)detailHead);
        ZhuHuManDetailHeadEntity.Detail.Mcn detailMcn = detail.getMcn();
        if (detailMcn != null) {
            ZhuHuManDetailHeadVO.DetailHead.Mcn mcn = new ZhuHuManDetailHeadVO.DetailHead.Mcn();
            BeanUtils.copyProperties((Object)detailMcn, (Object)mcn);
            detailHead.setMcn(mcn);
        }
        if (CollectionUtil.isNotEmpty(badgesList = detail.getBadges())) {
            ArrayList<ZhuHuManDetailHeadVO.DetailHead.Badges> badges = new ArrayList<ZhuHuManDetailHeadVO.DetailHead.Badges>(badgesList.size());
            badgesList.forEach(h -> {
                ZhuHuManDetailHeadVO.DetailHead.Badges badge = new ZhuHuManDetailHeadVO.DetailHead.Badges();
                BeanUtils.copyProperties((Object)h, (Object)badge);
                badges.add(badge);
            });
            detailHead.setBadges(badges);
        }
        result.setDetailHead(detailHead);
        ZhuHuManDetailHeadVO.BaseData baseData = result.getBaseData();
        List<ZhuHuManDetailHeadEntity.Detail.IndustryFieldSkill> fieldSkills = detail.getIndustryFieldSkill();
        if (CollectionUtil.isNotEmpty(fieldSkills)) {
            ArrayList<ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill> skills = new ArrayList<ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill>(fieldSkills.size());
            fieldSkills.forEach(h -> {
                ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill skill = new ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill();
                BeanUtils.copyProperties((Object)h, (Object)skill);
                skills.add(skill);
            });
            baseData.setIndustryFieldSkill(skills);
        }
        if (CollectionUtil.isNotEmpty(goodsCapacities = detail.getAllOrderGoodsCapacity())) {
            ArrayList<ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity> capacities = new ArrayList<ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity>(goodsCapacities.size());
            goodsCapacities.forEach(h -> {
                ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity capacitie = new ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity();
                BeanUtils.copyProperties((Object)h, (Object)capacitie);
                capacities.add(capacitie);
            });
            baseData.setAllOrderGoodsCapacity(capacities);
        }
        result.setBaseData(baseData);
        ZhuHuManDetailHeadVO.FansData fansData = result.getFansData();
        ZhuHuManDetailHeadEntity.Detail.PuFollower puFollower = detail.getPuFollower();
        if (puFollower != null) {
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> provinceList;
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> interestList;
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> genderList;
            ZhuHuManDetailHeadVO.FansData.PuFollower follower = new ZhuHuManDetailHeadVO.FansData.PuFollower();
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> ageList = puFollower.getAgeDistribution();
            if (CollectionUtil.isNotEmpty(ageList)) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> ages = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(ageList.size());
                ageList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution age = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)age);
                    ages.add(age);
                });
                follower.setAgeDistribution(ages);
            }
            if (CollectionUtil.isNotEmpty(genderList = puFollower.getGenderDistribution())) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> genders = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(genderList.size());
                genderList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution gender = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)gender);
                    genders.add(gender);
                });
                follower.setGenderDistribution(genders);
            }
            if (CollectionUtil.isNotEmpty(interestList = puFollower.getInterestDistribution())) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> interests = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(interestList.size());
                interestList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution interest = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)interest);
                    interests.add(interest);
                });
                follower.setAgeDistribution(interests);
            }
            if (CollectionUtil.isNotEmpty(provinceList = puFollower.getProvinceDistribution())) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> provinces = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(provinceList.size());
                provinceList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution province = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)province);
                    provinces.add(province);
                });
                follower.setAgeDistribution(provinces);
            }
            fansData.setPuFollower(follower);
        }
        result.setFansData(fansData);
        ZhuHuManDetailHeadVO.RepresentativeWorks representativeWorks = result.getRepresentativeWorks();
        ZhuHuManDetailHeadEntity.Detail.BusinessEffect businessEffect = detail.getBusinessEffect();
        if (businessEffect != null) {
            ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect effect = new ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect();
            BeanUtils.copyProperties((Object)businessEffect, (Object)effect);
            List<ZhuHuManDetailHeadEntity.Detail.BusinessEffect.RankList> rankList = businessEffect.getRankList();
            if (CollectionUtil.isNotEmpty(rankList)) {
                ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList> ranks = new ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList>(rankList.size());
                rankList.forEach(h -> {
                    ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList rank = new ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList();
                    BeanUtils.copyProperties((Object)h, (Object)rank);
                    ranks.add(rank);
                });
                effect.setRankList(ranks);
            }
            representativeWorks.setBusinessEffect(effect);
        }
        if (CollectionUtil.isNotEmpty(puWorks = detail.getPuWorks())) {
            ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks> works = new ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks>(puWorks.size());
            puWorks.forEach(h -> {
                ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks work = new ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks();
                BeanUtils.copyProperties((Object)h, (Object)work);
                works.add(work);
            });
            representativeWorks.setPuWorks(works);
        }
        result.setRepresentativeWorks(representativeWorks);
        ZhuHuManDetailHeadVO.PromotionData promotionData = result.getPromotionData();
        List<ZhuHuManDetailHeadEntity.Detail.OrderFieldSkill> orderFieldSkills = detail.getOrderFieldSkill();
        if (CollectionUtil.isNotEmpty(orderFieldSkills)) {
            ArrayList<ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill> skills = new ArrayList<ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill>(orderFieldSkills.size());
            orderFieldSkills.forEach(h -> {
                ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill skill = new ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill();
                BeanUtils.copyProperties((Object)h, (Object)skill);
                skills.add(skill);
            });
            promotionData.setOrderFieldSkill(skills);
        }
        if (CollectionUtil.isNotEmpty(offerList = detail.getOffer())) {
            ArrayList<ZhuHuManDetailHeadVO.PromotionData.Offer> offers = new ArrayList<ZhuHuManDetailHeadVO.PromotionData.Offer>(offerList.size());
            offerList.forEach(h -> {
                ZhuHuManDetailHeadVO.PromotionData.Offer offer = new ZhuHuManDetailHeadVO.PromotionData.Offer();
                BeanUtils.copyProperties((Object)h, (Object)offer);
                offers.add(offer);
            });
            promotionData.setOffer(offers);
        }
        result.setFansData(fansData);
    }
}

