/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.utils;

import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

public class BsonUtil {
    private static Logger logger = LoggerFactory.getLogger(BsonUtil.class);

    public static void main(String[] args) {
        ArrayList<Document> list = new ArrayList<Document>();
        Document document = new Document();
        document.append("id", (Object)100018);
        document.append("label", (Object)"\u65e5\u5e38\u5986\u6559");
        document.append("value", (Object)100018);
        document.append("children", new ArrayList());
        list.add(document);
        ArrayList<Document> list1 = new ArrayList<Document>();
        Document document1 = new Document();
        document1.append("id", (Object)100019);
        document1.append("label", (Object)"\u7f8e\u5986\u6d4b\u8bc4");
        document1.append("value", (Object)100020);
        list1.add(document1);
        document1.append("children", list);
        ArrayList list2 = new ArrayList();
        Document document2 = new Document();
        document2.append("id", (Object)100020);
        document2.append("label", (Object)"\u65e5\u5e38\u7a7f\u642d");
        document2.append("value", (Object)100020);
        document2.append("children", list1);
        ArrayList<Document> aa = new ArrayList<Document>();
        aa.add(document2);
        System.out.println(((Object)aa).toString());
        aa.forEach(a -> {
            List children = (List)a.get((Object)"children", List.class);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                children.forEach(b -> {
                    List sendChildren = (List)b.get((Object)"children", List.class);
                    BsonUtil.toBeans(sendChildren, TopManOptionsEntity.TagCopy.class);
                });
            } else {
                BsonUtil.toBeans(children, TopManOptionsEntity.TagCopy.class);
            }
        });
        List<TopManOptionsEntity.TagCopy> list3 = BsonUtil.toBeans(aa, TopManOptionsEntity.TagCopy.class);
        System.out.println(list3.toString());
    }

    public static <T> List<T> toBeans(List<Document> documents, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; null != documents && i < documents.size(); ++i) {
            list.add(BsonUtil.toBean(documents.get(i), clazz));
        }
        return list;
    }

    public static <T> T toBean(Document document, Class<T> clazz) {
        T entity = null;
        try {
            Field[] fields;
            entity = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                ParameterizedType fc;
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Class<?> fieldClazz = field.getType();
                String key = field.getName();
                Object value = null;
                try {
                    value = field.get(entity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Object val = document.get((Object)key);
                if (val == null) continue;
                if (BsonUtil.isPrimitive(fieldClazz) || fieldClazz == String.class) {
                    if (field == null) continue;
                    field.set(entity, val);
                    continue;
                }
                if (fieldClazz.isArray()) {
                    String itemClazzName = fieldClazz.getTypeName().substring(0, fieldClazz.getTypeName().length() - 2);
                    Class itemClazz = null;
                    try {
                        itemClazz = Class.forName(itemClazzName);
                    }
                    catch (ClassNotFoundException e) {
                        itemClazz = BsonUtil.toPrimitiveClass(itemClazzName);
                    }
                    Object array = BsonUtil.toArray(document.get((Object)key), itemClazz);
                    if (field == null) continue;
                    field.set(entity, array);
                    continue;
                }
                if (List.class.isAssignableFrom(fieldClazz)) {
                    fc = (ParameterizedType)field.getGenericType();
                    TypeVariable<Class<?>>[] types = fieldClazz.getTypeParameters();
                    ArrayList list = (ArrayList)value;
                    if (value == null) {
                        list = new ArrayList();
                        if (field != null) {
                            field.set(entity, list);
                        }
                    }
                    BsonUtil.toList(document.get((Object)key), list, (Class)fc.getActualTypeArguments()[0]);
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldClazz)) {
                    fc = (ParameterizedType)field.getGenericType();
                    HashMap map = (HashMap)value;
                    if (value == null) {
                        map = new HashMap();
                        if (field != null) {
                            field.set(entity, map);
                        }
                    }
                    BsonUtil.toMap(document.get((Object)key), map, (Class)fc.getActualTypeArguments()[0], (Class)fc.getActualTypeArguments()[1]);
                    continue;
                }
                document.put(key, BsonUtil.toBean((Document)val, fieldClazz));
            }
        }
        catch (Exception e) {
            logger.error("toBean() error , clazz:" + clazz.getName(), (Throwable)e);
        }
        return entity;
    }

    public static Document toDocumentForUpdate(Object entity) {
        Document document = new Document();
        document.put("$set", (Object)BsonUtil.toDocument(entity));
        return document;
    }

    public static Document toDocument(Object entity) {
        Field[] fields;
        if (entity == null) {
            return null;
        }
        Document document = new Document();
        Class<?> clazz = entity.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Class<?> fieldClazz = field.getType();
            if (fieldClazz.getAnnotationsByType(Transient.class).length > 0) continue;
            String key = field.getName();
            if ("id".equals(key)) {
                key = "_id";
            }
            Object value = null;
            try {
                value = field.get(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (value == null) continue;
            try {
                ArrayList<Document> listDocument;
                ArrayList values;
                if (BsonUtil.isPrimitive(fieldClazz) || fieldClazz == String.class) {
                    document.put(key, value);
                    continue;
                }
                if (fieldClazz.isArray()) {
                    Object object;
                    int i;
                    String itemClazzName = fieldClazz.getTypeName().substring(0, fieldClazz.getTypeName().length() - 2);
                    Class itemClazz = null;
                    try {
                        itemClazz = Class.forName(itemClazzName);
                    }
                    catch (ClassNotFoundException e) {
                        itemClazz = BsonUtil.toPrimitiveClass(itemClazzName);
                    }
                    int len = Array.getLength(value);
                    if (BsonUtil.isPrimitive(itemClazz) || itemClazz == String.class) {
                        values = new ArrayList();
                        for (i = 0; i < len; ++i) {
                            object = Array.get(value, i);
                            values.add(object);
                        }
                        document.put(key, values);
                        continue;
                    }
                    listDocument = new ArrayList();
                    document.put(key, listDocument);
                    for (i = 0; i < len; ++i) {
                        object = Array.get(value, i);
                        listDocument.add(BsonUtil.toDocument(object));
                    }
                    continue;
                }
                if (List.class.isAssignableFrom(fieldClazz)) {
                    List list = (List)value;
                    ParameterizedType fc = (ParameterizedType)field.getGenericType();
                    Class itemClazz = (Class)fc.getActualTypeArguments()[0];
                    if (BsonUtil.isPrimitive(itemClazz) || itemClazz == String.class) {
                        values = new ArrayList();
                        for (Object object : list) {
                            values.add(object);
                        }
                        document.put(key, values);
                        continue;
                    }
                    listDocument = new ArrayList<Document>();
                    document.put(key, listDocument);
                    for (Object object : list) {
                        listDocument.add(BsonUtil.toDocument(object));
                    }
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldClazz)) {
                    Map map = (Map)field.get(entity);
                    Set entries = map.entrySet();
                    HashMap mpperMap = new HashMap();
                    document.put(key, mpperMap);
                    ParameterizedType fc = (ParameterizedType)field.getGenericType();
                    Class keyClazz = (Class)fc.getActualTypeArguments()[0];
                    if (keyClazz != String.class && !BsonUtil.isPrimitive(keyClazz)) {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684Map,\u8f6c\u6362\u6210document\u7684key\u53ea\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b\u6216\u5b57\u7b26\u4e32");
                    }
                    Class itemClazz = (Class)fc.getActualTypeArguments()[1];
                    if (itemClazz == String.class || BsonUtil.isPrimitive(itemClazz)) {
                        for (Map.Entry entry : entries) {
                            mpperMap.put(entry.getKey().toString(), entry.getValue());
                        }
                        continue;
                    }
                    for (Map.Entry entry : entries) {
                        mpperMap.put(entry.getKey().toString(), BsonUtil.toDocument(entry.getValue()));
                    }
                    continue;
                }
                document.put(key, (Object)BsonUtil.toDocument(value));
            }
            catch (Exception e) {
                logger.error("toDocument() , error clazz=" + entity.getClass().getName(), (Throwable)e);
            }
        }
        return document;
    }

    private static boolean isPrimitive(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return Long.class == clazz || Integer.class == clazz || Double.class == clazz || Float.class == clazz || Short.class == clazz || Boolean.class == clazz;
    }

    private static Object toArray(Object value, Class itemClazz) {
        List list = (List)value;
        Object array = Array.newInstance(itemClazz, list.size());
        int i = 0;
        for (Object object : list) {
            if (object instanceof Document) {
                Array.set(array, i++, BsonUtil.toBean((Document)object, itemClazz));
                continue;
            }
            Array.set(array, i++, object);
        }
        return array;
    }

    private static void toMap(Object value, Map map, Class keyClazz, Class itemClazz) throws InstantiationException, IllegalAccessException {
        Set entries = ((Map)value).entrySet();
        for (Map.Entry entry : entries) {
            Object keyV = entry.getKey().getClass() == String.class ? entry.getKey() : BsonUtil.toPrimitive(entry.getKey().toString(), keyClazz);
            Object itemV = entry.getValue();
            if (itemV instanceof Document) {
                map.put(keyV, BsonUtil.toBean((Document)itemV, itemClazz));
                continue;
            }
            map.put(keyV, itemV);
        }
    }

    private static Object toPrimitive(String value, Class clazz) {
        if (Integer.TYPE == clazz || Integer.class == clazz) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE == clazz || Long.class == clazz) {
            return Long.valueOf(value);
        }
        if (Short.TYPE == clazz || Short.class == clazz) {
            return Short.valueOf(value);
        }
        if (Double.TYPE == clazz || Double.class == clazz) {
            return Double.valueOf(value);
        }
        if (Float.TYPE == clazz || Float.class == clazz) {
            return Float.valueOf(value);
        }
        if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            return Boolean.valueOf(value);
        }
        throw new RuntimeException("Map key nonsupport !!!");
    }

    private static Class toPrimitiveClass(String primitiveClazzName) {
        Class<Constable> itemClazz = null;
        if ("long".equals(primitiveClazzName)) {
            itemClazz = Long.TYPE;
        } else if ("int".equals(primitiveClazzName)) {
            itemClazz = Integer.TYPE;
        } else if ("short".equals(primitiveClazzName)) {
            itemClazz = Short.TYPE;
        } else if ("double".equals(primitiveClazzName)) {
            itemClazz = Double.TYPE;
        } else if ("float".equals(primitiveClazzName)) {
            itemClazz = Float.TYPE;
        } else if ("boolean".equals(primitiveClazzName)) {
            itemClazz = Boolean.TYPE;
        } else {
            throw new RuntimeException("nonsupport type !!!");
        }
        return itemClazz;
    }

    private static void toList(Object value, List list, Class itemClazz) throws InstantiationException, IllegalAccessException {
        if (value.getClass() == Document[].class) {
            Document[] documents;
            for (Document document : documents = (Document[])value) {
                list.add(BsonUtil.toBean(document, itemClazz));
            }
        } else {
            List vals = (List)value;
            for (Object object : vals) {
                list.add(object);
            }
        }
    }
}

