/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.industryinfo.dto.GoodsInformationQueryDTO;
import com.els.modules.industryinfo.entity.GoodsInformation;
import com.els.modules.industryinfo.mapper.GoodsInformationMapper;
import com.els.modules.industryinfo.service.GoodsInformationService;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GoodsInformationServiceImpl
extends BaseServiceImpl<GoodsInformationMapper, GoodsInformation>
implements GoodsInformationService {
    @Override
    public IPage<GoodsInformation> queryPage(Page<GoodsInformation> page, QueryWrapper<GoodsInformation> queryWrapper, GoodsInformationQueryDTO queryDTO) {
        String timeSelect;
        String otherScreening;
        String goodsPrice;
        String goodsRatio = queryDTO.getGoodsCommissionRatio();
        if (StringUtils.isNotBlank((CharSequence)goodsRatio) && goodsRatio.contains("-")) {
            String[] ratio = goodsRatio.split("-");
            queryWrapper.lambda().between(GoodsInformation::getCommissionRatio, (Object)new BigDecimal(ratio[0]), (Object)new BigDecimal(ratio[1]));
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsPrice = queryDTO.getGoodsPrice()))) {
            String price;
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().between(GoodsInformation::getPrice, (Object)new BigDecimal(prices[0]), (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                price = goodsPrice.substring(goodsPrice.indexOf("<") + 1);
                queryWrapper.lambda().lt(GoodsInformation::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                price = goodsPrice.substring(goodsPrice.indexOf(">") + 1);
                queryWrapper.lambda().gt(GoodsInformation::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(otherScreening = queryDTO.getOtherScreening()))) {
            if ("1".equals(otherScreening)) {
                queryWrapper.lambda().isNotNull(GoodsInformation::getLiveGoods);
            } else if ("2".equals(otherScreening)) {
                queryWrapper.lambda().isNotNull(GoodsInformation::getVideoGoods);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(timeSelect = queryDTO.getTimeSelect()))) {
            Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
            queryWrapper.lambda().between(BaseEntity::getUpdateTime, (Object)dates[0], (Object)dates[1]);
        }
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void saveElsGoodsInformation(GoodsInformation goodsInformation) {
        ((GoodsInformationMapper)this.baseMapper).insert((Object)goodsInformation);
    }

    @Override
    public void updateElsGoodsInformation(GoodsInformation goodsInformation) {
        ((GoodsInformationMapper)this.baseMapper).updateById((Object)goodsInformation);
    }
}

