/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.mapper.TopManMsgConfigMapper;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgTaskService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgConfigServiceImpl
extends BaseServiceImpl<TopManMsgConfigMapper, TopManMsgConfig>
implements TopManMsgConfigService {
    @Lazy
    @Autowired
    private TopManMsgTaskService topManMsgTaskService;

    @Override
    public void add(TopManMsgConfig topManMsgConfig) {
        topManMsgConfig.setId(null);
        topManMsgConfig.setDeleted(CommonConstant.STATUS_NO);
        ((TopManMsgConfigMapper)this.baseMapper).insert((Object)topManMsgConfig);
    }

    @Override
    public void edit(TopManMsgConfig topManMsgConfig) {
        int count = ((TopManMsgConfigMapper)this.baseMapper).updateById((Object)topManMsgConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TopManMsgConfig> listBySubAccount(String elsAccount, String subAccount, String platform) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgConfig::getSubAccount, (Object)subAccount)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(TopManMsgConfig::getPlatform, (Object)platform)).orderByAsc(TopManMsgConfig::getSortNum));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveConfigs(List<TopManMsgConfig> configs, String platform) {
        ArrayList add = Lists.newArrayList();
        ArrayList edit = Lists.newArrayList();
        String tenant = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        HashSet newIds = Sets.newHashSet();
        configs.forEach(row -> {
            if (StrUtil.isBlank((CharSequence)row.getId()) || row.getId().indexOf("row") == 0) {
                row.setDeleted(CommonConstant.STATUS_NO);
                row.setSubAccount(loginUser.getSubAccount());
                row.setEmployeeName(loginUser.getRealname());
                row.setDeptNo(loginUser.getOrgCode());
                row.setPlatform(platform);
                row.setId(null);
                add.add(row);
            } else {
                newIds.add(row.getId());
                row.setDeleted(CommonConstant.STATUS_NO);
                edit.add(row);
            }
        });
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgConfig::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)tenant)).notIn(CollUtil.isNotEmpty((Collection)newIds), BaseEntity::getId, (Collection)newIds));
        if (CollUtil.isNotEmpty((Collection)add)) {
            this.saveBatch(add);
        }
        if (CollUtil.isNotEmpty((Collection)edit)) {
            this.updateBatchById(edit);
        }
    }
}

