/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.industryinfo.entity.McnAttachmentEntity;
import com.els.modules.industryinfo.mapper.McnAttachmentMapper;
import com.els.modules.industryinfo.service.McnAttachmentService;
import com.els.modules.industryinfo.utils.HttpRequestUtils;
import com.mongodb.client.MongoCursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class McnAttachmentServiceImpl
extends BaseServiceImpl<McnAttachmentMapper, McnAttachmentEntity>
implements McnAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(McnAttachmentServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";
    @Resource
    private MongoTemplate mongoTemplate;
    private final String MCN_COLLECTION_NAME = "tb_invite_data_detail";
    private final String MCN_HOT_PRODUCT_COLLECTION_NAME = "tb_invite_data_hot_product";
    private final String MCN_CATGORY_DETAIL_COLLECTION_NAME = "tb_invite_data_category_detail";
    private final String MCN_SHOP_COLLECTION_NAME = "tb_invite_data_serve_shop";
    private final int BATCH_SIZE = 500;
    private final String TB_DY_LOGIN_USER = "tb_dy_login_user";

    @Override
    public void upload(JSONObject jsonParam) {
        JSONArray upload = jsonParam.getJSONArray("upload");
        List jsonObjects = upload.toJavaList(JSONObject.class);
        log.info("\u4e0a\u4f20\u56fe\u7247list:" + jsonObjects.toString());
        if (CollectionUtils.isNotEmpty((Collection)jsonObjects)) {
            for (JSONObject jsonObject : jsonObjects) {
                this.uploadFile(jsonObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void uploadFile(JSONObject jsonParam) {
        String topmanId = jsonParam.getString("topmanId");
        Assert.hasText((String)topmanId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8fbe\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a"));
        StringBuilder sb = new StringBuilder("bilibili").append(COLON).append("upload").append(COLON).append(topmanId);
        String id = (String)this.redisUtil.get(sb.toString());
        if (id == null) {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"status").is((Object)"1"));
            criteriaList.add(Criteria.where((String)"web_server").is((Object)"1"));
            criteriaList.add(Criteria.where((String)"type").is((Object)"B\u7ad9\u82b1\u706b"));
            Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList.toArray(new Criteria[0])));
            Map cookieMap = (Map)this.mongoTemplate.findOne(query, Map.class, "tb_dy_login_user");
            String platform = jsonParam.getString("platform");
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
            String url = jsonParam.getString("url");
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"url\u4e0d\u80fd\u4e3a\u7a7a"));
            String path = jsonParam.getString("path");
            Assert.hasText((String)path, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a"));
            CloseableHttpClient client = null;
            HttpGet request = new HttpGet(url);
            try {
                client = HttpClients.createDefault();
                InputStream inputStream = HttpRequestUtils.httpGetImg(request, client, cookieMap.get("cookies").toString());
                byte[] bytes = McnAttachmentServiceImpl.inputStreamToByteArray(inputStream);
                StorageFileInfo fileInfo = new StorageFileInfo();
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
                String nowday = dtf.format(time);
                String documentName = topmanId + ".jpg";
                documentName = documentName.replaceAll("-", "_");
                String documentType = "";
                String documentLocation = File.separator + "mcn" + File.separator + platform + File.separator + path + File.separator + "pic" + File.separator + documentName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
                savePath = savePath.replaceAll(" ", "_");
                fileInfo.setPath(savePath);
                fileInfo.setFilename(documentName);
                fileInfo.setOriginalFilename(documentName);
                fileInfo = this.fileStoreSignServiceImpl.storeFile((InputStream)new ByteArrayInputStream(bytes), fileInfo, (String)null);
                McnAttachmentEntity attachment = new McnAttachmentEntity();
                attachment.setTopmanId(topmanId);
                attachment.setId(topmanId);
                attachment.setPlatform(platform);
                attachment.setFileName(fileInfo.getOriginalFilename());
                attachment.setFileSize(bytes.length);
                attachment.setFilePath(fileInfo.getPath());
                attachment.setTopmanAvatar(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), fileInfo.getSaveType()));
                boolean b = this.saveOrUpdate((Object)attachment);
                log.info("\u56fe\u7247\u4e0a\u4f20\u6210\u529fbbbbbbbbbbbbbbbbbbbb:" + b + "attachment");
                if (b) {
                    this.redisUtil.set(sb.toString(), (Object)topmanId, 72000000L);
                    log.info("\u8fbe\u4ebaid:" + topmanId + ":\u4e0a\u4f20\u6210\u529f:" + (Object)((Object)attachment));
                }
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                        request.releaseConnection();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean deleteBatch(String ids) {
        List mcnAttachmentEntities;
        List list = this.list();
        List bStationId = list.stream().map(McnAttachmentEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(mcnAttachmentEntities = this.listByIds(bStationId)))) {
            for (McnAttachmentEntity purchaseAttachment : mcnAttachmentEntities) {
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        this.removeByIds(idList);
        return b;
    }

    @Override
    public boolean delete(String path) {
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(path);
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        log.info("aaaaaaaaaaaaaaaaaaaaaaaaaaaa:" + b);
        return b;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getImage(String type) {
        var2_2 = type;
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 49: {
                if (!var2_2.equals("1")) break;
                var3_3 = 0;
                break;
            }
            case 50: {
                if (!var2_2.equals("2")) break;
                var3_3 = 1;
                break;
            }
            case 51: {
                if (!var2_2.equals("3")) break;
                var3_3 = 2;
            }
        }
        switch (var3_3) {
            case 0: {
                list = new ArrayList<String>();
                try {
                    cursor = this.mongoTemplate.getCollection("tb_invite_data_detail").find().noCursorTimeout(true).batchSize(500).cursor();
                    var6_8 = null;
                    while (cursor.hasNext()) {
                        doc = (Document)cursor.next();
                        list.add(doc.getString((Object)"ins_id"));
                    }
                    this.uploadImage(list, "organ/head");
                    McnAttachmentServiceImpl.log.info("\u62db\u5546\u56e2\u957fcccccccccccccc:" + list.toString());
                    if (cursor == null) break;
                    if (var6_8 == null) ** GOTO lbl37
                    try {
                        cursor.close();
                    }
                    catch (Throwable doc) {
                        var6_8.addSuppressed(doc);
                    }
                    break;
lbl37:
                    // 1 sources

                    cursor.close();
                    ** break;
                    catch (Throwable doc) {
                        try {
                            var6_8 = doc;
                            throw doc;
                        }
                        catch (Throwable var8_15) {
                            if (cursor != null) {
                                if (var6_8 != null) {
                                    try {
                                        cursor.close();
                                    }
                                    catch (Throwable var9_17) {
                                        var6_8.addSuppressed(var9_17);
                                    }
                                } else {
                                    cursor.close();
                                }
                            }
                            throw var8_15;
lbl54:
                            // 1 sources

                        }
                    }
                }
                catch (Exception e) {
                    McnAttachmentServiceImpl.log.error("McnOrganizationJob error", (Throwable)e);
                }
                break;
            }
            case 1: {
                cateIdMap = new HashMap<String, String>();
                IdMap = new HashMap<String, String>();
                try {
                    cursor = this.mongoTemplate.getCollection("tb_invite_data_category_detail").find().noCursorTimeout(true).batchSize(500).cursor();
                    var8_16 = null;
                    try {
                        while (cursor.hasNext()) {
                            doc = (Document)cursor.next();
                            cateIdMap.put(doc.getString((Object)"cate_id"), doc.getString((Object)"cate_id"));
                            IdMap.put(doc.getString((Object)"_id"), doc.getString((Object)"_id"));
                        }
                    }
                    catch (Throwable var9_20) {
                        var8_16 = var9_20;
                        throw var9_20;
                    }
                    finally {
                        if (cursor != null) {
                            if (var8_16 != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable var9_19) {
                                    var8_16.addSuppressed(var9_19);
                                }
                            } else {
                                cursor.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    McnAttachmentServiceImpl.log.error("McnOrganizationJob error", (Throwable)e);
                }
                cateId = new ArrayList<K>(cateIdMap.keySet());
                IdList = new ArrayList<K>(IdMap.keySet());
                IdList.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getImage$0(java.lang.String ), (Ljava/lang/String;)V)((McnAttachmentServiceImpl)this));
                break;
            }
            case 2: {
                this.uploadImage(null, "bilibili");
            }
        }
    }

    @Override
    public void cleanCache() {
        StringBuilder sb = new StringBuilder("bilibili").append(COLON).append("upload");
        this.redisUtil.dels(sb.toString());
    }

    private void uploadImage(List<String> ids, String rePath) {
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            list = this.listByIds(ids);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(McnAttachmentEntity::getPlatform, (Object)"4");
            list = this.list((Wrapper)queryWrapper);
        }
        list.forEach(a -> {
            String bb = a.getFilePath();
            try {
                InputStream inputStream = HttpRequestUtils.httpGet(a.getTopmanAvatar(), new HashMap<String, Object>());
                byte[] bytes = McnAttachmentServiceImpl.inputStreamToByteArray(inputStream);
                StorageFileInfo fileInfo = new StorageFileInfo();
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
                String nowday = dtf.format(time);
                String documentName = a.getTopmanId() + ".jpg";
                documentName = documentName.replaceAll("-", "_");
                String documentType = "";
                String documentLocation = File.separator + "mcn" + File.separator + a.getPlatform() + File.separator + rePath + File.separator + "pic" + File.separator + documentName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
                savePath = savePath.replaceAll(" ", "_");
                fileInfo.setPath(savePath);
                fileInfo.setFilename(documentName);
                fileInfo.setOriginalFilename(documentName);
                fileInfo = this.fileStoreSignServiceImpl.storeFile((InputStream)new ByteArrayInputStream(bytes), fileInfo, (String)null);
                McnAttachmentEntity attachment = new McnAttachmentEntity();
                attachment.setTopmanId(a.getTopmanId());
                attachment.setId(a.getTopmanId());
                attachment.setPlatform(a.getPlatform());
                attachment.setFileName(fileInfo.getOriginalFilename());
                attachment.setFileSize(bytes.length);
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType("storage");
                attachment.setTopmanAvatar(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), fileInfo.getSaveType()));
                boolean b = this.saveOrUpdate((Object)attachment);
                log.info("bbbbbbbbbbbbbbbbbbbb", (Object)b);
                if (b) {
                    ArrayList<String> filePaths = new ArrayList<String>();
                    filePaths.add(bb);
                    boolean bl = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
                }
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inputStreamToByteArray(InputStream inputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int num;
            byte[] buffer = new byte[1024];
            while ((num = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, num);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String url = "https://mcn-sit.51qqt.com/opt/upFiles/pic/7139684376792367391.jpg";
        try {
            InputStream inputStream = HttpRequestUtils.httpGet(url, new HashMap<String, Object>());
            long length = McnAttachmentServiceImpl.inputStreamToByteArray(inputStream).length;
            File file = new File("E:\\\u4f01\u4f01\u901a\u5de5\u4f5c\\mcn\u9879\u76ee\u6587\u6863\\aa\\dd.jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int len = 0;
            byte[] data = new byte[1024];
            while ((len = inputStream.read(data)) != -1) {
                fileOutputStream.write(data, 0, len);
            }
            fileOutputStream.close();
            System.out.println(length);
            inputStream.close();
            System.out.println("ok");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$getImage$0(String a) {
        String days;
        Throwable throwable;
        MongoCursor cursor;
        Document inquerDoc = new Document();
        inquerDoc.append("cate_id", (Object)a);
        try {
            cursor = this.mongoTemplate.getCollection("tb_invite_data_hot_product").find((Bson)inquerDoc).noCursorTimeout(true).batchSize(500).cursor();
            throwable = null;
            try {
                ArrayList<String> productList7days = new ArrayList<String>();
                ArrayList<String> productList30days = new ArrayList<String>();
                ArrayList<String> productList90days = new ArrayList<String>();
                while (cursor.hasNext()) {
                    Document docaa = (Document)cursor.next();
                    switch (days = docaa.getString((Object)"days")) {
                        case "7days": {
                            productList7days.add(docaa.getString((Object)"product_id"));
                            break;
                        }
                        case "30days": {
                            productList30days.add(docaa.getString((Object)"product_id"));
                            break;
                        }
                        case "90days": {
                            productList90days.add(docaa.getString((Object)"product_id"));
                        }
                    }
                }
                this.uploadImage(productList7days, "organ/product/7");
                this.uploadImage(productList30days, "organ/product/30");
                this.uploadImage(productList90days, "organ/product/90");
            }
            catch (Throwable productList7days) {
                throwable = productList7days;
                throw productList7days;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable productList7days) {
                            throwable.addSuppressed(productList7days);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("McnOrganizationJob error", (Throwable)e);
        }
        try {
            cursor = this.mongoTemplate.getCollection("tb_invite_data_serve_shop").find((Bson)inquerDoc).noCursorTimeout(true).batchSize(500).cursor();
            throwable = null;
            try {
                ArrayList<String> shopList7days = new ArrayList<String>();
                ArrayList<String> shopList30days = new ArrayList<String>();
                ArrayList<String> shopList90days = new ArrayList<String>();
                while (cursor.hasNext()) {
                    Document docbb = (Document)cursor.next();
                    switch (days = docbb.getString((Object)"days")) {
                        case "7days": {
                            shopList7days.add(docbb.getString((Object)"shop_id"));
                            break;
                        }
                        case "30days": {
                            shopList30days.add(docbb.getString((Object)"shop_id"));
                            break;
                        }
                        case "90days": {
                            shopList90days.add(docbb.getString((Object)"shop_id"));
                        }
                    }
                }
                this.uploadImage(shopList7days, "organ/shop/7");
                this.uploadImage(shopList30days, "organ/shop/30");
                this.uploadImage(shopList90days, "organ/shop/90");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("McnOrganizationJob error", (Throwable)e);
        }
    }
}

