/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.BlogTopManCollectDTO;
import com.els.modules.industryinfo.entity.BlogTopManInformationBasicAnalysisEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationFanAnalysisEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationFanTrendEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationMicroAnalysisEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationPromotionAnalysisEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationTopDetailsEntity;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.mapper.BlogTopManInformationMapper;
import com.els.modules.industryinfo.service.BlogTopManInformationService;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.utils.HttpRequestUtils;
import com.els.modules.industryinfo.vo.BlogRequestParamVO;
import com.els.modules.industryinfo.vo.BlogTopManInformationVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BlogTopManInformationServiceImpl
implements BlogTopManInformationService {
    private static final Logger log = LoggerFactory.getLogger(BlogTopManInformationServiceImpl.class);
    @Value(value="${bs.ipAddress}")
    private String ipAddress;
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";
    private static final String BLOG = "blog";
    @Autowired
    private BlogTopManInformationMapper baseMapper;
    @Autowired
    private TopManCollectService topManCollectService;

    @Override
    public Object getOptions(String type) {
        List categoryList = new ArrayList();
        switch (type) {
            case "allTopMan": {
                String urlCategory = this.ipAddress + "/micro/blog/task/api/category";
                JSONObject allJsonObject = HttpRequestUtils.doPost(urlCategory, "");
                JSONArray allData = allJsonObject.getJSONArray("data");
                categoryList = allData.toJavaList(Object.class);
                break;
            }
            case "collectTopMan": {
                String collectCategory = this.ipAddress + "/micro/blog/task/api/category";
                JSONObject collectJsonObject = HttpRequestUtils.doPost(collectCategory, "");
                JSONArray collectData = collectJsonObject.getJSONArray("data");
                categoryList = collectData.toJavaList(Object.class);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return categoryList;
    }

    @Override
    public IPage<BlogTopManInformationEntity> queryTopManList(SimplePostRequestParam<BlogTopManInformationVO> topManDto) throws Exception {
        Page page;
        BlogTopManInformationVO filterInfo = (BlogTopManInformationVO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        BlogTopManInformationEntity blogTopManInformation = new BlogTopManInformationEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuilder redisKey = new StringBuilder(BLOG).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON);
        String param = BlogTopManInformationServiceImpl.apiGetList(taskType, topManDto, blogTopManInformation, (QueryWrapper<BlogTopManInformationEntity>)queryWrapper, redisKey);
        redisKey.append(taskType).append(COLON).append(topManDto.getPageNo()).append(COLON).append(topManDto.getPageSize());
        switch (taskType) {
            case "allTopMan": {
                page = (Page)this.redisUtil.get(redisKey.toString());
                if (page != null) break;
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                String urlVideo = this.ipAddress + "/micro/blog/task/api/list";
                JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, param);
                if (jsonObjectVideo == null || jsonObjectVideo.size() == 0) {
                    return page;
                }
                JSONArray dataVideo = jsonObjectVideo.getJSONArray("data");
                List blogTopManInformationEntityList = dataVideo.toJavaList(BlogTopManInformationEntity.class);
                page.setTotal((long)jsonObjectVideo.getInteger("total").intValue());
                this.handleResult(blogTopManInformationEntityList, filterInfo.getPlatformType());
                page.setRecords(blogTopManInformationEntityList);
                if (!CollectionUtils.isNotEmpty((Collection)blogTopManInformationEntityList)) break;
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
                break;
            }
            case "collectTopMan": {
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                page = this.baseMapper.selectCollectTopMan((IPage<BlogTopManInformationEntity>)page, (Wrapper<BlogTopManInformationEntity>)queryWrapper, SysUtil.getLoginUser(), blogTopManInformation);
                break;
            }
            default: {
                throw new ELSBootException("\u8be5\u8bf7\u6c42\u4e0d\u5408\u6cd5");
            }
        }
        return page;
    }

    @Override
    public BlogTopManInformationTopDetailsEntity blogTopManDetails(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("c", "Kol.info");
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlVideo = this.ipAddress + "/micro/blog/task/api/top/core/details";
        JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, jsonString);
        BlogTopManInformationTopDetailsEntity.TopManInfo topManInfo = (BlogTopManInformationTopDetailsEntity.TopManInfo)jsonObjectVideo.toJavaObject(BlogTopManInformationTopDetailsEntity.TopManInfo.class);
        BlogTopManInformationTopDetailsEntity.TopManCoreData topManCoreData = (BlogTopManInformationTopDetailsEntity.TopManCoreData)jsonObjectVideo.toJavaObject(BlogTopManInformationTopDetailsEntity.TopManCoreData.class);
        BlogTopManInformationTopDetailsEntity blogTopManInformationDetails = new BlogTopManInformationTopDetailsEntity();
        blogTopManInformationDetails.setTopManInfo(topManInfo);
        blogTopManInformationDetails.setTopManCoreData(topManCoreData);
        List<String> ids = Arrays.asList(topManInfo.getTopmanId());
        List<BlogTopManInformationEntity> blogTopManInformationEntityList = this.baseMapper.checkAddedAndCollect(ids, SysUtil.getLoginUser(), "5");
        if (CollectionUtils.isNotEmpty(blogTopManInformationEntityList)) {
            blogTopManInformationDetails.setIsAdded(blogTopManInformationEntityList.get(0).getIsAdded());
            blogTopManInformationDetails.setIsCollection(blogTopManInformationEntityList.get(0).getIsCollection());
        }
        return blogTopManInformationDetails;
    }

    @Override
    public BlogTopManInformationBasicAnalysisEntity blogTopManBasicAnalysisChartEntity(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/micro/blog/task/api/base/analysis";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONObject jsonComment = jsonObject.getJSONObject("comment");
        JSONArray commentPost = jsonComment.getJSONArray("post");
        List chartCommenPostList = commentPost.toJavaList(BlogTopManInformationBasicAnalysisEntity.Chart.class);
        JSONArray commentForward = jsonComment.getJSONArray("forward");
        List chartCommenForwardList = commentForward.toJavaList(BlogTopManInformationBasicAnalysisEntity.Chart.class);
        JSONObject jsonLike = jsonObject.getJSONObject("like");
        JSONArray likePost = jsonLike.getJSONArray("post");
        List chartLikePostList = likePost.toJavaList(BlogTopManInformationBasicAnalysisEntity.Chart.class);
        JSONArray likeForward = jsonLike.getJSONArray("forward");
        List chartLikeForwardList = likeForward.toJavaList(BlogTopManInformationBasicAnalysisEntity.Chart.class);
        JSONObject jsonRepost = jsonObject.getJSONObject("repost");
        JSONArray repostPost = jsonRepost.getJSONArray("post");
        List chartRepostPostList = repostPost.toJavaList(BlogTopManInformationBasicAnalysisEntity.Chart.class);
        JSONArray repostForward = jsonRepost.getJSONArray("forward");
        List chartRepostForwardList = repostForward.toJavaList(BlogTopManInformationBasicAnalysisEntity.Chart.class);
        BlogTopManInformationBasicAnalysisEntity basicAnalysis = new BlogTopManInformationBasicAnalysisEntity();
        basicAnalysis.setCommentPost(chartCommenPostList);
        basicAnalysis.setCommentForward(chartCommenForwardList);
        basicAnalysis.setLikePost(chartLikePostList);
        basicAnalysis.setLikeForward(chartLikeForwardList);
        basicAnalysis.setRepostPost(chartRepostPostList);
        basicAnalysis.setRepostForward(chartRepostForwardList);
        return basicAnalysis;
    }

    @Override
    public BlogTopManInformationFanAnalysisEntity blogTopManFanAnalysisDetails(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/micro/blog/task/api/fan/portrait";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        ArrayList<String> fanOverview = new ArrayList<String>();
        BlogTopManInformationFanAnalysisEntity.Gender gender = (BlogTopManInformationFanAnalysisEntity.Gender)jsonObject.getObject("active_fans_gender", BlogTopManInformationFanAnalysisEntity.Gender.class);
        int i = gender.getMale().compareTo(gender.getFemale());
        switch (i) {
            case 1: {
                fanOverview.add("\u7537\u6027 \u5c45\u591a");
                break;
            }
            case 0: {
                fanOverview.add("\u7537\u5973\u6027 \u6bd4\u4f8b\u76f8\u7b49");
                break;
            }
            case -1: {
                fanOverview.add("\u5973\u6027 \u5c45\u591a");
            }
        }
        JSONArray fanAge = jsonObject.getJSONArray("active_fans_age");
        List fanAgeList = fanAge.toJavaList(BlogTopManInformationFanAnalysisEntity.Fan.class);
        BlogTopManInformationFanAnalysisEntity.Fan fanAgeMany = fanAgeList.stream().max(Comparator.comparing(BlogTopManInformationFanAnalysisEntity.Fan::getValue)).get();
        fanOverview.add(fanAgeMany.getName() + " \u5c81\u5c45\u591a");
        JSONArray fanRegion = jsonObject.getJSONArray("active_fans_area");
        List fanRegionList = fanRegion.toJavaList(BlogTopManInformationFanAnalysisEntity.Fan.class);
        List fanRegionMany = fanRegionList.stream().sorted(Comparator.comparing(BlogTopManInformationFanAnalysisEntity.Fan::getValue).reversed()).collect(Collectors.toList());
        List fanRegionTopThree = fanRegionMany.subList(0, 3);
        String nameString = fanRegionTopThree.stream().map(p -> p.getName()).collect(Collectors.joining(" "));
        fanOverview.add(nameString + " \u7701\u4efd\u5c45\u591a");
        JSONArray fanInterest = jsonObject.getJSONArray("interest");
        List fanInterestList = fanInterest.toJavaList(BlogTopManInformationFanAnalysisEntity.Fan.class);
        List fanInterestMany = fanInterestList.stream().sorted(Comparator.comparing(BlogTopManInformationFanAnalysisEntity.Fan::getValue).reversed()).collect(Collectors.toList());
        List fanInterestTopThree = fanInterestMany.subList(0, 3);
        String region = fanInterestTopThree.stream().map(p -> p.getName()).collect(Collectors.joining(" "));
        fanOverview.add(region + " \u7c7b\u578b\u504f\u597d\u5c45\u591a");
        BlogTopManInformationFanAnalysisEntity blogTopManInformationFanAnalysis = new BlogTopManInformationFanAnalysisEntity();
        blogTopManInformationFanAnalysis.setFanAge(fanAgeList);
        blogTopManInformationFanAnalysis.setFansRegoin(fanRegionList);
        blogTopManInformationFanAnalysis.setFanInterest(fanInterestList);
        blogTopManInformationFanAnalysis.setGender(gender);
        blogTopManInformationFanAnalysis.setFanOverview(fanOverview);
        return blogTopManInformationFanAnalysis;
    }

    @Override
    public BlogTopManInformationFanTrendEntity blogTopManInformationFanTrend(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/micro/blog/task/api/fan/portrait/chart";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray totalList = jsonObject.getJSONArray("total");
        List chartTotal = totalList.toJavaList(BlogTopManInformationFanTrendEntity.Chart.class);
        JSONArray incrementList = jsonObject.getJSONArray("increment");
        List chartIncrement = incrementList.toJavaList(BlogTopManInformationFanTrendEntity.Chart.class);
        BlogTopManInformationFanTrendEntity blogTopManInformationFanTrend = new BlogTopManInformationFanTrendEntity();
        blogTopManInformationFanTrend.setTotal(chartTotal);
        blogTopManInformationFanTrend.setIncrement(chartIncrement);
        return blogTopManInformationFanTrend;
    }

    @Override
    public List<BlogTopManInformationMicroAnalysisEntity> blogTopManInformationMicroOriginalAndHot(String topmanId, String pageNo, String type) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("page", pageNo);
        param.put("uid", topmanId);
        String url = null;
        switch (type) {
            case "0": {
                param.put("feature", "0");
                url = "/micro/blog/task/api/original/analysis";
                break;
            }
            case "1": {
                param.put("feature", "1");
                url = "/micro/blog/task/api/original/analysis";
                break;
            }
            case "2": {
                param.put("feature", "2");
                url = "/micro/blog/task/api/hot/analysis";
                break;
            }
        }
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + url;
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray data = jsonObject.getJSONArray("data");
        List blogTopManInformationMicroAnalysisEntities = data.toJavaList(BlogTopManInformationMicroAnalysisEntity.class);
        return blogTopManInformationMicroAnalysisEntities;
    }

    @Override
    public BlogTopManInformationPromotionAnalysisEntity blogTopManInformationPromotionAnalysis(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("c", "Kol.info");
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.ipAddress + "/micro/blog/task/api/promotion/analysis";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray data = jsonObject.getJSONArray("price");
        List promotions = data.toJavaList(BlogTopManInformationPromotionAnalysisEntity.Promotion.class);
        JSONArray putInfo = jsonObject.getJSONArray("putInfo");
        List strings = putInfo.toJavaList(String.class);
        BlogTopManInformationPromotionAnalysisEntity blogTopManInformationPromotionAnalysis = new BlogTopManInformationPromotionAnalysisEntity();
        blogTopManInformationPromotionAnalysis.setPrice(promotions);
        blogTopManInformationPromotionAnalysis.setPutInfo(strings);
        return blogTopManInformationPromotionAnalysis;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(BlogTopManCollectDTO dto) {
        BlogTopManInformationEntity entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            QueryWrapper query = new QueryWrapper();
            query.lambda().eq(BlogTopManInformationEntity::getTopmanId, (Object)entity.getTopmanId());
            BlogTopManInformationEntity blogTopManInformation = (BlogTopManInformationEntity)this.baseMapper.selectOne((Wrapper)query);
            if (blogTopManInformation == null) {
                entity.setPlatform("5");
                entity.setId("");
                this.baseMapper.insert(entity);
            } else {
                entity.setId(blogTopManInformation.getId());
                this.baseMapper.updateById(entity);
            }
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(entity.getTopmanId());
            topManCollectBean.setPlatform("5");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"5");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getTopmanId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
        StringBuilder listRedisKey = new StringBuilder(BLOG).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list");
        this.redisUtil.dels(listRedisKey.toString());
    }

    @Override
    public void addMarkToSpider(BlogTopManCollectDTO dto) {
        BlogTopManInformationEntity entity = dto.getEntity();
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(BlogTopManInformationEntity::getTopmanId, (Object)entity.getTopmanId());
        BlogTopManInformationEntity blogTopManInformation = (BlogTopManInformationEntity)this.baseMapper.selectOne((Wrapper)query);
        if (blogTopManInformation == null) {
            entity.setPlatform("5");
            entity.setId("");
            this.baseMapper.insert(entity);
        } else {
            entity.setId(blogTopManInformation.getId());
            this.baseMapper.updateById(entity);
        }
        StringBuilder redisKey = new StringBuilder(BLOG).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list");
        this.redisUtil.dels(redisKey.toString());
    }

    private void handleResult(List<BlogTopManInformationEntity> data, String platform) {
        List<String> topmanId = data.stream().map(BlogTopManInformationEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<BlogTopManInformationEntity> addedAndCollects = this.baseMapper.checkAddedAndCollect(topmanId, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(BlogTopManInformationEntity::getTopmanId, h -> h, (k1, k2) -> k1));
        }
        for (BlogTopManInformationEntity topManInfo : data) {
            if (!map.containsKey(topManInfo.getTopmanId())) continue;
            BlogTopManInformationEntity info = (BlogTopManInformationEntity)map.get(topManInfo.getTopmanId());
            topManInfo.setIsCollection(info.getIsCollection());
            topManInfo.setIsAdded(info.getIsAdded());
        }
    }

    private static String apiGetList(String taskType, SimplePostRequestParam<BlogTopManInformationVO> topManDto, BlogTopManInformationEntity blogTopManInformation, QueryWrapper<BlogTopManInformationEntity> queryWrapper, StringBuilder cacheKey) throws Exception {
        BlogTopManInformationVO.ScreenItem screenItem;
        BlogTopManInformationVO filterInfo = (BlogTopManInformationVO)topManDto.getFilterInfo();
        BlogRequestParamVO blogRequestParamVO = new BlogRequestParamVO();
        blogRequestParamVO.setList_type("weibo");
        blogRequestParamVO.setPage(topManDto.getPageNo());
        blogRequestParamVO.setLimit(topManDto.getPageSize());
        String keyWord = topManDto.getKeyWord();
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            blogRequestParamVO.setNick(keyWord.trim());
            queryWrapper.lambda().eq(BlogTopManInformationEntity::getTopmanName, (Object)keyWord.trim());
            cacheKey.append(keyWord.trim()).append(COLON);
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<BlogTopManInformationVO.ScreenItemField> putInfo;
            List<BlogTopManInformationVO.ScreenItemField> talentInfo;
            List<BlogTopManInformationVO.ScreenItemField> talentType = screenItem.getTalentType();
            if (CollectionUtils.isNotEmpty(talentType)) {
                String value = talentType.get(0).getId().toString();
                blogRequestParamVO.setAccount_type(value);
                blogTopManInformation.setTopmanType(talentType.get(0).getTitle().trim());
                cacheKey.append("talentType").append(COLON).append(value).append(COLON);
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u7c89\u4e1d\u603b\u6570": {
                            BlogTopManInformationServiceImpl.getFanParam(a.getValue().toString(), blogRequestParamVO, queryWrapper, cacheKey);
                            break;
                        }
                        case "\u5fae\u535a\u8ba4\u8bc1": {
                            String blogAuthentication = a.getValue().toString();
                            blogRequestParamVO.setAccount_vertify(a.getValue().toString());
                            queryWrapper.lambda().eq(BlogTopManInformationEntity::getBlogAuthentication, (Object)blogAuthentication);
                            cacheKey.append("talentInfo").append(COLON).append(blogAuthentication).append(COLON);
                            break;
                        }
                        case "\u5fae\u535a\u5f71\u54cd\u529b": {
                            String blogInfluence = a.getValue().toString();
                            blogRequestParamVO.setInfluence(blogInfluence);
                            queryWrapper.lambda().eq(BlogTopManInformationEntity::getBlogInfluence, (Object)blogInfluence);
                            cacheKey.append("talentInfo").append(COLON).append(blogInfluence).append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(putInfo = screenItem.getPutInfo())) {
                putInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u539f\u53d1\u62a5\u4ef7": {
                            BlogTopManInformationServiceImpl.getPutParam(a.getValue().toString(), title, blogRequestParamVO, queryWrapper, cacheKey);
                            blogRequestParamVO.setSend_type("1");
                            break;
                        }
                        case "\u8f6c\u53d1\u62a5\u4ef7": {
                            BlogTopManInformationServiceImpl.getPutParam(a.getValue().toString(), title, blogRequestParamVO, queryWrapper, cacheKey);
                            blogRequestParamVO.setSend_type("2");
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
        }
        BlogTopManInformationServiceImpl.sort(topManDto, blogRequestParamVO, queryWrapper);
        String json = JSON.toJSONString((Object)blogRequestParamVO);
        log.info("\u5fae\u535a\u5165\u53c2aaaaaaaaaaaaaa=" + json);
        return json;
    }

    public static void getFanParam(Object str, BlogRequestParamVO blogRequestParamVO, QueryWrapper<BlogTopManInformationEntity> queryWrapper, StringBuilder cacheKey) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setFans_count("0-" + split[1]);
            queryWrapper.lambda().lt(BlogTopManInformationEntity::getFanTotal, (Object)split[1]);
            cacheKey.append("talentInfo").append(COLON).append(split[1]).append(COLON);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setFans_count(split[0] + "-0");
            queryWrapper.lambda().gt(BlogTopManInformationEntity::getFanTotal, (Object)split[0]);
            cacheKey.append("talentInfo").append(COLON).append(split[0]).append(COLON);
        } else {
            String[] split = value.split("-");
            blogRequestParamVO.setFans_count(value);
            queryWrapper.lambda().between(BlogTopManInformationEntity::getFanTotal, (Object)split[0], (Object)split[1]);
            cacheKey.append("talentInfo").append(COLON).append(split[0]).append(COLON).append(split[1]).append(COLON);
        }
    }

    public static void getPutParam(Object str, String type, BlogRequestParamVO blogRequestParamVO, QueryWrapper<BlogTopManInformationEntity> queryWrapper, StringBuilder cacheKey) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setSend_price("0-" + split[1]);
            queryWrapper.lt((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[1]);
            cacheKey.append("putInfo").append(COLON).append(split[1]).append(COLON);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setSend_price(split[0] + "-0");
            queryWrapper.gt((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[0]);
            cacheKey.append("putInfo").append(COLON).append(split[0]).append(COLON);
        } else {
            String[] split = value.split("-");
            blogRequestParamVO.setSend_price(value);
            queryWrapper.between((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[0], (Object)split[1]);
            cacheKey.append("putInfo").append(COLON).append(split[0]).append(COLON).append(split[1]).append(COLON);
        }
    }

    public static void sort(SimplePostRequestParam<BlogTopManInformationVO> topManDto, BlogRequestParamVO blogRequestParamVO, QueryWrapper<BlogTopManInformationEntity> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn()) && !"default".equals(topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            switch (column) {
                case "microTaskIndex": {
                    blogRequestParamVO.setWrw_index_order(order ? "asc" : "desc");
                    queryWrapper.orderBy(true, order, (Object[])new String[]{BlogTopManInformationServiceImpl.camelToUnderline(column)});
                    break;
                }
                case "fanTotal": {
                    blogRequestParamVO.setFans_count_order(order ? "asc" : "desc");
                    queryWrapper.orderBy(true, order, (Object[])new String[]{BlogTopManInformationServiceImpl.camelToUnderline(column)});
                    break;
                }
                default: {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{BlogTopManInformationServiceImpl.camelToUnderline(column)});
                    break;
                }
            }
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"collect_update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static void main(String[] args) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("c", "Kol.info");
        param.put("kol_uid", "5456865382");
        String jsonString = JSON.toJSONString(param);
        String urlDetails = "http://192.168.20.62:8088/micro/blog/task/api/promotion/analysis";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray data = jsonObject.getJSONArray("price");
        List promotions = data.toJavaList(BlogTopManInformationPromotionAnalysisEntity.Promotion.class);
        JSONArray putInfo = jsonObject.getJSONArray("putInfo");
        List strings = putInfo.toJavaList(String.class);
        BlogTopManInformationPromotionAnalysisEntity blogTopManInformationPromotionAnalysis = new BlogTopManInformationPromotionAnalysisEntity();
        blogTopManInformationPromotionAnalysis.setPrice(promotions);
        blogTopManInformationPromotionAnalysis.setPutInfo(strings);
        System.out.println("aaaaaaaaaaa=" + blogTopManInformationPromotionAnalysis);
    }
}

