/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    public static InputStream httpGet(String url, Map<String, Object> param) throws IOException {
        String paramJson = JSON.toJSONString(param);
        System.out.println("paramJson=" + paramJson);
        URL urlConnect = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlConnect.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.connect();
        InputStream inputStream = conn.getInputStream();
        return inputStream;
    }

    public static String httpPost(String url, Map<String, String> map, String encoding) throws Exception {
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = "UTF-8";
        }
        String body = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, encoding));
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    public static JSONObject doPost(String url, String json) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        JSONObject response = null;
        try {
            StringEntity s = new StringEntity(json, "UTF-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json,text/plain,*/*");
            post.setEntity((HttpEntity)s);
            post.getParams().setParameter("http.connection.timeout", (Object)50000);
            post.getParams().setParameter("http.socket.timeout", (Object)50000);
            CloseableHttpResponse res = client.execute((HttpUriRequest)post);
            if (res.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = res.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject.getInteger("status") == 500) {
                    return response;
                }
                response = jsonObject.getJSONObject("result");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static InputStream httpGetImg(HttpGet request, CloseableHttpClient client, String cookies) {
        HashMap headMap = new HashMap();
        String headers = JSON.toJSONString(headMap);
        InputStream in = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(50000).build();
        request.setHeader("accept", "application/json,text/plain,*/*");
        request.setHeader("accept-encoding", "gzip, deflate, br");
        request.setHeader("accept-language", "zh-CN,zh;q=0.9");
        request.setHeader("bid-grey", "1");
        request.setHeader("cookie", cookies);
        request.setHeader("referer", "https://huahuo.bilibili.com/");
        request.setHeader("sec-ch-ua", "\"Chromium\";v=\"104\", \" Not A;Brand\";v=\"99\", \"Google Chrome\";v=\"104\"");
        request.setHeader("sec-ch-ua-mobile", "?0");
        request.setHeader("sec-ch-ua-platform", "Windows");
        request.setHeader("sec-fetch-dest", "empty");
        request.setHeader("sec-fetch-mode", "cors");
        request.setHeader("sec-fetch-site", "same-origin");
        request.setHeader("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36");
        request.setConfig(requestConfig);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (200 == response.getStatusLine().getStatusCode()) {
                HttpEntity entity = response.getEntity();
                in = entity.getContent();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return in;
    }
}

